;*****************************************************************************
; 	All rights reserved by Dipl.-Ing (FH) Andreas Hoeger
;	Ditzenbrunner Str. 64, 71254 Ditzingen, Germany
;	Telefon: (+497156)490980	Telefax: (+497156)490981
;	E-Mail: ingbuero@andreas-hoeger.de
;*****************************************************************************
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;
;       Projekt: ZSTG	 		Version Software: V0.10c
;					Version Hardware: V1.10
;       
;       Autor: Andreas Hoeger		Build:22.02.04
;
;       --> zustzlich aendern: 
;	Softwareversion bei den LCD- Ausgabetexten (am Fileende)
;
;	Timing ausgelegt fuer Systemtakt mit 16 MHz Quarz
;
;	Aenderungen:
;	14_02_02: Initial version (=1.18)
;	15_02_02: neue CAN Botschaften eingefuegt, IDs geaendert 
;	18_02_02: DCF77 Routinen eingebunden
;	28_02_02: LOOPCNT und Einzelbits auf CAN
;	03_03_02: TASK_BITS eingefuehrt, neues Taskausrufschema
;	05_03_02: ZSTG_ALIVE eingefuehrt
;	04_05_02: CAN_RX vervielfacht fuer mehrere Mailboxen
;		  Task Steckdose und Trennrelais eingefuegt
;	05_05_02: Task MSTG12V eingefuegt
;	02_06_02: Polung Relaisansteuerung MSTG12V geaendert
;	11_06_02: Fehlermeldungsausgabe wird zurueckgesetzt 
;	16_06_02: Error-Switch --> 0; Bugfix: Steckdose invertieren
;		  Trennrelaisansteuerung mit richtigem Bit
;	17_06_02: Bugfix: Trennrelaisansteuerung invertieren
;	21_06_02: Bugfix: SIGPRELL fuer Trennrelais anders auswerten
;	20_07_02: CAN Rx Routine mit dynamischer Aufrufanzahl
;	20_07_02: CAN Rx in zwei Teile gesplittet
;	25_08_02: Stack-Init und Overflowerkennung eingebaut
; 	07_09_02: ADC Unterstuetzung eingebaut
;	27_09_02: Kennlinienfeld Spannungsmessung eingebaut
;	30_09_02: Kennlinienfeld gegen neues ausgetauscht
;	02_10_02: Offset U-Kennlinie verschoben (Label)
;	26_02_03: Powerdown ZSTG begonnen, BIT04 setzen / loeschen
;		  Temperaturmessung, ADC und teilweise CAN berspringen
;	27_02_03: inserted IDLE Mode activiation
;	02_03_03: CAN-interrupts fuer PowerDown eingefuehrt
;	04_03_03: Bugfix Powerdown, BIT04 Erkennung umdrehen, BITS auf CAN520
;		  TCON (ext int 0 edge trigd.)
;	07_03_03: Interrupt level triggered und CAN-auslesen vor PD
;	09_03_03: SJA geht in Sleep Mode bei PowerDown
;	13_03_03: changes for CAN-transceiver-standby
;	14_03_03: DCF77 Versorgung bei PowerDown deaktivieren
;		  Reihenfolge CAN-Controller und CAN Transceiver PD getauscht
;	22_02_04: Zustzliche NOPs ab label task_can_sleep_end fhrten zu CVS
;                 Differenz zwischen ZSTG_010b Staenden, daher diese Version
;                 als ZSTG_010c eingestellt und in CVS benannt 
;	xx_yy_zz:
;			
;*****************************************************************************

        $MOD51                	; use 8051 predefined symbols
        $SYMBOLS               	; append symbol table to listing

	;****** Compilerschalter *********************************************

NO_CAN		EQU	0	; 1= Betrieb ohne physikalischen CAN,
			        ;    erzeugt keine Fehlermeldungen
				; 0= CAN-Bus angeschlossen mit Gegenstelle,
				;    CAN-Ausfall erzeugt Fehlermeldung

ERROR_STOP	EQU	0	; 1= Fehlermeldung ausgeben, LED blinken
				;    und in diesem Zustand bleiben
				; 0= Fehlermeldung kurz ausgeben und dann
				;    fortfahren

;*****************************************************************************
;	Einbinden der Speicher- Segmentierung und Konstantendefinitionen	
;*****************************************************************************

	$INCLUDE (dseg_equ.asm)	; enthlt die ORG, DS und EQU- Anweisungen

;*****************************************************************************
        
        CSEG

        ;*********************************************************************
        ; Interrupt- Vectortabelle
        ;*********************************************************************

        ORG     0000h				;power on / reset vector
        jmp     on_reset

	ORG	0003h				;external interrupt 0 vector
	jmp	irq_can

        ORG     000Bh                           ;timer 0 overflow vector
	jmp	irq_t0
        
	ORG     0013h                           ;external interrupt 1 vector
	reti

        ORG     001Bh                           ;timer 1 overflow vector
	reti

        org     0023h                           ;serial I/O interrupt vector
	reti                          

        ORG     002Bh                           ;timer 2 overflow vector
	reti

	ORG	0033h				;?? reserved ??
	reti

        ;*********************************************************************
        ; Beginn Anwendungs- Programmcode
        ;*********************************************************************
        
        ORG     0100H

on_reset:  

	;****** min. 500 ms Wartezeit wegen Errata-Sheet AT89S53 *************
	;****** ISP sonst ab dem zweiten mal blockiert ***********************

	call	sek_1

	;****** System-Initialisierung ***************************************

	mov     IE,#00H			; Interrupts nicht freigeben

	mov     SP,#STACK		; Stackpointer auf Stackbereich 
					; setzen

        mov     BITS,#00H		; Merkerbits loeschen

	setb	BIT05			; Merker fuer "Initphase"
					; 1 = in Init, 0 = Init vorbei
					; wird spaeter geloescht

	call	ini_system		; erst aufrufen, wenn der Stack 
					; aufgesetzt ist !

	;****** Initialisierung Stack ****************************************

	mov	CNT0,#20H		; Stacklaenge 20H
	mov	R0,#STACK		; indirect adressing
initstack:
	mov	@R0,#STACK_INIT_VALUE		
	inc	R0
	djnz	CNT0,initstack

	mov	STACK_END_MARK,#STACK_END_VALUE	; Endemarkierung fuer 
						; Stackoverflow Erkennung

	;****** Initialisierung fuer Benutzung Timer 0 Interrupt *************

	mov	TMOD,#00H		; Timer 0 im Mode 0 benutzt
	mov	IP,#00H			; Interrupt-Prio not used

	mov	TL0,#00H		; Timer Register loeschen
	mov	TH0,#00H		; Timer Register loeschen

	;*********************************************************************

	call	sek_3		; warten bis DCF-Modul nach POWER UP
;	call	sek_3		; stabil ist

	mov	IE,#82H			; Interrupt Timer 0 Overflow enable
					; und global Interrupt enable

	mov	TCON,#10H		; Timer 0 --> ON
					; external interrupt0 is 
					; level triggered --> LSB cleared

	;****** Initialisierung zyklischer Ablauf ****************************

	mov     LOOPCNT,#00H		; Zaehler initialisieren fuer 
	mov	TASK_BITS,#00H		; zyklischen Ablauf

	mov	ZSTG_ALIVE,#00H		; Alive-Zaehler fuer PartnerSGCheck
	mov	ZSTG_BITS,#00H		; Einzelbits zur Infouebertragung

	;****** Initialisierung 1-wire bus (ADC) *****************************

	call	ONEWIRE_INIT		; setup ADC
	mov	ADC_VOLT,#00H
	mov	ADC_AMP,#00H


	;****** System Init - Netzwerkmanagement *****************************


	; hier evtl. Code einfuegen



	mov	ERROR,#00H 


	;*********************************************************************
	;****** Beginn zyklischer Ablauf - Taskschema ************************
	;*********************************************************************

	clr	BIT05			; Merker fuer "Init-Phase" loeschen
					; da Init jetzt vorbei und alle 
					; Fehlermeldungen anzeigbar sind
start_loop:

	cpl	LED_G			; "zappelt noch"- Anzeige 
					; zur Messung Zykluszeit verwendbar

cycledelay:
	call	zehn_ms
	call	zehn_ms
	call	zehn_ms
	call	zehn_ms	
	call	zehn_ms
cycledelay_end:
	
	;****** NOTSTOP fuer Fehlerausgabe abfragen

notstop:
	jnb	BITS.7,notstop_end	; dieses Bit wurde bei Fehlermeldung
					; gesetzt. Dort kann aber nicht 
					; gestoppt werden da erst noch die
	IF ERROR_STOP			; LCD- Ausgabe drankommen muss

	jmp	blinkledstop		; verzweige in die
					; Endlosschleife mit Blink- LED
	ELSE

	call	sek_3			; lange genug anzeigen
	call	sek_3			; und weitermachen

	ENDIF

notstop_end:

	;****** Taskzaehler erhoehen

	inc	ZSTG_ALIVE		; Zaehler fuer Partnersteuergeraete-
					; Ueberwachung auf HSTG

	inc	LOOPCNT			; Zaehler fuer Schleifendurchlaufe
					; erhoehen; bei 17 auf 1 zurcksetzen

	mov	TASK_BITS,#00H		; default: zunaechst kein Task aktiv

	;****** Taskmaske berechnen	
	;****** Tasks koennen in jedem zweiten, vierten, achten oder sechzehnten
	;****** Durchlauf aktiviert werden

	mov	A,#11H	
	cjne	A,LOOPCNT,no_overflow
overflow:
	mov	LOOPCNT,#01
no_overflow:
	mov	A,#02
	cjne	A,LOOPCNT,check04
	jmp	set2			
check04:mov	A,#04
	cjne	A,LOOPCNT,check06
	jmp	set24	
check06:mov	A,#06
	cjne	A,LOOPCNT,check08
	jmp	set2	
check08:mov	A,#08
	cjne	A,LOOPCNT,check10
	jmp	set248	
check10:mov	A,#0AH
	cjne	A,LOOPCNT,check12
	jmp	set2	
check12:mov	A,#0CH
	cjne	A,LOOPCNT,check14
	jmp	set24	
check14:mov	A,#0EH
	cjne	A,LOOPCNT,check16
	jmp	set2	
check16:mov	A,#10H
	cjne	A,LOOPCNT,checkend
	jmp	set24816	
checkend:jmp	task_calc_end		; no active task

set2:	mov	TASK_BITS,#01H
	jmp	task_calc_end
set24:	mov	TASK_BITS,#03H
	jmp	task_calc_end
set248: mov	TASK_BITS,#07H
	jmp	task_calc_end
set24816: mov	TASK_BITS,#0FH

task_calc_end:

task_netzwerk:

	;****** Task "Applikationsdaten einlesen und pruefen"
	;       ggf. Merker setzen ZSTG_BITS00 wenn gueltige Daten 
	;	vorhanden

	call 	netzwerk

task_netzwerk_end:

task_temp:	
	;****** NICHT BEI POWERDOWN
	jb	BIT04,task_temp_end
	;****** Task "Temperatur messen"

	jb	TASK_BITS.1,temp_einlesen

task_temp_end_uml:

	jmp	task_temp_end

temp_einlesen:

	;**** Temperatur einlesen

	mov	I2C_ADR_H,#00H		
	mov	I2C_ADR_L,#DS_READ_TEMP	; Command: read temperature
	mov	I2C_ID,#DS_ID	

	call	read_ds_random_2byte	; Ergebnis in TEMP_H und TEMP_L
	
temp_restlich:

	;**** Ausgabe Temperatur auf CAN

	;mov	CAN_D1,TEMP_H		; in Sendepuffer schreiben
	;mov	CAN_D2,TEMP_L
	
task_temp_end:

task_ADC:
	;****** NICHT BEI POWERDOWN
	jb	BIT04,task_ADC_end
	;*****	ADC routines (1-wire bus)

	;call	READ_DEVICE_ID	; read ONE device ID and put result on CAN
				; only for busses with one device !!
				; --> nur fuer Erstinbetriebnahme

	call    ADC_VOLTAMP	; convert and put data in variables for CAN

	call	ADC_FIELDCONVERT ; Kennlinienfeld- Umrechnung und
				 ; Rueckspeicherung in Ursprungsvariable
				 ;	- ADC_VOLT

task_ADC_end:

task_canrx1:
	;****** Task "CAN_Botschaften empfangen"
	;****** und Inhalte in Mailboxen verteilen

	jnb	TASK_BITS.2,task_canrx1_end

	mov	CAN_RX_CNT_1,#CAN_RX_CALL_TO	; maximale Anzahl

rx1_again:	
	call	can_rx    	; pruefen ob Botschaft im Empfangspuffer
				; des SJA1000 ist; ggf. Identifier lesen 
				; und Botschaft in Mailbox uebertragen

	; Rckgabewerte in Akku: 0 = war nix
	;			 1 = Botschaft war da

	jnz	enter_rx1_again

	jmp	task_canrx1_end	; Rx Buffer is empty, go on

enter_rx1_again:
	djnz	CAN_RX_CNT_1,rx1_again 
	
	; number of calls too high (counter == zero)	

	mov	ERROR,#EW_CAN_RX_OVERLOAD
	call	errorcode_out		; Fehlermeldung generieren

task_canrx1_end:

task_cantx_1:

	;****** Task "CAN Grund-Botschaften senden"

	; in jedem Zyklus ausfuehren

	;**** zyklische CAN- Botschaftsausgabe 520 (Status 1 ZSTG)

	mov	CAN_I1,#0A4H		; Botschaft definieren
	mov	CAN_I2,#08H		; 520h senden

	mov	CAN_D0,ZSTG_ALIVE	; ZSTG_ALIVE_Counter
	mov	CAN_D1,LOOPCNT		; Zykluszaehler
	mov	CAN_D2,TEMP_H		; TEMP_H
	mov	CAN_D3,TEMP_L		; TEMP_L
	mov	CAN_D4,ZSTG_BITS	; Einzelbits fuer INFO		
	mov	CAN_D5,TASK_BITS	; TASK_Bits		
	;mov	CAN_D6,BITS
	mov	CAN_D6,CAN_IR_VALUE	; gelesener Wert aus SJA1000
	mov	CAN_D7,ERROR
					
	call	can_tx

	; ERROR wieder zuruecksetzen damit keine Fehlermeldungs-
	; Dauerausgabe entsteht, sonst lassen sich die Steuergeraete 
	; nur noch exakt gleichzeitig einschalten 

	mov	ERROR,#00H

	;****** BEI ZSTG- POWERDOWN KEINE UNNOETIGE CAN-BOTSCHAFTEN
	jb	BIT04,can_522_end

	;**** zyklische CAN- Botschaftsausgabe 522 (ZSTG Sensor ASCII-Daten)

	mov	CAN_I1,#0A4H		; Botschaft definieren
	mov	CAN_I2,#48H		; 522h senden

	;**** 
	mov	ADC_DEZ_E,ADC_VOLT	; Zweitbatteriespannung in ASCII 
	call	hex_dez_ascii		; umwandeln
	mov	CAN_D0,ADC_DEZ_H	; Hunderter Volt = Zehner Vorkomma
	mov	CAN_D1,ADC_DEZ_Z	; Zehner    Volt = Einer Vorkomma
	mov	CAN_D2,ADC_DEZ_E	; Einer     Volt = Nachkommastelle	
	mov	CAN_D3,#00H
	mov	CAN_D4,#00H
	mov	CAN_D5,#00H
	mov	CAN_D6,#00H
	mov	CAN_D7,ADC_VOLT
					
	call	can_tx
can_522_end:

	;**** zyklische CAN- Botschaftsausgabe 521 (DCF77 Daten)

dcf77_signal_out:

	; solange DCF- Empfaenger synchronisiert Byte 0 = FFh setzen
	; Rest ist dann egal, weil dies empfaengerseitig zu 
	; Meldung fuehrt; diesen Zustand sofort immer auf CAN legen

	jb	DCF77_TAKEOFF.0,dcf_normal_out_no_sync


	mov	CAN_I1,#0A4H		; Botschaft definieren
	mov	CAN_I2,#28H		; 521h senden
	mov	CAN_D0,#0FFH		; Restliche Botschaft egal
	mov	CAN_D7,#67H		; Test only for CAN
					; mismatch BUG

	call	can_tx			; FFh immer absenden
		
	jmp	task_cantx_1_end

dcf_normal_out_no_sync:

	mov	CAN_I1,#0A4H		; Botschaft definieren
	mov	CAN_I2,#28H		; 521h senden

	mov	CAN_D0,DCF77_BITNR	; DCF77 Signal Bitnummer
					; da Byte 1 fuer DCF77 
					; nicht benoetigt wird
	mov	CAN_D1,DCF77_DATA1		
	mov	CAN_D2,DCF77_DATA2	
	mov	CAN_D3,DCF77_DATA3		
	mov	CAN_D4,DCF77_DATA4
	mov	CAN_D5,DCF77_DATA5
	mov	CAN_D6,DCF77_DATA6
	mov	CAN_D7,DCF77_DATA7

dcf77_data_out:

	; kein Update der CAN-Botschaft solange DCF im Aufbau ist
	; DCF77_TAKEOFF.1 = 0: nicht auf CAN ausgeben
	; DCF77_TAKEOFF.1 = 1: auf CAN ausgeben

	jnb	DCF77_TAKEOFF.1,task_cantx_1_end
	
	call	calc_dcf77_chks		; Jetzt sind die Daten 
					; konsistent;
					; Checksummenprfung;
					; Ueberschreibt bei Fehler
					; das Byte 0 mit 0FEh
				
	call	can_tx

task_cantx_1_end:

task_cantx_2:

	;****** BEI ZSTG- POWERDOWN KEINE UNNOETIGE CAN-BOTSCHAFTEN
	jb	BIT04,can_528_529_end

	;****** Task "CAN Debugging-Botschaften senden"

	jnb	TASK_BITS.3,task_cantx_2_end

	;**** zyklische CAN- Botschaftsausgabe 528 (DCF77 Zusatzinformation)

dcf77_control_out:

	mov	CAN_I1,#0A5H		; Botschaft definieren
	mov	CAN_I2,#08H		; 528h senden

	mov	CAN_D0,DCF77_BITNR
	mov	CAN_D1,DCF77_BYTENR		
	mov	CAN_D2,DCF77_INITWAIT	
	mov	CAN_D3,DCF77_BITMERK		
	mov	CAN_D4,DCF77_TAKEOFF
	mov	CAN_D5,#00H
	mov	CAN_D6,#00H
	mov	CAN_D7,#00H
					
	call	can_tx

	;**** zyklische CAN- Botschaftsausgabe 529 (Debugging Botschaft)

	mov	CAN_I1,#0A5H		; Botschaft definieren
	mov	CAN_I2,#28H		; 529h senden

	mov	CAN_D0,SIGPRELL_OUT	; CAN Signale nach Entprellung
	mov	CAN_D1,APP_TRENN_SOWI	
	mov	CAN_D2,ADC_VOLT		; 
	mov	CAN_D3,ADC_AMP		; 
	mov	CAN_D4,#00H		; 
	mov	CAN_D5,#00H		;
	mov	CAN_D6,CAN_RX_CNT_1	; CAN Rx Counter
	mov	CAN_D7,CAN_RX_CNT_2	; CAN Rx Counter
					
	call	can_tx

task_cantx_2_end:
can_528_529_end:

task_canrx2:
	;****** Task "CAN_Botschaften empfangen"
	;****** und Inhalte in Mailboxen verteilen

	jnb	TASK_BITS.2,task_canrx2_end

	mov	CAN_RX_CNT_2,#CAN_RX_CALL_TO	; maximale Anzahl

rx2_again:	
	call	can_rx    	; pruefen ob Botschaft im Empfangspuffer
				; des SJA1000 ist; ggf. Identifier lesen 
				; und Botschaft in Mailbox uebertragen

	; Rckgabewerte in Akku: 0 = war nix
	;			 1 = Botschaft war da

	jnz	enter_rx2_again

	jmp	task_canrx2_end	; Rx Buffer is empty, go on

enter_rx2_again:
	djnz	CAN_RX_CNT_2,rx2_again 
	
	; number of calls too high (counter == zero)	

	mov	ERROR,#EW_CAN_RX_OVERLOAD
	call	errorcode_out		; Fehlermeldung generieren

task_canrx2_end:

	
	call	sigprell	; Entprellung der Botschaftsinhalte
				; Klemme 15, Klemme 56 und D+

task_mstg12v:
	;****** Task "12V Versorgung fuer MSTG ein- und ausschalten"

	;****** Solange Applikationsdaten noch nicht erkannt wurden nicht 
	;       ausfuehren; erkannte Applikationsdaten = ZSTG_BITS.0 gesetzt
	jnb	ZSTG_BIT00, task_mstg12v_end


	jnb	TASK_BITS.2,task_mstg12v_end	;!! wie CAN-RX

	; Botschaft 504h (Kommandos von HSTG an ZSTG) abfragen
	; Dazu Mailbox 3 lesen, Byte 0
	
	; die soeben eingelesene CAN_Botschaft in BOX 3 auswerten

	; BOX3_C: 	CAN Mailbox 3	Controlbyte
	; BOX3_IH: 	CAN High Byte Botschaftsnumer [HEX]
	; BOX3_IL: 	CAN Low Byte Botschaftsnumer [HEX]
	; BOX3_0:	CAN Botschaft Mailbox 3 	Datenbyte 0
	; BOX3_1:	CAN Botschaft Mailbox 3 	Datenbyte 1
	; BOX3_2:	CAN Botschaft Mailbox 3 	Datenbyte 2
	; BOX3_3:	CAN Botschaft Mailbox 3 	Datenbyte 3
	; BOX3_4:	CAN Botschaft Mailbox 3 	Datenbyte 4
	; BOX3_5:	CAN Botschaft Mailbox 3 	Datenbyte 5
	; BOX3_6:	CAN Botschaft Mailbox 3 	Datenbyte 6
	; BOX3_7:	CAN Botschaft Mailbox 3 	Datenbyte 7

	mov	R0,#BOX3_C		; indirect adressing
	inc	R0			; Basisadresse Mailbox 3
	inc	R0
	inc	R0			; zeigt auf Byte 0

;****** Pruefen ob Bit fuer MSTG 12V gesetzt ist (Bit 0) 

	mov	ACC,@R0		; hole byte 0 in Akku

check_mstg12v:

	rrc	A		; jetzt ist bit 0 in carry
	jnc	mstg12v_aus

mstg12v_ein:
	clr	REL_MSTG	; Achtung PNP Transistor
				; 0= Relais zieht an
	jmp	task_mstg12v_end

mstg12v_aus:
	setb	REL_MSTG	; Achtung PNP Transistor
				; 1= Relais faellt ab
task_mstg12v_end:


task_steckdose:
	;****** Task "Steckdose Anforderung umsetzen"

	;****** Solange Applikationsdaten noch nicht erkannt wurden nicht 
	;       ausfuehren; erkannte Applikationsdaten = ZSTG_BITS.0 gesetzt
	jnb	ZSTG_BIT00, task_steckdose_end


	jnb	TASK_BITS.2,task_steckdose_end	;!! wie CAN-RX

	; Botschaft 504h (Kommandos von HSTG an ZSTG) abfragen
	; Dazu Mailbox 3 lesen, Byte 0
	
	; die soeben eingelesene CAN_Botschaft in BOX 3 auswerten

	; BOX3_C: 	CAN Mailbox 3	Controlbyte
	; BOX3_IH: 	CAN High Byte Botschaftsnumer [HEX]
	; BOX3_IL: 	CAN Low Byte Botschaftsnumer [HEX]
	; BOX3_0:	CAN Botschaft Mailbox 3 	Datenbyte 0
	; BOX3_1:	CAN Botschaft Mailbox 3 	Datenbyte 1
	; BOX3_2:	CAN Botschaft Mailbox 3 	Datenbyte 2
	; BOX3_3:	CAN Botschaft Mailbox 3 	Datenbyte 3
	; BOX3_4:	CAN Botschaft Mailbox 3 	Datenbyte 4
	; BOX3_5:	CAN Botschaft Mailbox 3 	Datenbyte 5
	; BOX3_6:	CAN Botschaft Mailbox 3 	Datenbyte 6
	; BOX3_7:	CAN Botschaft Mailbox 3 	Datenbyte 7

	mov	R0,#BOX3_C		; indirect adressing
	inc	R0			; Basisadresse Mailbox 3
	inc	R0
	inc	R0			; zeigt auf Byte 0

;****** Pruefen ob Bit fuer Steckdoese gesetzt ist (Bit 2) 

	mov	ACC,@R0		; hole byte 0 in Akku

checksteckdose:

	rrc	A
	rrc	A
	rrc	A		; jetzt ist bit 2 in carry
	jnc	steckdose_aus

steckdose_ein:
	clr	REL_DOSE	; ACHTUNG PNP- Ansteuerung INVERTIERT
	jmp	task_steckdose_end

steckdose_aus:
	setb	REL_DOSE	; ACHTUNG PNP- Ansteuerung INVERTIERT

task_steckdose_end:


task_trennrelais:

	;****** Solange Applikationsdaten noch nicht erkannt wurden nicht 
	;       ausfuehren; erkannte Applikationsdaten = ZSTG_BITS.0 gesetzt
	jnb	ZSTG_BIT00, task_trennrelais_end

	;****** Task "Trennrelais Anforderung umsetzen"
	jnb	TASK_BITS.2,task_trennrelais_end	;!! wie CAN-RX


	; Botschaft 504h (Kommandos von HSTG an ZSTG) abfragen ob 
	; NOTSTART- Funktion aktiv
	; Dazu Mailbox 3 lesen, Byte 0
	
	; die soeben eingelesene CAN_Botschaft in BOX 3 auswerten

	; BOX3_C: 	CAN Mailbox 3	Controlbyte
	; BOX3_IH: 	CAN High Byte Botschaftsnumer [HEX]
	; BOX3_IL: 	CAN Low Byte Botschaftsnumer [HEX]
	; BOX3_0:	CAN Botschaft Mailbox 3 	Datenbyte 0
	; BOX3_1:	CAN Botschaft Mailbox 3 	Datenbyte 1
	; BOX3_2:	CAN Botschaft Mailbox 3 	Datenbyte 2
	; BOX3_3:	CAN Botschaft Mailbox 3 	Datenbyte 3
	; BOX3_4:	CAN Botschaft Mailbox 3 	Datenbyte 4
	; BOX3_5:	CAN Botschaft Mailbox 3 	Datenbyte 5
	; BOX3_6:	CAN Botschaft Mailbox 3 	Datenbyte 6
	; BOX3_7:	CAN Botschaft Mailbox 3 	Datenbyte 7

	mov	R0,#BOX3_C		; indirect adressing
	inc	R0			; Basisadresse Mailbox 3
	inc	R0
	inc	R0			; zeigt auf Byte 0

;****** Pruefen ob Bit fuer Trennrelais gesetzt ist (Bit 3) 
;****** dann waere NOTSTART- Funktion aktiv

	mov	ACC,@R0		; hole Byte 0 in Akku

checktrennrelais:

	rrc	A
	rrc	A
	rrc	A
	rrc	A		; jetzt ist bit 3 in carry
	jnc	trennrelais_normalfkt

	clr	REL_TRENN		; NOTSTART aktivieren
					; Trennrelais verbinden
					; ACHTUNG PNP --> INVERTIERT

	jmp	task_trennrelais_end

trennrelais_normalfkt:
	; pruefen ob die Applikationsdaten Sommer- Einstellung oder 
	; Winter-Einstellung vorgeben:

	mov	ACC,APP_TRENN_SOWI	

	cjne	A,#DPLUS_SOMMER,dplus_check_winter

dplus_check_sommer:

	; Sommer- Einstellung: Nach Aktivieren Klemme 15 Trennrelais verbinden, damit
	; Zweitbatterie auch mal zum Anlassen verwendet wird
	; ohne Kl. 15 sind Trennrelais aus


	;---> hier Gedankenschmalz reinstecken wegen Zaehler ?


	mov	ACC,SIGPRELL_OUT	; entprellte CAN- Inhalte holen
	rlc	A			; Klemme 15 ist Bit 5 (von 0...7)
	rlc	A
	rlc	A			; jetzt ist es in carry
	jc	trennrelais_aus	; IN_OPTO und SIGPRELL_OUT sind invertiert !
				; wenn Carry --.> Klemme 15 = 0 = Zdg.aus
	jmp	trennrelais_ein

dplus_check_winter:


	; Winter- Einstellung: Nach Aktivieren D+ werden Trennrelais verbunden
	; ohne D+ sind Trennrelais aus

	mov	ACC,SIGPRELL_OUT	; entprellte CAN- Inhalte holen
	rlc	A			; D+ ist Bit 7 (von 0...7)
					; jetzt ist es in carry
	jc	trennrelais_aus	; IN_OPTO und SIGPRELL_OUT sind invertiert !
				; wenn Carry --.> D+ = 0 = kein Ladestrom

trennrelais_ein:

	clr	REL_TRENN	; PNP Transistoransteuerung !
	jmp	task_trennrelais_end

trennrelais_aus:

	setb	REL_TRENN	; PNP Transistoransteuerung !

task_trennrelais_end:


task_stack_overflo:

	;****** Pruefen Stack- Endemarkierung (Init-Wert 55h) noch da ist

	mov	A,#55h
	cjne	A,STACK_END_MARK,stack_error
	jmp	task_stack_overflow_end
stack_error:	
	mov	ERROR,#EW_STACK_OVERFLOW
	call	errorcode_out		; Fehlermeldung generieren

task_stack_overflow_end:



task_pdzstg:
	;****** Task "Selbstabschaltung ZSTG fuer Powerdown"

	;****** Solange Applikationsdaten noch nicht erkannt wurden nicht 
	;       ausfuehren; erkannte Applikationsdaten = ZSTG_BITS.0 gesetzt
	jnb	ZSTG_BIT00, task_pdzstg_end


	jnb	TASK_BITS.2,task_pdzstg_end	;!! wie CAN-RX

	; Botschaft 504h (Kommandos von HSTG an ZSTG) abfragen
	; Dazu Mailbox 3 lesen, Byte 0
	
	; die soeben eingelesene CAN_Botschaft in BOX 3 auswerten

	; BOX3_C: 	CAN Mailbox 3	Controlbyte
	; BOX3_IH: 	CAN High Byte Botschaftsnumer [HEX]
	; BOX3_IL: 	CAN Low Byte Botschaftsnumer [HEX]
	; BOX3_0:	CAN Botschaft Mailbox 3 	Datenbyte 0
	; BOX3_1:	CAN Botschaft Mailbox 3 	Datenbyte 1
	; BOX3_2:	CAN Botschaft Mailbox 3 	Datenbyte 2
	; BOX3_3:	CAN Botschaft Mailbox 3 	Datenbyte 3
	; BOX3_4:	CAN Botschaft Mailbox 3 	Datenbyte 4
	; BOX3_5:	CAN Botschaft Mailbox 3 	Datenbyte 5
	; BOX3_6:	CAN Botschaft Mailbox 3 	Datenbyte 6
	; BOX3_7:	CAN Botschaft Mailbox 3 	Datenbyte 7

	mov	R0,#BOX3_C		; indirect adressing
	inc	R0			; Basisadresse Mailbox 3
	inc	R0
	inc	R0			; zeigt auf Byte 0

;****** Pruefen ob Bit fuer MSTG 12V Schaltung (1=an, 0=MSTG aus)
;	und ZSTG Selbstabschaltung gesetzt ist (Bit 0) 

	mov	ACC,@R0		; hole byte 0 in Akku

check_pdzstg:

	rrc	A		; jetzt ist bit 0 in carry
	jc	pdzstg_no

pdzstg_yes:
	setb	BIT04		; Powerdown Merker setzen, MSTG aus
	jmp	task_pdzstg_end

pdzstg_no:
	clr	BIT04		; Powerdown Merker loeschen
task_pdzstg_end:



;****** Activation of IDLE MODE in case of POWER DOWN until next interrupt
;	NOTE: - Any enabled interrupt will start normal operation again.
;	      - The interrupt-service routine "CAN-RX-INT" is executed. 
;	      - external interrupt 0 is low-level triggered and 
;		interrupt flag clears not automatically, only if external 
;		source releases interrupt
;	      - Then execution will be continued after the instruction that
;		put system to IDLE
;	      - PCON.0 is automatically reset
;
;	NOTE: - The CAN-RX-Interrupt is used to wake ZSTG up. Timer-Interrupt
;		must be disabled, so no DCF77 during powerdown.
;
;	NOTE: - The CAN-RX-FIFO must be emptied before going into powerdown,
;		else the interrupt will stay LOW.
;		
activate_idle:	

	jnb	BIT04,activate_idle_end

	;read all CAN-RX-FIFO contents and ensure that CAN-controller does not
	;keep Int-line on LOW 

task_canrx_pd:
	;****** Task "CAN_Botschaften empfangen"

	mov	CAN_RX_CNT_2,#CAN_RX_CALL_TO_PD	; maximale Anzahl laden

rx_pd_again:	
	call	can_rx    	; pruefen ob Botschaft im Empfangspuffer
				; des SJA1000 ist; ggf. Identifier lesen 
				; und Botschaft in Mailbox uebertragen

	; Rckgabewerte in Akku: 0 = war nix
	;			 1 = Botschaft war da

	jnz	enter_rx_pd_again

	jmp	task_canrx_pd_end	; Rx Buffer is empty, go on

enter_rx_pd_again:

	djnz	CAN_RX_CNT_2,rx_pd_again 
	
	; number of calls too high (counter == zero)	

	mov	ERROR,#EW_CAN_RX_PD_OVERLOAD
	call	errorcode_out		; Fehlermeldung generieren
	jmp	activate_idle_end	; und kein powerdown weil
					; Fehlern sonst nicht gesendet
					; werden kann
task_canrx_pd_end:


task_can_sleep:

	;***** Task "CAN Transceiver in Standby mode versetzen"
	; NOTE: Wakeup interrupt on RX when bus-activity, but RS PIN must be
	; released by the microcontroller manually

	setb	PCA_RS		; standby CAN transceiver, PIN HIGH

	;****** Task "CAN Controller in Sleep mode versetzen"
	; NOTE: Wakeup automatically when bus-activity detected by SJA

	mov	CAN_ADR,#CAN_ADR_CMR		; CMR "GoToSleep" Bit
						; setzen
	mov	CAN_DAT,#CAN_CMR_SLEEP
	call	can_write

task_can_sleep_end:

	;enable interrupt from CAN and disable timer interrupt
	mov	IE,#81H			; nur EXTint0 enable
					; und global Interrupt enable
	;activate IDLE now and wait for CAN-RX-INT
	cpl	LED_R  ;-> off		; save power
	;Versorgung DCF77 Modul ausschalten
	cpl	DCF77_V	
	nop
	nop	

	mov	PCON,#01H		; This activates IDLE MODE

	nop				; this NOP is the instruction 
	nop				; to continue after idle

	cpl	LED_R  ;-> on		; enable alive LED again
	cpl	DCF77_V			; Versorgung DCF77 Modul einschalten

	;disable interrupt from CAN and enable timer interrupt again
	mov	IE,#82H			; Interrupt Timer 0 Overflow enable
					; und global Interrupt enable

activate_idle_end:


end_loop:
	jmp	start_loop		; zum Anfang der zyklischen 
					; Abarbeitung zurueckspringen

	;********************************************************************* 
	; Unterprogramm zur Checksummenprfung des DCF77-Signals vor dem 
	; Versand auf CAN

	; Eingangsdaten sind : DCF77_DATA 1 bis 7
	; Bei fehlerhafter Checksumme wird das Datenbyte0 (in dem sich
	; bereits die Checksumme befindet) auf 0FFh gesetzt

	; Das CHKS Bit ist jeweils so gesetzt, dass eine gerade Anzahl 
	; Einsen herauskommt

	; Die drei einzelnen Checksummen werden zu einer Summe zusammen
	; gerechnet (dreimal gerade = gerade)
	; also Bits 21 bis 58 zusammen ausgewertet

calc_dcf77_chks:

	; Bit 21 bis 27 mit CHKS in Bit 28 pruefen

;******
	mov	DCF_CALC_CHKS,#00H	; Zaehler loeschen fuer
					; naechste Checksumme

	mov	A,DCF77_DATA2		; lade relevante Daten
	mov	CNT0,#03H		; lade Anzahl Bits in 
					; Byte 2
dcf_chks_loop_2:	
	rlc	A
	jc	dcf_chks_2_high
	jmp	dcf_chks_2_low
dcf_chks_2_high:
	inc	DCF_CALC_CHKS
dcf_chks_2_low:
	djnz	CNT0,dcf_chks_loop_2
;******
	mov	A,DCF77_DATA3		; lade relevante Daten
	mov	CNT0,#05H		; lade Anzahl Bits in 
					; Byte 3
dcf_chks_loop_3:	
	rrc	A
	jc	dcf_chks_3_high
	jmp	dcf_chks_3_low
dcf_chks_3_high:
	inc	DCF_CALC_CHKS
dcf_chks_3_low:
	djnz	CNT0,dcf_chks_loop_3
;******
	; Jetzt nachsehen, ob die Zahl der Einsen geradzahlig ist, 
	; sonst Fehler

	mov	A,DCF_CALC_CHKS
	mov	B,#02H			; teilen durch 2

	div 	AB	; in A ist jetzt die Ganzzahl
			; in B ist jetzt der Rest
	mov	A,B	; B in Akku fr Vergleich

	cjne	A,#00H,write_error	; wenn da ein Rest war ... Fehler
					; weil Anzahl Einsen nicht gerade
;******
	; Bit 29 bis 34 mit CHKS in Bit 35 pruefen
;******
	mov	DCF_CALC_CHKS,#00H	; Zaehler wieder loeschen fuer
					; naechste Checksumme

	mov	A,DCF77_DATA3		; lade relevante Daten
	mov	CNT0,#03H		; lade Anzahl Bits in 
					; Byte 3
dcf_chks_loop_3a:	
	rlc	A
	jc	dcf_chks_3a_high
	jmp	dcf_chks_3a_low
dcf_chks_3a_high:
	inc	DCF_CALC_CHKS
dcf_chks_3a_low:
	djnz	CNT0,dcf_chks_loop_3a
;******
	mov	A,DCF77_DATA4		; lade relevante Daten
	mov	CNT0,#04H		; lade Anzahl Bits in 
					; Byte 4
dcf_chks_loop_4:	
	rrc	A
	jc	dcf_chks_4_high
	jmp	dcf_chks_4_low
dcf_chks_4_high:
	inc	DCF_CALC_CHKS
dcf_chks_4_low:
	djnz	CNT0,dcf_chks_loop_4
;******

	; Jetzt nachsehen, ob die Zahl der Einsen geradzahlig ist, 
	; sonst Fehler

	mov	A,DCF_CALC_CHKS
	mov	B,#02H			; teilen durch 2

	div 	AB	; in A ist jetzt die Ganzzahl
			; in B ist jetzt der Rest
	mov	A,B	; B in Akku fr Vergleich

	cjne	A,#00H,write_error	; wenn da ein Rest war ... Fehler
					; weil Anzahl Einsen nicht gerade
;******
	; Bit 36 bis 57 mit CHKS in Bit 58 pruefen
;******
	mov	DCF_CALC_CHKS,#00H	; Zaehler wieder loeschen fuer
					; naechste Checksumme

	mov	A,DCF77_DATA4		; lade relevante Daten
	mov	CNT0,#04H		; lade Anzahl Bits in 
					; Byte 4
dcf_chks_loop_4a:	
	rlc	A
	jc	dcf_chks_4a_high
	jmp	dcf_chks_4a_low
dcf_chks_4a_high:
	inc	DCF_CALC_CHKS
dcf_chks_4a_low:
	djnz	CNT0,dcf_chks_loop_4a
;******
	mov	A,DCF77_DATA5		; lade relevante Daten
	mov	CNT0,#08H		; lade Anzahl Bits in 
					; Byte 5
dcf_chks_loop_5:	
	rlc	A
	jc	dcf_chks_5_high
	jmp	dcf_chks_5_low
dcf_chks_5_high:
	inc	DCF_CALC_CHKS
dcf_chks_5_low:
	djnz	CNT0,dcf_chks_loop_5
;******
	mov	A,DCF77_DATA6		; lade relevante Daten
	mov	CNT0,#08H		; lade Anzahl Bits in 
					; Byte 6
dcf_chks_loop_6:	
	rlc	A
	jc	dcf_chks_6_high
	jmp	dcf_chks_6_low
dcf_chks_6_high:
	inc	DCF_CALC_CHKS
dcf_chks_6_low:
	djnz	CNT0,dcf_chks_loop_6
;******
	mov	A,DCF77_DATA7		; lade relevante Daten
	mov	CNT0,#03H		; lade Anzahl Bits in 
					; Byte 7
dcf_chks_loop_7:	
	rrc	A
	jc	dcf_chks_7_high
	jmp	dcf_chks_7_low
dcf_chks_7_high:
	inc	DCF_CALC_CHKS
dcf_chks_7_low:
	djnz	CNT0,dcf_chks_loop_7
	
;******
	; Jetzt nachsehen, ob die Zahl der Einsen geradzahlig ist, 
	; sonst Fehler

	mov	A,DCF_CALC_CHKS
	mov	B,#02H			; teilen durch 2

	div 	AB	; in A ist jetzt die Ganzzahl
			; in B ist jetzt der Rest
	mov	A,B	; B in Akku fr Vergleich

	cjne	A,#00H,write_error	; wenn da ein Rest war ... Fehler
					; weil Anzahl Einsen nicht gerade

	jmp	dcf_chks_calc_end

write_error:

	mov	CAN_D0,#0FEH		; Byte 0, das bereits die Bitnr.
					; enthaelt mit der Fehlerkennung
					; FEh ueberschreiben
dcf_chks_calc_end:

	ret

	;****** Blink- LED als NOT-STOP ************************************** 
	; kann nicht mit normaler Fehlerausgabe gemacht werden da 
	; ausserhalb der Main-Routine

blinkstopend:	
	mov	CNT0,#0FFH		; Pulsdauer FF/FF = 150 ms
stop0:	nop				; Pulsdauer C0/FF = 115 ms
	mov	CNT1,#0FFH		; Pulsdauer 90/FF =  80 ms
stop1:	nop				; Pulsdauer 60/FF =  55 ms
	djnz	CNT1,stop1		; Pulsdauer 33/FF =  30 ms
	djnz	CNT0,stop0		; Pulsdauer 11/FF =  10 ms
					; Pulsdauer 10/1A =   1 ms
	cpl	LED_R
	jmp	blinkstopend		; LED toggeln

;*****************************************************************************
;	Einbinden der Unterprogramme / Treiber im Anschluss an den Main-Code	
;*****************************************************************************

	$INCLUDE (sys_ini.asm)	; Systeminitialisierung
	$INCLUDE (basiccan.asm)	; Treiber fuer Basic CAN
	$INCLUDE (convert.asm)	; Unterprogramme zur Datenumwandlung
	$INCLUDE (ds1621.asm)	; Unterprogramme fuer Temperaturmessbaustein
	$INCLUDE (ee_iic.asm)	; Treiber fuer IIC- Bus, noetig fuer EEPROM
	$INCLUDE (timeloop.asm)	; Zeitschleifen
	$INCLUDE (errorman.asm)	; Fehlermanagement
	$INCLUDE (dcf_irq.asm)  ; SLAVE_Interruptserviceroutinen
	$INCLUDE (sigprell.asm) ; Signalentprellung Kl.15 / D+ / Kl.56
	$INCLUDE (netzwerk.asm)	; Netzwerkmanagement (Applikationsdaten ...)
	$INCLUDE (1_wire.asm)	; Treiber fuer ADC
	$INCLUDE (can_irq.asm)  ; Interruptroutine fr PowerDown-Wakeup-CAN

;*****************************************************************************

        ;*********************************************************************
        ; Datensatzdefinitionen
        ;*********************************************************************
	; Texte enthalten 20 Zeichen und zustzlich die Endemarke
	; analog zu den LCD-Ausgabetexten des Master- Moduls

        ORG     1800H           

	;****** Lesbarer Text fuer HEX- Code *********************************

Kennung_Line_01: DB	'ZSTG Software V0.10c',16
Kennung_Line_02: DB     'Build 220204        ',16

Kennung_Line_03: DB	'Andreas Hoeger 02/04',16
Kennung_Line_04: DB	'C 2004 BY ANDI      ',16

Kennung_Line_05: DB     'ZSTG Hardware V1.1  ',16


	ORG	2000H
	;****** Kennlinienfeld Spannungsmessung ******************************

     	;	Wert fuer Anzeige
	;			Index DEZ
	;				Index HEX
	;					Spannung ADC
	;						Spannung real
	;							Anzeigewert [DEZ/HEX]

U_00: ;Label verschoben wegen Offsetkorrektur 	  
	  DB         0h ;     0      0        0       0     0       0
          DB         0h ;     1      1     0,02    0,06     1       0
          DB         1h ;     2      2     0,04    0,12     1       1
          DB         1h ;     3      3     0,06    0,18     2       1
          DB         2h ;     4      4     0,08    0,24     2       2
          DB         3h ;     5      5      0,1     0,3     3       3
          DB         3h ;     6      6     0,12    0,36     4       3
;U_00:     
	  DB         4h ;     7      7     0,14    0,42     4       4
          DB         4h ;     8      8     0,16    0,48     5       4
          DB         5h ;     9      9     0,18    0,54     5       5
          DB         6h ;    10      A      0,2     0,6     6       6
          DB         6h ;    11      B     0,22    0,66     7       6
          DB         7h ;    12      C     0,24    0,72     7       7
          DB         7h ;    13      D     0,26    0,78     8       7
          DB         8h ;    14      E     0,28    0,84     8       8
          DB         9h ;    15      F      0,3     0,9     9       9
          DB         9h ;    16     10     0,32    0,96    10       9
          DB        0Ah ;    17     11     0,34    1,02    10       A
          DB        0Ah ;    18     12     0,36    1,08    11       A
          DB        0Bh ;    19     13     0,38    1,14    11       B
          DB        0Ch ;    20     14      0,4     1,2    12       C
          DB        0Ch ;    21     15     0,42    1,26    13       C
          DB        0Dh ;    22     16     0,44    1,32    13       D
          DB        0Dh ;    23     17     0,46    1,38    14       D
          DB        0Eh ;    24     18     0,48    1,44    14       E
          DB        0Fh ;    25     19      0,5     1,5    15       F
          DB        0Fh ;    26     1A     0,52    1,56    16       F
          DB        10h ;    27     1B     0,54    1,62    16      10
          DB        10h ;    28     1C     0,56    1,68    17      10
          DB        11h ;    29     1D     0,58    1,74    17      11
          DB        12h ;    30     1E      0,6     1,8    18      12
          DB        12h ;    31     1F     0,62    1,86    19      12
          DB        13h ;    32     20     0,64    1,92    19      13
          DB        13h ;    33     21     0,66    1,98    20      13
          DB        14h ;    34     22     0,68    2,04    20      14
          DB        15h ;    35     23      0,7     2,1    21      15
          DB        15h ;    36     24     0,72    2,16    22      15
          DB        16h ;    37     25     0,74    2,22    22      16
          DB        16h ;    38     26     0,76    2,28    23      16
          DB        17h ;    39     27     0,78    2,34    23      17
          DB        18h ;    40     28      0,8     2,4    24      18
          DB        18h ;    41     29     0,82    2,46    25      18
          DB        19h ;    42     2A     0,84    2,52    25      19
          DB        19h ;    43     2B     0,86    2,58    26      19
          DB        1Ah ;    44     2C     0,88    2,64    26      1A
          DB        1Bh ;    45     2D      0,9     2,7    27      1B
          DB        1Bh ;    46     2E     0,92    2,76    28      1B
          DB        1Ch ;    47     2F     0,94    2,82    28      1C
          DB        1Ch ;    48     30     0,96    2,88    29      1C
          DB        1Dh ;    49     31     0,98    2,94    29      1D
          DB        1Eh ;    50     32        1       3    30      1E
          DB        1Eh ;    51     33     1,02    3,06    31      1E
          DB        1Fh ;    52     34     1,04    3,12    31      1F
          DB        1Fh ;    53     35     1,06    3,18    32      1F
          DB        20h ;    54     36     1,08    3,24    32      20
          DB        21h ;    55     37      1,1     3,3    33      21
          DB        21h ;    56     38     1,12    3,36    34      21
          DB        22h ;    57     39     1,14    3,42    34      22
          DB        22h ;    58     3A     1,16    3,48    35      22
          DB        23h ;    59     3B     1,18    3,54    35      23
          DB        24h ;    60     3C      1,2     3,6    36      24
          DB        24h ;    61     3D     1,22    3,66    37      24
          DB        25h ;    62     3E     1,24    3,72    37      25
          DB        25h ;    63     3F     1,26    3,78    38      25
          DB        26h ;    64     40     1,28    3,84    38      26
          DB        27h ;    65     41      1,3     3,9    39      27
          DB        27h ;    66     42     1,32    3,96    40      27
          DB        28h ;    67     43     1,34    4,02    40      28
          DB        28h ;    68     44     1,36    4,08    41      28
          DB        29h ;    69     45     1,38    4,14    41      29
          DB        2Ah ;    70     46      1,4     4,2    42      2A
          DB        2Ah ;    71     47     1,42    4,26    43      2A
          DB        2Bh ;    72     48     1,44    4,32    43      2B
          DB        2Bh ;    73     49     1,46    4,38    44      2B
          DB        2Ch ;    74     4A     1,48    4,44    44      2C
          DB        2Dh ;    75     4B      1,5     4,5    45      2D
          DB        2Dh ;    76     4C     1,52    4,56    46      2D
          DB        2Eh ;    77     4D     1,54    4,62    46      2E
          DB        2Eh ;    78     4E     1,56    4,68    47      2E
          DB        2Fh ;    79     4F     1,58    4,74    47      2F
          DB        30h ;    80     50      1,6     4,8    48      30
          DB        30h ;    81     51     1,62    4,86    49      30
          DB        31h ;    82     52     1,64    4,92    49      31
          DB        31h ;    83     53     1,66    4,98    50      31
          DB        32h ;    84     54     1,68    5,04    50      32
          DB        33h ;    85     55      1,7     5,1    51      33
          DB        33h ;    86     56     1,72    5,16    52      33
          DB        34h ;    87     57     1,74    5,22    52      34
          DB        34h ;    88     58     1,76    5,28    53      34
          DB        35h ;    89     59     1,78    5,34    53      35
          DB        36h ;    90     5A      1,8     5,4    54      36
          DB        36h ;    91     5B     1,82    5,46    55      36
          DB        37h ;    92     5C     1,84    5,52    55      37
          DB        37h ;    93     5D     1,86    5,58    56      37
          DB        38h ;    94     5E     1,88    5,64    56      38
          DB        39h ;    95     5F      1,9     5,7    57      39
          DB        39h ;    96     60     1,92    5,76    58      39
          DB        3Ah ;    97     61     1,94    5,82    58      3A
          DB        3Ah ;    98     62     1,96    5,88    59      3A
          DB        3Bh ;    99     63     1,98    5,94    59      3B
          DB        3Ch ;   100     64        2       6    60      3C
          DB        3Ch ;   101     65     2,02    6,06    61      3C
          DB        3Dh ;   102     66     2,04    6,12    61      3D
          DB        3Dh ;   103     67     2,06    6,18    62      3D
          DB        3Eh ;   104     68     2,08    6,24    62      3E
          DB        3Fh ;   105     69      2,1     6,3    63      3F
          DB        3Fh ;   106     6A     2,12    6,36    64      3F
          DB        40h ;   107     6B     2,14    6,42    64      40
          DB        40h ;   108     6C     2,16    6,48    65      40
          DB        41h ;   109     6D     2,18    6,54    65      41
          DB        42h ;   110     6E      2,2     6,6    66      42
          DB        42h ;   111     6F     2,22    6,66    67      42
          DB        43h ;   112     70     2,24    6,72    67      43
          DB        43h ;   113     71     2,26    6,78    68      43
          DB        44h ;   114     72     2,28    6,84    68      44
          DB        45h ;   115     73      2,3     6,9    69      45
          DB        45h ;   116     74     2,32    6,96    70      45
          DB        46h ;   117     75     2,34    7,02    70      46
          DB        46h ;   118     76     2,36    7,08    71      46
          DB        47h ;   119     77     2,38    7,14    71      47
          DB        48h ;   120     78      2,4     7,2    72      48
          DB        48h ;   121     79     2,42    7,26    73      48
          DB        49h ;   122     7A     2,44    7,32    73      49
          DB        49h ;   123     7B     2,46    7,38    74      49
          DB        4Ah ;   124     7C     2,48    7,44    74      4A
          DB        4Bh ;   125     7D      2,5     7,5    75      4B
          DB        4Bh ;   126     7E     2,52    7,56    76      4B
          DB        4Ch ;   127     7F     2,54    7,62    76      4C
          DB        4Ch ;   128     80     2,56    7,68    77      4C
          DB        4Dh ;   129     81     2,58    7,74    77      4D
          DB        4Eh ;   130     82      2,6     7,8    78      4E
          DB        4Eh ;   131     83     2,62    7,86    79      4E
          DB        4Fh ;   132     84     2,64    7,92    79      4F
          DB        4Fh ;   133     85     2,66    7,98    80      4F
          DB        50h ;   134     86     2,68    8,04    80      50
          DB        51h ;   135     87      2,7     8,1    81      51
          DB        51h ;   136     88     2,72    8,16    82      51
          DB        52h ;   137     89     2,74    8,22    82      52
          DB        52h ;   138     8A     2,76    8,28    83      52
          DB        53h ;   139     8B     2,78    8,34    83      53
          DB        54h ;   140     8C      2,8     8,4    84      54
          DB        54h ;   141     8D     2,82    8,46    85      54
          DB        55h ;   142     8E     2,84    8,52    85      55
          DB        55h ;   143     8F     2,86    8,58    86      55
          DB        56h ;   144     90     2,88    8,64    86      56
          DB        57h ;   145     91      2,9     8,7    87      57
          DB        57h ;   146     92     2,92    8,76    88      57
          DB        58h ;   147     93     2,94    8,82    88      58
          DB        58h ;   148     94     2,96    8,88    89      58
          DB        59h ;   149     95     2,98    8,94    89      59
          DB        5Ah ;   150     96        3       9    90      5A
          DB        5Ah ;   151     97     3,02    9,06    91      5A
          DB        5Bh ;   152     98     3,04    9,12    91      5B
          DB        5Bh ;   153     99     3,06    9,18    92      5B
          DB        5Ch ;   154     9A     3,08    9,24    92      5C
          DB        5Dh ;   155     9B      3,1     9,3    93      5D
          DB        5Dh ;   156     9C     3,12    9,36    94      5D
          DB        5Eh ;   157     9D     3,14    9,42    94      5E
          DB        5Eh ;   158     9E     3,16    9,48    95      5E
          DB        5Fh ;   159     9F     3,18    9,54    95      5F
          DB        60h ;   160     A0      3,2     9,6    96      60
          DB        60h ;   161     A1     3,22    9,66    97      60
          DB        61h ;   162     A2     3,24    9,72    97      61
          DB        61h ;   163     A3     3,26    9,78    98      61
          DB        62h ;   164     A4     3,28    9,84    98      62
          DB        63h ;   165     A5      3,3     9,9    99      63
          DB        63h ;   166     A6     3,32    9,96   100      63
          DB        64h ;   167     A7     3,34   10,02   100      64
          DB        64h ;   168     A8     3,36   10,08   101      64
          DB        65h ;   169     A9     3,38   10,14   101      65
          DB        66h ;   170     AA      3,4    10,2   102      66
          DB        66h ;   171     AB     3,42   10,26   103      66
          DB        67h ;   172     AC     3,44   10,32   103      67
          DB        67h ;   173     AD     3,46   10,38   104      67
          DB        68h ;   174     AE     3,48   10,44   104      68
          DB        69h ;   175     AF      3,5    10,5   105      69
          DB        69h ;   176     B0     3,52   10,56   106      69
          DB        6Ah ;   177     B1     3,54   10,62   106      6A
          DB        6Ah ;   178     B2     3,56   10,68   107      6A
          DB        6Bh ;   179     B3     3,58   10,74   107      6B
          DB        6Ch ;   180     B4      3,6    10,8   108      6C
          DB        6Ch ;   181     B5     3,62   10,86   109      6C
          DB        6Dh ;   182     B6     3,64   10,92   109      6D
          DB        6Dh ;   183     B7     3,66   10,98   110      6D
          DB        6Eh ;   184     B8     3,68   11,04   110      6E
          DB        6Fh ;   185     B9      3,7    11,1   111      6F
          DB        6Fh ;   186     BA     3,72   11,16   112      6F
          DB        70h ;   187     BB     3,74   11,22   112      70
          DB        70h ;   188     BC     3,76   11,28   113      70
          DB        71h ;   189     BD     3,78   11,34   113      71
          DB        72h ;   190     BE      3,8    11,4   114      72
          DB        72h ;   191     BF     3,82   11,46   115      72
          DB        73h ;   192     C0     3,84   11,52   115      73
          DB        73h ;   193     C1     3,86   11,58   116      73
          DB        74h ;   194     C2     3,88   11,64   116      74
          DB        75h ;   195     C3      3,9    11,7   117      75
          DB        75h ;   196     C4     3,92   11,76   118      75
          DB        76h ;   197     C5     3,94   11,82   118      76
          DB        76h ;   198     C6     3,96   11,88   119      76
          DB        77h ;   199     C7     3,98   11,94   119      77
          DB        78h ;   200     C8        4      12   120      78
          DB        78h ;   201     C9     4,02   12,06   121      78
          DB        79h ;   202     CA     4,04   12,12   121      79
          DB        79h ;   203     CB     4,06   12,18   122      79
          DB        7Ah ;   204     CC     4,08   12,24   122      7A
          DB        7Ah ;   205     CD      4,1    12,3   123      7A
          DB        7Bh ;   206     CE     4,12   12,36   124      7B
          DB        7Ch ;   207     CF     4,14   12,42   124      7C
          DB        7Ch ;   208     D0     4,16   12,48   125      7C
          DB        7Dh ;   209     D1     4,18   12,54   125      7D
          DB        7Eh ;   210     D2      4,2    12,6   126      7E
          DB        7Eh ;   211     D3     4,22   12,66   127      7E
          DB        7Fh ;   212     D4     4,24   12,72   127      7F
          DB        7Fh ;   213     D5     4,26   12,78   128      7F
          DB        80h ;   214     D6     4,28   12,84   128      80
          DB        81h ;   215     D7      4,3    12,9   129      81
          DB        81h ;   216     D8     4,32   12,96   130      81
          DB        82h ;   217     D9     4,34   13,02   130      82
          DB        82h ;   218     DA     4,36   13,08   131      82
          DB        83h ;   219     DB     4,38   13,14   131      83
          DB        84h ;   220     DC      4,4    13,2   132      84
          DB        84h ;   221     DD     4,42   13,26   133      84
          DB        85h ;   222     DE     4,44   13,32   133      85
          DB        85h ;   223     DF     4,46   13,38   134      85
          DB        86h ;   224     E0     4,48   13,44   134      86
          DB        87h ;   225     E1      4,5    13,5   135      87
          DB        87h ;   226     E2     4,52   13,56   136      87
          DB        88h ;   227     E3     4,54   13,62   136      88
          DB        88h ;   228     E4     4,56   13,68   137      88
          DB        89h ;   229     E5     4,58   13,74   137      89
          DB        8Ah ;   230     E6      4,6    13,8   138      8A
          DB        8Ah ;   231     E7     4,62   13,86   139      8A
          DB        8Bh ;   232     E8     4,64   13,92   139      8B
          DB        8Bh ;   233     E9     4,66   13,98   140      8B
          DB        8Ch ;   234     EA     4,68   14,04   140      8C
          DB        8Dh ;   235     EB      4,7    14,1   141      8D
          DB        8Dh ;   236     EC     4,72   14,16   142      8D
          DB        8Eh ;   237     ED     4,74   14,22   142      8E
          DB        8Eh ;   238     EE     4,76   14,28   143      8E
          DB        8Fh ;   239     EF     4,78   14,34   143      8F
          DB        90h ;   240     F0      4,8    14,4   144      90
          DB        90h ;   241     F1     4,82   14,46   145      90
          DB        91h ;   242     F2     4,84   14,52   145      91
          DB        91h ;   243     F3     4,86   14,58   146      91
          DB        92h ;   244     F4     4,88   14,64   146      92
          DB        93h ;   245     F5      4,9    14,7   147      93
          DB        93h ;   246     F6     4,92   14,76   148      93
          DB        94h ;   247     F7     4,94   14,82   148      94
          DB        94h ;   248     F8     4,96   14,88   149      94
          DB        95h ;   249     F9     4,98   14,94   149      95
          DB        96h ;   250     FA        5      15   150      96
          DB        96h ;   251     FB     5,02   15,06   151      96
          DB        97h ;   252     FC     5,04   15,12   151      97
          DB        97h ;   253     FD     5,06   15,18   152      97
          DB        98h ;   254     FE     5,08   15,24   152      98
          DB        99h ;   255     FF      5,1    15,3   153      99

;*****************************************************************************
; ENDE DES GESAMTEN QUELLTEXTES
;*****************************************************************************

        END

