;*****************************************************************************
; 	All rights reserved by Dipl.-Ing (FH) Andreas Hoeger
;	Ditzenbrunner Str. 64, 71254 Ditzingen, Germany
;	Telefon: (+497156)490980	Telefax: (+497156)490981
;	E-Mail: ingbuero@andreas-hoeger.de
;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm fr ZSTG, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 14.02.2002		
;
;	Aenderungen:
;	14_02_02: Initial version from 1.18
;	18_02_02: DCF77 features included
;	25_02_02: DCF77 power supply included
;	02_06_02: Init Port 1 fuer Relais geaendert wegen PNP Transistoren
;	07_09_02: Port 2.0 Output for 1_wire
;	13_03_02: Port 2.1 Output for CAN-transceiver standby mode
;	xx_xx_xx: 
;
;*****************************************************************************
	
ini_system:
	
	mov     R0,#00H			; Register loeschen
        mov     R1,#00H
        mov     R2,#00H                  
        mov     R3,#00H                 
        mov     R4,#00H
        mov     R5,#00H                 
        mov     R6,#00H 
	mov	R7,#00H                

	;****** Sonstige Einstellungen am ATMEL- Controller

	mov	8EH,#01H		; Bit 0 von SFR 8Eh setzen, damit
					; ALE- Pin nicht auf 1/6 osz-freq. 
					; schwingt

	;****** Parallelports initialisieren (1=Eingang 0=Ausgang) ***********

        mov	P0,#00H		; Port 0 an CAN- Controller
				; P0.0 bis P0.7 = AD- Bus
				; alle OUTPUT = 0 (Grundzustand)
				
	mov     P1,#0FH		; Port 1 Relais Output / SPI

				; Achtung ! PNP Transistoren vor Relais
				; 0=Relais aktiv   1=Relais nicht angezogen

				; P1.0 = REL_MSTG	= OUTPUT = HIGH = 1 
				; P1.1 = REL_BEL	= OUTPUT = HIGH = 1
				; P1.2 = REL_DOSE	= OUTPUT = HIGH = 1
				; P1.3 = REL_TRENN	= OUTPUT = HIGH = 1
				; P1.4 = SS/	= Bit SPI_SS	= OUTPUT = 0
				; P1.5 = MOSI	= Bit MOSI	= OUTPUT = 0
				; P1.6 = MISO   = Bit MISO	= OUTPUT = 0
				; P1.7 = SCK	= Bit SPI_CLK	= OUTPUT = 0
	
	mov	P2,#18H		; Port 2 LED, DCF77, GONG, A/D
				; P2.0 = A/D Wandler	 	= OUTPUT = 0
				; P2.1 = CAN transc. standby    = OUTPUT = 0
				; P2.2 = GONG			= OUTPUT = 0
				; P2.3 = DCF77_Signal	 	= INPUT  = 1
				; P2.4 = N.C 			= INPUT  = 1
				; P2.5 = DCF77_Versorgung	= OUTPUT = 0
				; P2.6 = LED_R  = Bit LCD rot	= OUTPUT = 0
				; P2.7 = LED_G	= Bit LED gn	= OUTPUT = 0

        mov     P3,#04H		; Port 3 CAN-Steuerltg. und I2C-Bus
				; P3.0 = SDA 	= Bit SDA 	= OUTPUT = 0
				; P3.1 = SCL   	= Bit SCL	= OUTPUT = 0
				; P3.2 = INT/	= Bit ---	= INPUT  = 1
				; P3.3 = CS/EEPOT = Bit EEPOT_CS = OUTPUT = 0
				; P3.4 = ALE	= Bit CAN_ALE	= OUTPUT = 0
				; P3.5 = CS/	= Bit CAN_CS	= OUTPUT = 0
				; P3.6 = RD/    = Bit CAN_RD	= OUTPUT = 0
				; P3.7 = WR/	= Bit CAN_WR	= OUTPUT = 0

	;****** LED gn "lebt" einschalten ************************************
	
	cpl	LED_G		
		
	;****** Init I2C- Bus ************************************************
	
	setb	SDA		; Grundzustand I2C-Bus = HIGH
	setb	SCL		; Grundzustand I2C-Bus = HIGH

	;****** Init DS 1621 *************************************************
	
	call	ini_ds1621

	;****** Versorgung DCF77 Modul einschalten ***************************
	
	cpl	DCF77_V		

	;****** Init DCF77 Auswertung ****************************************

	mov	DCF77_BYTENR,#00H
	mov	DCF77_BITNR,#00H
	mov	DCF77_CNT_LOW,#00H	
	mov	DCF77_CNT_HIGH,#00H	
	mov	DCF77_INITWAIT,#00H
	mov	DCF77_TAKEOFF,#00H	

	mov	DCF77_DATA0,#0FFH	; Kennung fuer 'kein Signal'
					; oder fehlerhafte Checksumme	
	mov	DCF77_DATA1,#00H	
	mov	DCF77_DATA2,#00H	
	mov	DCF77_DATA3,#00H	
	mov	DCF77_DATA4,#00H	
	mov	DCF77_DATA5,#00H	
	mov	DCF77_DATA6,#00H	
	mov	DCF77_DATA7,#00H	

	;****** Init CAN Controller ******************************************
	
	setb	CAN_WR		; Grundzustand WR/ = HIGH
	setb	CAN_RD		; Grundzustand RD/ = HIGH
	setb	CAN_CS		; Grundzustand CS/ = HIGH
	clr	CAN_ALE		; Grundzustand ALE = LOW

	call	ein_ms		; Einschwingzeit
	call	ini_can_basic   ; Initialisierung CAN-Controller Register

	;****** Init CAN Transceiver *****************************************
	
	clr	PCA_RS		; no standby CAN transceiver, PIN LOW

	;****** Init CAN Mailboxen *******************************************

	; Mailbox- Layout am Beispiel Box3:	

	; BOX3_C: 	CAN Mailbox 3	Controlbyte
	; BOX3_IH: 	CAN High Byte Botschaftsnumer [HEX]
	; BOX3_IL: 	CAN Low Byte Botschaftsnumer [HEX]
	; BOX3_0:	CAN Botschaft Mailbox 3 	Datenbyte 0
	; BOX3_1:	CAN Botschaft Mailbox 3 	Datenbyte 1
	; BOX3_2:	CAN Botschaft Mailbox 3 	Datenbyte 2
	; BOX3_3:	CAN Botschaft Mailbox 3 	Datenbyte 3
	; BOX3_4:	CAN Botschaft Mailbox 3 	Datenbyte 4
	; BOX3_5:	CAN Botschaft Mailbox 3 	Datenbyte 5
	; BOX3_6:	CAN Botschaft Mailbox 3 	Datenbyte 6
	; BOX3_7:	CAN Botschaft Mailbox 3 	Datenbyte 7

	; Box 0 initialisieren:

	mov	CNT0,#0BH
	mov	R0,#BOX0_C		; indirect adressing
initb0:
	mov	@R0,#0FFH		
	inc	R0
	djnz	CNT0,initb0

	; Box 1 initialisieren:

	mov	CNT0,#0BH
	mov	R0,#BOX1_C		; indirect adressing
initb1:
	mov	@R0,#0FFH		
	inc	R0
	djnz	CNT0,initb1

	; Box 2 initialisieren:

	mov	CNT0,#0BH
	mov	R0,#BOX2_C		; indirect adressing
initb2:
	mov	@R0,#0FFH		
	inc	R0
	djnz	CNT0,initb2

	; Box 3 initialisieren:

	mov	CNT0,#0BH
	mov	R0,#BOX3_C		; indirect adressing
initb3:
	mov	@R0,#0FFH		
	inc	R0
	djnz	CNT0,initb3

	; Box 4 initialisieren:

	mov	CNT0,#0BH
	mov	R0,#BOX4_C		; indirect adressing
initb4:
	mov	@R0,#0FFH		
	inc	R0
	djnz	CNT0,initb4


	ret

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

