;*****************************************************************************
; 	All rights reserved by Dipl.-Ing (FH) Andreas Hoeger
;	Ditzenbrunner Str. 64, 71254 Ditzingen, Germany
;	Telefon: (+497156)490980	Telefax: (+497156)490981
;	E-Mail: ingbuero@andreas-hoeger.de
;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 04.05.2002		
;
;	Aenderungen:
;	04_05_02: Initial version
;	05_05_02: Bugfix (CAN- Mailbox Initwert ist 0FFh)
;	10_06_02: Bugfix (Appdata neu einlesen notwendig)
;	xx_yy_zz: 
;
;*****************************************************************************
	
netzwerk:
	
	;****** mindestend soviele Botschaften holen wie Mailboxen

	call	can_rx    	; pruefen ob Botschaft im Empfangspuffer
				; des SJA1000 ist; ggf. Identifier lesen 
				; und Botschaft in Mailbox uebertragen
	call	can_rx    	; pruefen ob Botschaft im Empfangspuffer
				; des SJA1000 ist; ggf. Identifier lesen 
				; und Botschaft in Mailbox uebertragen
	call	can_rx    	; pruefen ob Botschaft im Empfangspuffer
				; des SJA1000 ist; ggf. Identifier lesen 
				; und Botschaft in Mailbox uebertragen
	call	can_rx    	; pruefen ob Botschaft im Empfangspuffer
				; des SJA1000 ist; ggf. Identifier lesen 
				; und Botschaft in Mailbox uebertragen
	call	can_rx    	; pruefen ob Botschaft im Empfangspuffer
				; des SJA1000 ist; ggf. Identifier lesen 
				; und Botschaft in Mailbox uebertragen

	;****** Mailbox 2 nach Botschaft 501 (ZSTG Appdata) abfragen

	; die soeben eingelesene CAN_Botschaft in BOX 2 auswerten

	; BOX2_C: 	CAN Mailbox 2	Controlbyte
	; BOX2_IH: 	CAN High Byte Botschaftsnumer [HEX]
	; BOX2_IL: 	CAN Low Byte Botschaftsnumer [HEX]
	; BOX2_0:	CAN Botschaft Mailbox 2 	Datenbyte 0
	; BOX2_1:	CAN Botschaft Mailbox 2 	Datenbyte 1
	; BOX2_2:	CAN Botschaft Mailbox 2 	Datenbyte 2
	; BOX2_3:	CAN Botschaft Mailbox 2 	Datenbyte 3
	; BOX2_4:	CAN Botschaft Mailbox 2 	Datenbyte 4
	; BOX2_5:	CAN Botschaft Mailbox 2 	Datenbyte 5
	; BOX2_6:	CAN Botschaft Mailbox 2 	Datenbyte 6
	; BOX2_7:	CAN Botschaft Mailbox 2 	Datenbyte 7

	mov	R0,#BOX2_C		; indirect adressing
	inc	R0			; Basisadresse Mailbox 2
	inc	R0
	inc	R0			; zeigt auf Byte 0

;****** Applikationsdaten entgegennehmen, plausibilisieren 
;       in den RAM- Speicherplatz eintragen (APP_TRENN_SOWI) 
;	und quittieren

	mov	ACC,@R0			; hole byte 0 in Akku

;****** solange noch nichts gesendet wird ist CAN- Mailbox auf FFh
;	initialisiert
	
	inc	A			; von FFh auf Null hochzaehlen
;	--> die obige Zeile zum Test der Fehlermeldung auskommentieren

	jz	dplus_plausi_end

copy_appdata:

	mov	ACC,@R0			; hole byte 0 neu in Akku
	mov	APP_TRENN_SOWI,ACC

plausi_appdata:

	cjne	A,#DPLUS_SOMMER,cmp_dplus_winter
	jmp	dplus_plausi_ok

cmp_dplus_winter:

	cjne	A,#DPLUS_WINTER,cmp_dplus_error

dplus_plausi_ok:

	setb	ZSTG_BIT00			; Kennung fuer Empfang o.k.
	jmp	dplus_plausi_end

cmp_dplus_error:

	mov	ERROR,#EW_APPDATA_PLAUSI
	call	errorcode_out			; Fehlermeldung generieren

dplus_plausi_end:

	ret

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

