;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 16.09.2000		
;
; 	14_02_02: initial version for ZSTG
;       rr_tt_zz: 
;
;*****************************************************************************

        ;*********************************************************************
        ; Initialisierung DS 1621
        ;*********************************************************************

ini_ds1621:

	mov	I2C_ADR_H,#00H		
	mov	I2C_ADR_L,#DS_CONFIG	; Command: Config-Register schreiben
	mov	I2C_ID,#DS_ID		
	mov	I2C_DATA,#DS_CON_INIT	; Initialisieren Config- Register

	call	write_byte_internal
	call	zehn_ms
	call	zehn_ms			; typ. 10ms, max. 50ms

	;mov	I2C_ADR_H,#00H		
	mov	I2C_ADR_L,#DS_TH	; Command: TH-Register schreiben
	;mov	I2C_ID,#DS_ID		
	mov	I2C_DATA,#DS_TH_INIT	; Initialisieren TH- Register

	call	write_byte_internal
	call	zehn_ms
	call	zehn_ms

	;mov	I2C_ADR_H,#00H		
	mov	I2C_ADR_L,#DS_TL	; Command: TL-Register schreiben
	;mov	I2C_ID,#DS_ID		
	mov	I2C_DATA,#DS_TL_INIT	; Initialisieren TL- Register

	call	write_byte_internal
	call	zehn_ms
	call	zehn_ms
	
	;mov	I2C_ADR_H,#00H		
	mov	I2C_ADR_L,#DS_START_CON	; Command: start conversion
	;mov	I2C_ID,#DS_ID		

	call	write_ds_command
	call	zehn_ms
	call	zehn_ms

	ret
	
        ;*********************************************************************
        ; Unterprogramme fuer I2C- Bus, nur DS1621 
        ;*********************************************************************

write_ds_command:

	; I2C-Bus Byte Write function 
	; for DS1621 only --> command without data
	; Called with command in I2CADR_L. Device ID in I2C_ID.
	; Does not wait for write cycle to complete.
	; Destroys A.

	call	start

	mov	a,I2C_ADR_H	; 
	rl	a		; programmable address to bits 3:1
	orl	a,I2C_ID	; add fixed address
	clr	acc.0		; specify write operation
	call	shout		; send device address

	mov	a,I2C_ADR_L	; send command
	call	shout		;

	call	stop
	ret

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

