;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 16.09.2000
;		
;	27_09_02: uebernommen von MSTG fuer Umwandlung ADC Messergebnisse
;	14_10_02: Bugfix: keine negativen Werte, volle 8 Bit verwenden
;
;*****************************************************************************

        ;*********************************************************************
	; Umwandlung eines HEX- Wertes vom ADC in einen
	; Dezimalwert und Konvertierung in ASCII- Zeichen.
	; Eingangswert in ADC_DEZ_E.
	; Ergebnis in ADC_DEZ_H (Hunderterstelle in ASCII)
	; und in ADC_DEZ_Z (Zehnerstelle in ASCII)
	; sowie ADC_DEZ_E (Einerstelle in ASCII) 
	; negative Werte werden in positive gewandelt (Zweierkomplement)
	; bei negativen Werten wird Bit00 gesetzt zurckgegeben (Merker "-")

	; 8 Bit Wertebereich, daher keine negativen Zahlen, kein bit00 

hex_dez_ascii:

	;****** zuerst auf Null pruefen
	
	mov	A,#0
	mov	ADC_DEZ_H,A		; loeschen Ergebnis Hunderterstelle
	mov	ADC_DEZ_Z,A		; loeschen Ergebnis Zehnerstelle
	mov	A,ADC_DEZ_E
	jz	end_dez_vorher		; nicht durch Null teilen !
	jmp	positiv

	; vor dem beenden statt der Nullen die ASCII- Nullen eintragen:

end_dez_vorher:
	add	A,#ASCII_ADDZ		; 1-9 in ASCII 1 bis 9 umwandeln
	mov	ADC_DEZ_H,A
	mov	ADC_DEZ_Z,A
	mov	ADC_DEZ_E,A
	jmp	end_dez

	;****** HEX --> DEZ --> ASCII

positiv:	
	mov	B,#100			; zuerst durch hundert teilen
	div	AB			; Ergebnis: A = ganze Hunderter
					;           B = Rest
	add	A,#ASCII_ADDZ		; 1-9 in ASCII 1 bis 9 umwandeln
	mov	ADC_DEZ_H,A

	mov	A,B			; Rest in A weiterbearbeiten
	mov	B,#10			; duch zehn teilen
	div	AB			; Ergebnis: A = ganze Zehner
					;           B = Rest
	add	A,#ASCII_ADDZ		; 1-9 in ASCII 1 bis 9 umwandeln
	mov	ADC_DEZ_Z,A
	
	mov	A,B
	add	A,#ASCII_ADDZ		; 1-9 in ASCII 1 bis 9 umwandeln
	mov	ADC_DEZ_E,A

end_dez:
	ret

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************


