;*****************************************************************************
; 	All rights reserved by Dipl.-Ing (FH) Andreas Hoeger
;	Ditzenbrunner Str. 64, 71254 Ditzingen, Germany
;	Telefon: (+497156)490980	Telefax: (+497156)490981
;	E-Mail: ingbuero@andreas-hoeger.de
;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 04.05.2002		
;
;	Aenderungen:
;	04_05_02: Neuerstellung 
;       10_06_02: Bugfix: IN_OPTO wird entprellt, nicht der LOOPCNT
;
;*****************************************************************************
	; Signal-Entprellung fr Klemme 15, 58 und D+

	; Vorgehensweise:
	; Die aktuell auf der CAN- Mailbox liegenden Werte werden gelesen.
	; Erst wenn sich ein Zustand ber x Zyklen stabil zeigt wird er in 
	; die Speicherkopie uebertragen SIGPRELL_OUT

	; Voraussetzungen: Die HSTG- Status Botschaft (500h) wurde in der 
	;		   Mailbox aktualisiert und in jedem Zyklus 
	;		   wird diese Routine aufgerufen

sigprell:	

	; die soeben eingelesene CAN_Botschaft in BOX 3 auswerten

	mov	R0,#BOX1_C		; indirect adressing
	inc	R0			; Basisadresse Mailbox 1
	inc	R0
	inc	R0			; zeigt auf Byte 0

;****** Entsprechende Bits einlesen 

	inc	R0			
	inc	R0
	inc	R0
	inc	R0			; zeigt auf IN_OPTO

	mov	ACC,@R0		; hole byte 0 in Akku
	mov	SIGPRELL_OUT,A	; und kopiere in den RAM- Speicher

; ENTPRELLUNG HIER EINFUEGEN FALLS NOTWENDIG


;SIGPRELL_OUT:	  	DS	1	; Entprellte Werte der HSTG- Status Botschaft
;PRELL_COUNT_15:	DS	1	; Entprell-Counter
;PRELL_COUNT_56:	DS	1	; Entprell-Counter
;PRELL_COUNT_DPLUS: 	DS	1	; Entprell-Counter



sigprell_end:

	ret	

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

