;*****************************************************************************
; 	All rights reserved by Dipl.-Ing (FH) Andreas Hoeger
;	Ditzenbrunner Str. 64, 71254 Ditzingen, Germany
;	Telefon: (+497156)490980	Telefax: (+497156)490981
;	E-Mail: ingbuero@andreas-hoeger.de
;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm fuer ZSTG, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 02.03.2003		
;
;	Aenderungen:
;
;	02_03_03: Neuerstellung fr PowerDown Wakeup ueber CAN
;	07_03_03: IR lesen eingefuegt, weil sonst INT/ immer low bleibt
;	13_03_03: added CAN transceiver standby mode
;	xx_yy_zz: 
;
;*****************************************************************************


        ;*********************************************************************
	;****** Interruptroutine fr EXT Interrupt 0 (SJA1000 - CAN) *********
        ;*********************************************************************

	; Diese Interruptroutine wird angesprungen, wenn der CAN-Controller
	; SJA1000 einen Interrupt auslst.
	; Im CAN-Controller ist nur der Receive Interrupt aktiviert.
	
irq_can:	
	;push	PSW
	;push	ACC
	;push	B

	; Dieser Interrupt soll nur dazu dienen, den IDLE-Mode des Prozessors
	; in regelmaessigen Abstaenden zu beenden.	

	nop

	; IR im SJA1000 muss gelesen werden damit der Interrupt-Pin
	; wieder zurckgenommen wird.

can_read_IR:	

	mov	CAN_ADR,#CAN_ADR_IR
	call	can_read			; Ergebnis in CAN_DAT
	mov	CAN_IR_VALUE,CAN_DAT
	; gelesene Daten werden nicht gebraucht
	; aber zur Info auf CAN legen

	;***** Task "CAN Transceiver aus Standby mode zurckholen"
	; NOTE: Wakeup interrupt on RX when bus-activity, but RS PIN must be
	; released by the microcontroller manually

	clr	PCA_RS		; no standby CAN transceiver, PIN LOW


irq_can_popweg:	
	;pop	B	
	;pop	ACC
	;pop	PSW

	reti		

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

