;*****************************************************************************
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;       Projekt: T4- Modul 		Version: V1.0
;	ASM-Software:			Testversion
;       Autor: Andreas Hoeger
;
;       Datum: 02.07.2000
;       --> zustzlich aendern: Headertext weiter unten im Code "ORG ...."
;
;	Timing ausgelegt fuer Systemtakt mit 16 MHz Quarz
;
;*****************************************************************************

        $MOD51                          ; use 8051 predefined symbols
        $SYMBOLS                        ; append symbol table to listing

;*****************************************************************************

        DSEG

	;****** 00h bis 1Fh = Registerbaenke 0 bis 3
	;****** 20h bis 2Fh = bitadressierbarer Bereich

       	ORG     20h			
BITS:   DS      1                       ; Merker- Bits
CNT0:	DS	1
CNT1:	DS	1
CNT2: 	DS	1

	;****** bis 5Fh = frei
	;****** 60h bis 7Fh = Stack

        ORG     60h
STACK:  DS      20h                     ; Stack definieren von 60h bis 80h

	;****** ab 80h oberer RAM Bereich parallel zu SFRs

	;****** Definitionen RAM- Speicher

MERK00	BIT	BITS.0
MERK01  BIT     BITS.1                 
MERK02  BIT     BITS.2                 
MERK03  BIT     BITS.3                 
MERK04  BIT     BITS.4                 
MERK05  BIT     BITS.5                 
MERK06  BIT     BITS.6
MERK07  BIT     BITS.7 
	
	;****** Definitionen allgemein

LED	BIT	p2.7			; Leuchtdiode (LED an=LOW, aus=HIGH)

;*****************************************************************************
        
        CSEG

        ;*********************************************************************
        ; Interrupt- Vectortabelle
        ;*********************************************************************

        ORG     0000h				;power on / reset vector
        jmp     on_reset

	ORG	0003h				;external interrupt 0 vector
	reti

        ORG     000Bh                           ;timer 0 overflow vector
	reti
        
	ORG     0013h                           ;external interrupt 1 vector
	reti

        ORG     001Bh                           ;timer 1 overflow vector
	reti

        org     0023h                           ;serial I/O interrupt vector
	reti                          

        ORG     002Bh                           ;timer 2 overflow vector
	reti

	ORG	0033h				;?? reserved ??
	reti

        ;*********************************************************************
        ORG     00E0H				; lesbare Kennung 
        DB      'T4-Modul V1.0   '		; ASCII- Text ins HEX- File
        DB      'Hoeger_blink_led'		; eintragen
        ;*********************************************************************

        ;*********************************************************************
        ; Beginn Anwendungs- Programmcode
        ;*********************************************************************
        
        ORG     0100H

on_reset:  
	;****** min. 500 ms Wartezeit wegen Errata-Sheet
	;****** ISP sonst ab dem zweiten mal blockiert

errata: mov	CNT0,#05H
err2:	nop
	mov	CNT1,#0FFH
err3:	nop
	mov	CNT2,#0FFH
err4:	nop	
	djnz	CNT2,err4
	djnz	CNT1,err3
	djnz	CNT0,err2
			
	;****** START  System-Initialisierung

        mov     IE,#00H			; Interrupts nicht freigeben

	mov	8EH,#01H		; Bit 0 von SFR 8Eh setzen, damit
					; ALE- Pin nicht auf 1/6 osz-freq. schwingt

	mov     SP,#STACK		; Stackpointer auf Stackbereich setzen

	;****** PORT 0: 1=Input, 0=Output
        mov	P0,#0FFH		; Port 0 an CAN- Controller

	;****** PORT 1: 1=Input, 0=Output
	mov     P1,#0FCH		; Port 1 digital inputs / SPI

	;****** PORT 2: 1=Input, 0=Output
	mov	P2,#00H			; Port 2 LCD und LED

	;****** PORT 3: 1=Input, 0=Output
        mov     P3,#0CH			; Port 3 CAN-Steuerltg. und I2C-Bus
	

        mov     BITS,#00H		; Merkerbits loeschen


	;****** ENDE System-Initialisierung


	;****** START Blink- LED

delay:	mov	CNT0,#090H		
loop0:	nop				
	mov	CNT1,#0FFH
loop1:	nop
	djnz	CNT1,loop1
	djnz	CNT0,loop0
	
	cpl	LED
	jmp	delay			; LED toggeln

	;****** ENDE Blink-LED 


stop:	nop
	nop
	jmp	stop


;*****************************************************************************
; ENDE DES GESAMTEN QUELLTEXTES
;*****************************************************************************

        END

