;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 16.09.2000		
;
;	Aenderungen:
;	25_10_00: R5,R6,R7 verwendet statt R0,R1,R2 weil das mit "indirect
;		  " addressing" kollidiert.
;
;*****************************************************************************

	;*********************************************************************
        ; Unterprogramm Zeitschleife 0.05 ms (50 us fuer LCD)
        ;*********************************************************************

us_50:
	mov	R5,#42H
wait4:	nop
	djnz	R5,wait4
	
	ret			

        ;*********************************************************************
        ; Unterprogramm Zeitschleife 1 ms
        ;*********************************************************************

ein_ms:	nop
	mov	R5,#10H
wait0:	nop
	mov	R6,#1AH
wait1:	nop
	djnz	R6,wait1
	djnz	R5,wait0
	
	ret			

        ;*********************************************************************
        ; Unterprogramm Zeitschleife 10 ms
        ;*********************************************************************

zehn_ms:nop
	mov	R5,#11h
wait2:	nop
	mov	R6,#0FFh
wait3:	nop
	djnz	R6,wait3
	djnz	R5,wait2
	
	ret			

        ;*********************************************************************
        ; Unterprogramm Zeitschleife 1s
        ;*********************************************************************

sek_1: 	nop
	mov	R5,#7H		; ca. 1 Sekunde
wait5a:	nop
	mov	R6,#0FFH
wait6a:	nop
	mov	R7,#0FFH
wait7a:	nop	
	djnz	R7,wait7a
	djnz	R6,wait6a
	djnz	R5,wait5a
	
	ret

        ;*********************************************************************
        ; Unterprogramm Zeitschleife 3s
        ;*********************************************************************

sek_3: 	nop
	mov	R5,#15H		; ca. 3 Sekunden
wait5:	nop
	mov	R6,#0FFH
wait6:	nop
	mov	R7,#0FFH
wait7:	nop	
	djnz	R7,wait7
	djnz	R6,wait6
	djnz	R5,wait5
			
	ret

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

