;*****************************************************************************
; 	All rights reserved by Dipl.-Ing (FH) Andreas Hoeger
;	Ditzenbrunner Str. 64, 71254 Ditzingen, Germany
;	Telefon: (+497156)490980	Telefax: (+497156)490981
;	E-Mail: ingbuero@andreas-hoeger.de
;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm, wird durch INCLUDE eingebunden
; 	Unterprogramme fr Schaltfunktionen durch Menuesteuerung
;
;       Autor: Andreas Hoeger
;       Datum: 20.08.2002		
;
;	Aenderungen:
;	20_08_02: Erstversion fuer MSTG
;	07_09_02: Heizrelais und Lueftung Heizung eingefuegt
;	16_05_03: Luefter fuer Zusatzoelkuehler ansteuern eingefuegt
;	xx_yy_zz: 
;
;*****************************************************************************
; Ausgaberelais:	; Bit 0 (LSB): Relais 04: Webasto Standheizung
; OUT_SHIFT		; Bit 1      : Relais 03: Heiz-Lueftanschluss Webasto
			; Bit 2      : Relais 02: Vorgluehschaltung wg. Heizg.
			; Bit 3	     : Relais 01: Zusatzoelkuehler Luefter
			; Bit 4      : ---
			; Bit 5	     : ---
			; Bit 6	     : ---
			; Bit 7	(MSB): ---
;*****************************************************************************
	; Belegung CAN Botschaft 'HZG_COMMAND' Botschaft 503
	; Byte 0: Bit 0: Webasto Standheizung		1=ein, 0=aus (auf CAN)
	;						durch Menue ausgeloest		
	;	  Bit 1: Webasto Standheizung		1=ein, 0=aus (auf CAN)
	;						durch Uhr ausgeloest 
	;	  Bit 2: Webasto Standheizung		1=ein, 0=aus (auf CAN)
	;						durch WAECO ausgelst
	;	  Bit 3: 
	;	  Bit 4: 
	;	  Bit 5:
	;	  Bit 6:
	;	  Bit 7:
;*****************************************************************************

heizrelais_ein:			; Ansteuerung Relais
				; an MSTG_Basisplatine
	mov	A,OUT_SHIFT
	orl	A,#OUT_HEIZRELAIS_SET	; OR
	mov	OUT_SHIFT,A
	ret

heizrelais_aus:			; Ansteuerung Relais
				; an MSTG_Basisplatine
	mov	A,OUT_SHIFT
	anl	A,#OUT_HEIZRELAIS_CLR	; AND
	mov	OUT_SHIFT,A
	ret

;******

oellueft_ein:			; Ansteuerung Relais
				; an MSTG_Basisplatine
	mov	A,OUT_SHIFT
	orl	A,#OUT_OELLUEFT_SET	; OR
	mov	OUT_SHIFT,A
	ret

oellueft_aus:			; Ansteuerung Relais
				; an MSTG_Basisplatine
	mov	A,OUT_SHIFT
	anl	A,#OUT_OELLUEFT_CLR	; AND
	mov	OUT_SHIFT,A
	ret

;******

lueftung_hzg_ein:		; Lueftung Standheizung einschalten
				; ueber CAN an HSTG
	mov 	A,HZG_COMMAND
	orl	A,#01H
	mov 	HZG_COMMAND,A		;Bit [0]    1 = ein
	ret
				
lueftung_hzg_aus:		; Lueftung Standheizung ausschalten
				; ueber CAN an HSTG
	mov 	A,HZG_COMMAND
	anl	A,#0FEH
	mov 	HZG_COMMAND,A		;Bit [0]    0 = aus
	ret


;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

