 ;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 16.09.2000		
;
;	Aenderungen:
;	20_08_02: Erstversion, von HSTG uebernommen
;	10_11_00: 
;
;*****************************************************************************

        ;*********************************************************************
        ; Unterprogramm zum Einlesen der Schieberegister
        ;*********************************************************************
	
io_shift:	
	; Diese Routine gibt ein Byte an das
	; Ausgangsschieberegister aus und liest die Eingangsdaten vom 
	; Eingangsschieberegister ein, MSB first (Bit Nr. H von IC6 
	; kommt zuerst).
	; Portpins Eingang / Ausgang ist bereits definiert.
	; DIG_CLK wird low erwartet und kehrt low zurueck.
	; DIG_SH wird high erwartet und kehrt high zurueck.
	; DIG_DS wird low erwartet und kehrt low zurueck.
	; Erhaltenes Byte von IC6 (Optokoppler) wird in IN_OPTO zurueckgegeben.

	; !! Das erste Bit kann vor dem ersten Takt eingelesen werden !!

	; Ausgabewerte werden in OUT_SHIFT erwartet und von dort verwendet.
	; Inhalt des Registers OUT_SHIFT wird bei der Ausgabe nicht zerstoert, 
	; weil IN_OPTO als Zwischenspeicher funktioniert, das spaeter sowieso
	; neu geladen wird mit echten Eingangswerten.	

	; Ablauf:
	; * zuerst die 8 Ausgangsbits raustakten
	; * in Ausgangsreg. uebernehmen und von Eingangsreg. latchen
	; * dann 8 Eingangswerte reintakten

	push	ACC
	mov	IN_OPTO,#00H

sh_out:
	; Ausgabebits raustakten
	mov	CNT0,#8		; Anzahl Schiebeaktionen fr 8 Bit
	mov	IN_OPTO,OUT_SHIFT	; OUT_SHIFT umladen damit es 
					; erhalten bleibt
sh_ic16:
	mov	A,IN_OPTO	; fuer Zwischenspeicherung beim Schieben
	rlc	A
	mov	DIG_DS,C	; output Bit an IC16
	mov	IN_OPTO,A	; sichern fuer Zwischenspeicherung
		
	setb	DIG_CLK		; steigende Flanke Takt
	call	us_50
	clr	DIG_CLK		; Taktpuls beenden
	call	us_50
	djnz	CNT0,sh_ic16

sh_over:
	; Datenuebernahme / Datenuebergabe	

	clr	DIG_SH		; DIG_SH auf low, Daten parallel laden
				; bei steigender Flanke Ausgangsdaten
				; in Ausgangslatch uebernehmen
	call	us_50						
	setb	DIG_SH		; DIG_SH auf high, Daten jetzt schieben

sh_in:
	; Eingangsbits hereintakten fuer IC6
	mov	CNT0,#8		; Anzahl Bits pro Byte
	
sh_ic6:	mov	A,IN_OPTO	; fuer Zwischenspeicherung beim Schieben
	mov	C,DIG_QH6	; input Bit von IC6
	rlc	A
	mov	IN_OPTO,A	; sichern fuer Zwischenspeicherung
		
	setb	DIG_CLK		; steigende Flanke Takt
	call	us_50
	clr	DIG_CLK		; Taktpuls beenden
	call	us_50
	djnz	CNT0,sh_ic6

	pop	ACC
	ret

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

 
