;*****************************************************************************
; 	All rights reserved by Dipl.-Ing (FH) Andreas Hoeger
;	Ditzenbrunner Str. 64, 71254 Ditzingen, Germany
;	Telefon: (+497156)490980	Telefax: (+497156)490981
;	E-Mail: ingbuero@andreas-hoeger.de
;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm fuer MSTG, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 14.04.2001		
;
;	Aenderungen:
;
;	02_05_02: Neuerstellung fuer MSTG, von dcf_irq.asm
;
;*****************************************************************************


        ;*********************************************************************
	;****** Interruptroutine fr Timer 0 ********
        ;*********************************************************************

	; Der Timer 0 arbeitet mit einem Prescaler, ist also 13 Bit breit.
	; Der Systemtakt ist 16 MHz. (1/16 MHz = 62,5 ns)
	; Ein Programmtakt ist 12 cycles lang, also 0,75 us.
	; Der Timer wird bei jedem Programmtakt erhht, lauft also bei 
	; 8192 * 0.75 us = 6.144 ms ueber und erzeugt in diesem Raster
	; Timer 0 overflow Interrupts.

	; Waehrend  100 ms kommen  16,27 Interrupts
	; Waehrend  200 ms kommen  32,55 Interrupts
	; Waehrend 1000 ms kommen 162,76 Interrupts
	
irq_t0:	
	push	PSW
	push	ACC
	push	B
	mov	MSTG_IRQ_PUSHPOP,R7
	push	MSTG_IRQ_PUSHPOP		; R7 wird in IRQ verwendet

	
	; nur fuer Interrupt- Test
	; cpl	LED
	; nur fuer Interrupt- Test

popweg:	
	pop	MSTG_IRQ_PUSHPOP
	mov	R7,MSTG_IRQ_PUSHPOP
	pop	B	
	pop	ACC
	pop	PSW

	reti		

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

