;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm fuer MSTG, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 02.05.2002		
;
;	Aenderungen:
;
;       02_05_02: initial version from ZSTG (with changes)
;	20_07_02: EW_CAN_RX_OVERLOAD, CAN_RX_CALL_TO und CAN_RX_CNT eingefuegt
;	20_08_02: Schieberegisterdefinitionen eingefuegt
;	25_08_02: Stack-Overflowerkennung Definitionen
;	26_08_02: Portpin und defines fuer 1_wire eingefuegt
;	07_09_02: HZG_COMMAND eingefuegt
;	09_09_02: ERROR verschoben und ADC-hex-dez-ascii eingefuehrt
;	03_10_02: POWERDOWN_MSTG eingefuehrt
;	16_05_03: Zusatzoelkuehler-Luefter defines eingefuegt
;		  
;*****************************************************************************

        DSEG

	;****** 00h bis 1Fh = Registerbaenke 0 bis 3 *************************
	;****** 20h bis 2Fh = bitadressierbarer Bereich **********************

       	ORG     20h

BITS:   	  DS    1      	; Merker- Bits
LOOPCNT:	  DS	1	; Zaehler fuer Taskschema, zaehlt fuer CAN
MSTG_ALIVE:	  DS	1	; Alive-Counter fr Steuegeraeteueberwachung
TASK_BITS:	  DS    1       ; Zaehler fuer Taskberechnungen
MSTG_BITS:	  DS	1	; Einzelbits fuer Datenuebertragung auf CAN

IN_OPTO:          DS	1	; Eingangsdaten von IC6 (Schieberegister)
				; Optokoppler- Eingangsdaten
OUT_SHIFT:	  DS	1       ; Datenbyte fr das Ausgangsschieberegister 



	;****** 30h bis 3Fh = Allzweckbytes **********************************

	ORG	30h

CNT0:		DS	1	; Counter- Byte 0
CNT1:		DS	1	; Counter- Byte 1
CNT2: 		DS	1	; Counter- Byte 2

MERK:		DS	1	; Allzweckmerker

TEMP_H:		DS	1	; Temperatur-Ergebnis vom DS1621, high byte
TEMP_L: 	DS	1	; Temperatur-Ergebnis vom DS1621, low byte

ADC_DEZ_H:	DS	1	; Hunderterstelle
ADC_DEZ_Z:	DS	1	; Zehnerstelle
ADC_DEZ_E:	DS	1	; Einerstelle und Eingangswertuebergabe

ASCII_H:	DS	1	; ASCII- Zeichen, HIGH- Teil eines Hexwerts
ASCII_L:	DS	1	; ASCII- Zeichen, LOW- Teil eines Hexwerts

I2C_ADR_H:	DS	1	; oberer Teil der Bit- Adresse im EEPROM
I2C_ADR_L:	DS	1	; unterer Teil der Bit- Adresse im EEPROM
I2C_ID:		DS	1	; Device- ID des Bausteines
I2C_DATA:	DS	1	; (erstes) Datenbyte vom I2C- Bus
I2C_DATA_2:	DS	1	; zweites Datenbyte vom I2C- Bus


	;****** 40h bis 4Fh = CAN- Sende- Puffer & sonstiges fuer CAN ********

	ORG	40h

CAN_I1:	DS	1		; CAN Botschaft Identifier Byte 1
CAN_I2:	DS	1		; CAN Botschaft Identifier Byte 1
CAN_D0:	DS	1		; CAN Botschaft Datenbyte 0
CAN_D1:	DS	1		; CAN Botschaft Datenbyte 1
CAN_D2:	DS	1		; CAN Botschaft Datenbyte 2
CAN_D3:	DS	1		; CAN Botschaft Datenbyte 3
CAN_D4:	DS	1		; CAN Botschaft Datenbyte 4
CAN_D5:	DS	1		; CAN Botschaft Datenbyte 5
CAN_D6:	DS	1		; CAN Botschaft Datenbyte 6
CAN_D7:	DS	1		; CAN Botschaft Datenbyte 7
	
CAN_ADR:	DS	1	; CAN Adresse fuer Read Byte/ Write Byte
CAN_DAT: 	DS	1	; CAN Daten fuer Read Byte/ Write Byte

CAN_SORT_MERKID1: DS	1	; Allgemeiner Merker fr ID-Extraktion
CAN_SORT_MERKID2: DS	1	; Allgemeiner Merker fr ID-Extraktion
CAN_SORT_ID1:	  DS	1	; Ident. der Botschaft fr RX- Routine
CAN_SORT_ID2:	  DS	1	; Ident. der Botschaft fr RX- Routine

	;****** 50h bis 5Fh = ADC Daten und sonstiges ****

	ORG	50h

ERROR:		  DS	1	; Fehlercode

OEL_DRUCK:	  DS	1	; Oeldruck Motor		ADC2 / C
LLK_DRUCK:	  DS	1	; Ladedruck			ADC2 / D

LLK_H2O_TEMP:	  DS	1       ; Wassertemperatur LLK		ADC1 / A
MOTOR_H2O_TEMP:	  DS	1	; Wassertemperatur Motor	ADC1 / B
LLK_TEMP:	  DS	1	; Ladelufttemperatur		ADC1 / C
OEL_TEMP:	  DS	1	; Oeltemperatur Motor		ADC1 / D

CAN_RX_CNT:	DS	1	; Counter fuer CAN RX Routinen-Timeout

MSTG_IRQ_PUSHPOP:  DS	1	; fuer Timer Interrupt Routine

ONEWIRE_PARAM:  DS  1	; 1-wire Parameter eins

HZG_COMMAND:	DS	1	; Kommando fuer Standheizung an HSTG
HZG_ONOFF_CNT:  DS	1	; Zaehler fuer Ein-Aus Schaltvorgaenge
				; von den verschiedenen Quellen

	;****** 60h bis 7Fh = Stack ** Stack incrementiert ********************

        ORG     60h

;STACK:  	DS      20h     ; Stack definieren von 60h bis 80h
STACK:    	DS      8h      ; Stack definieren von 60h bis 80h
STACK_1:  	DS      8h      ; Stack definieren von 60h bis 80h
STACK_2:  	DS      8h      ; Stack definieren von 60h bis 80h
STACK_3:  	DS      5h      ; Stack definieren von 60h bis 80h
STACK_END_MARK: DS	1	; Endemarkierung fr Overflowerkennung
; reserve	DS	1
; reserve	DS  	1

	;****** von 80h bis FFH oberer RAM Bereich parallel zu SFRs **********
	;****** --> beachte Adressierungsart, sie whlt den Bereich **********
	;****** --> "direct adressing" spricht SFRs an (mov 0A0H #data) ******
	;****** --> "indirect adressing" spricht RAM an (mov @R0, #data) *****

	ORG	80h

	ORG	90h
	; pro empfangene (wichtige) Botschaft eine Mailbox anlegen mit
	; 8 Datenbytes und einem Kontrollwort
	; Kontrollwoerter am Anfang

BOX0_C:	DS	1		; CAN Mailbox 0 Controlbyte
BOX0_IH: DS	1		; CAN High Byte Botschaftsnumer [HEX]
BOX0_IL: DS	1		; CAN Low Byte Botschaftsnumer [HEX]
BOX0_0:	DS	1		; CAN Botschaft Mailbox 0 	Datenbyte 0
BOX0_1:	DS	1		; CAN Botschaft Mailbox 0 	Datenbyte 1
BOX0_2:	DS	1		; CAN Botschaft Mailbox 0 	Datenbyte 2
BOX0_3:	DS	1		; CAN Botschaft Mailbox 0 	Datenbyte 3
BOX0_4:	DS	1		; CAN Botschaft Mailbox 0 	Datenbyte 4
BOX0_5:	DS	1		; CAN Botschaft Mailbox 0 	Datenbyte 5
BOX0_6:	DS	1		; CAN Botschaft Mailbox 0 	Datenbyte 6
BOX0_7:	DS	1		; CAN Botschaft Mailbox 0 	Datenbyte 7

BOX1_C:	DS	1		; CAN Mailbox 1	Controlbyte
BOX1_IH: DS	1		; CAN High Byte Botschaftsnumer [HEX]
BOX1_IL: DS	1		; CAN Low Byte Botschaftsnumer [HEX]
BOX1_0:	DS	1		; CAN Botschaft Mailbox 1 	Datenbyte 0
BOX1_1:	DS	1		; CAN Botschaft Mailbox 1 	Datenbyte 1
BOX1_2:	DS	1		; CAN Botschaft Mailbox 1 	Datenbyte 2
BOX1_3:	DS	1		; CAN Botschaft Mailbox 1 	Datenbyte 3
BOX1_4:	DS	1		; CAN Botschaft Mailbox 1 	Datenbyte 4
BOX1_5:	DS	1		; CAN Botschaft Mailbox 1 	Datenbyte 5
BOX1_6:	DS	1		; CAN Botschaft Mailbox 1 	Datenbyte 6
BOX1_7:	DS	1		; CAN Botschaft Mailbox 1 	Datenbyte 7

BOX2_C:	DS	1		; CAN Mailbox 2	Controlbyte
BOX2_IH: DS	1		; CAN High Byte Botschaftsnumer [HEX]
BOX2_IL: DS	1		; CAN Low Byte Botschaftsnumer [HEX]
BOX2_0:	DS	1		; CAN Botschaft Mailbox 2 	Datenbyte 0
BOX2_1:	DS	1		; CAN Botschaft Mailbox 2 	Datenbyte 1
BOX2_2:	DS	1		; CAN Botschaft Mailbox 2 	Datenbyte 2
BOX2_3:	DS	1		; CAN Botschaft Mailbox 2 	Datenbyte 3
BOX2_4:	DS	1		; CAN Botschaft Mailbox 2 	Datenbyte 4
BOX2_5:	DS	1		; CAN Botschaft Mailbox 2 	Datenbyte 5
BOX2_6:	DS	1		; CAN Botschaft Mailbox 2 	Datenbyte 6
BOX2_7:	DS	1		; CAN Botschaft Mailbox 2 	Datenbyte 7

BOX3_C:	DS	1		; CAN Mailbox 3	Controlbyte
BOX3_IH: DS	1		; CAN High Byte Botschaftsnumer [HEX]
BOX3_IL: DS	1		; CAN Low Byte Botschaftsnumer [HEX]
BOX3_0:	DS	1		; CAN Botschaft Mailbox 3 	Datenbyte 0
BOX3_1:	DS	1		; CAN Botschaft Mailbox 3 	Datenbyte 1
BOX3_2:	DS	1		; CAN Botschaft Mailbox 3 	Datenbyte 2
BOX3_3:	DS	1		; CAN Botschaft Mailbox 3 	Datenbyte 3
BOX3_4:	DS	1		; CAN Botschaft Mailbox 3 	Datenbyte 4
BOX3_5:	DS	1		; CAN Botschaft Mailbox 3 	Datenbyte 5
BOX3_6:	DS	1		; CAN Botschaft Mailbox 3 	Datenbyte 6
BOX3_7:	DS	1		; CAN Botschaft Mailbox 3 	Datenbyte 7

BOX4_C:	DS	1		; CAN Mailbox 4	Controlbyte
BOX4_IH: DS	1		; CAN High Byte Botschaftsnumer [HEX]
BOX4_IL: DS	1		; CAN Low Byte Botschaftsnumer [HEX]
BOX4_0:	DS	1		; CAN Botschaft Mailbox 4 	Datenbyte 0
BOX4_1:	DS	1		; CAN Botschaft Mailbox 4 	Datenbyte 1
BOX4_2:	DS	1		; CAN Botschaft Mailbox 4 	Datenbyte 2
BOX4_3:	DS	1		; CAN Botschaft Mailbox 4 	Datenbyte 3
BOX4_4:	DS	1		; CAN Botschaft Mailbox 4 	Datenbyte 4
BOX4_5:	DS	1		; CAN Botschaft Mailbox 4 	Datenbyte 5
BOX4_6:	DS	1		; CAN Botschaft Mailbox 4 	Datenbyte 6
BOX4_7:	DS	1		; CAN Botschaft Mailbox 4 	Datenbyte 7

	;****** Definitionen Allzweck- Speicherbits **************************

BIT00	BIT	BITS.0
BIT01   BIT     BITS.1                 
BIT02   BIT     BITS.2                 
BIT03   BIT     BITS.3                 
BIT04   BIT     BITS.4                 
BIT05   BIT     BITS.5                 
BIT06   BIT     BITS.6
BIT07   BIT     BITS.7     
	
	;****** Definitionen fuer I2C- Bus (DS1621) **************************

SCL		BIT	p3.1		; serial clock
SDA		BIT	p3.0		; serial data

DS_ID		EQU	90H		; DS1621 Device-Address (1001_000X)

DS_READ_TEMP	EQU	0AAH		; Command "read temperature"
DS_START_CON	EQU	0EEH		; Command "initiate temp conversion"
DS_STOP_CON	EQU	22H		; Command "stop temp conversion"
DS_CONFIG	EQU	0ACH		; Command "access configuration reg"
DS_TH		EQU	0A1H		; Command "access TH- Register"
DS_TL		EQU	0A2H		; Command "access TL- Register"	

DS_CON_INIT	EQU	8AH		; Initwert Config-Register
					; Bit 7: DONE- Flag  = 1 = ready
					; Bit 6: TH Flag     = 0 = temp>=TH
					; Bit 5: TL Flag     = 0 = temp<=TL
					; Bit 4: NVB	     = 0 = EE ready
					; Bit 3 und 2: 	     = 10 (hardwired)
					; Bit 1: POL	     = 1 = active H
					; Bit 0: 1SHOT	     = 0 = continuous

DS_TH_INIT	EQU	05H		; Thermostat +5C
DS_TL_INIT	EQU	03H		; Thermostat +3C

	;****** Definitionen fuer 1-wire Bus (ADC) ***************************

ONEWIRE		BIT	p2.0		; 1-wire bus connection

READMEMORY	EQU	0AAH		; Befehl zum Registerlesen
WRITEMEMORY	EQU	55H		; Befehl zum Registerschreiben
CONVERT		EQU	3CH		; Befehl zum ADC Wandeln

MATCHROM	EQU	55H		; ROM command Befehl
					; address a specific device
SKIPROM		EQU	0CCH		; ROM command Befehl
					; auslassen der Adressierung
SEARCHROM	EQU	0F0H		; ROM command Befehl
					; suche nach device auf Bus
READROM		EQU	33H		; ROM command Befehl
					; lese einzelne device ID


	;****** Configuration Data for DS2450 Pages
	; Page 0 : Conversion Read-Out	--> no setup
	; Page 1 : Control/Status Data	--> setup
	; Page 2 : Alarm Settings	--> not used
	; Page 3 : Factory Calibration	--> setup address 1Ch

	;****** Page 1 Control Data Device 1 (Temperaturen)
	; jeweils 8-bit Auflsung, 5,1 V max.

DEV1_P1_A_08	EQU	08H		; Inhalt Control/Status Data A
				; - bit 03 .. 00 number of bit to convert
				; - bit 05 .. 04 always zero
				; - bit 07 .. 06 zero when analog input
DEV1_P1_A_09	EQU	01H		; Inhalt Control/Status Data A
				; - bit 00	 0=2.55 / 1=5.10 V
				; - bit 06 .. 01 zeros and alarm flags
				; - bit 07       PowerOnReset --> 0

DEV1_P1_B_0A	EQU	08H		; Inhalt Control/Status Data B
DEV1_P1_B_0B	EQU	01H		; Inhalt Control/Status Data B

DEV1_P1_C_0C	EQU	08H		; Inhalt Control/Status Data C
DEV1_P1_C_0D	EQU	01H		; Inhalt Control/Status Data C

DEV1_P1_D_0E	EQU	08H		; Inhalt Control/Status Data D
DEV1_P1_D_0F	EQU	01H		; Inhalt Control/Status Data D	

	;****** Page 1 Control Data Device 2 (Druecke)
	; jeweils 8-bit Auflsung, 5,1 V max.

DEV2_P1_C_0C	EQU	08H		; Inhalt Control/Status Data C
DEV2_P1_C_0D	EQU	01H		; Inhalt Control/Status Data C

DEV2_P1_D_0E	EQU	08H		; Inhalt Control/Status Data D
DEV2_P1_D_0F	EQU	01H		; Inhalt Control/Status Data D

	;****** Page 3 Factory Setup

DEVX_PAGE3_1C	EQU	40H		; Adr. 1Ch set to 40h if VCC powered

	;****** Device 1 ID (64 bit address)

DEV1_ID_0	EQU	20H		; LSB Family Code
DEV1_ID_1	EQU	0A1H		; *
DEV1_ID_2	EQU	05H		; *
DEV1_ID_3	EQU	02H		; *
DEV1_ID_4	EQU	00H		; * 48 bit serial number
DEV1_ID_5	EQU	00H		; *
DEV1_ID_6	EQU	00H		; *
DEV1_ID_7	EQU	51H		; CRC

	;****** Device 2 ID (64 bit address)

DEV2_ID_0	EQU	20H		; LSB Family Code
DEV2_ID_1	EQU	3AH		; *
DEV2_ID_2	EQU	27H		; *
DEV2_ID_3	EQU	02H		; *
DEV2_ID_4	EQU	00H		; * 48 bit serial number
DEV2_ID_5	EQU	00H		; *
DEV2_ID_6	EQU	00H		; *
DEV2_ID_7	EQU	63H		; CRC

	;****** Definitionen fuer CAN- Controller ****************************

CAN_ALE	BIT	p3.4			; ALE / AS
CAN_CS	BIT	p3.5			; CS/
CAN_RD	BIT	p3.6			; RD/E
CAN_WR	BIT	p3.7			; WR/

CAN_ADR_CR	EQU	00H		; Adresse Control Register (CR) 
CAN_ADR_CMR	EQU	01H		; Adresse Command Register (CMR)
CAN_ADR_SR	EQU	02H		; Adresse Status Register (SR)
CAN_ADR_IR	EQU	03H		; Adresse Interrupt Register (IR)
CAN_ADR_ACR	EQU	04H		; Adresse Acceptance Code (ACR)
CAN_ADR_AMR	EQU	05H		; Adresse Acceptance Mask (AMR)
CAN_ADR_BTR0	EQU	06H		; Adresse Bus Timing Reg 0 (BTR0)
CAN_ADR_BTR1	EQU	07H		; Adresse Bus Timing Reg 1 (BTR1)
CAN_ADR_OCR	EQU	08H		; Adresse Output Control (OCR)

CAN_ADR_I1_TX	EQU	0AH		; Adresse Ident High Byte (send)
CAN_ADR_I2_TX	EQU	0BH		; Adresse Ident Low Byte (send)
CAN_ADR_D0_TX	EQU	0CH		; Basisadresse 8 Datenbytes (send)
CAN_ADR_D1_TX	EQU	0DH		; Datenbyte (send)
CAN_ADR_D2_TX	EQU	0EH		; Datenbyte (send)
CAN_ADR_D3_TX	EQU	0FH		; Datenbyte (send)
CAN_ADR_D4_TX	EQU	10H		; Datenbyte (send)
CAN_ADR_D5_TX	EQU	11H		; Datenbyte (send)
CAN_ADR_D6_TX	EQU	12H		; Datenbyte (send)
CAN_ADR_D7_TX	EQU	13H		; Datenbyte (send)

CAN_ADR_I1_RX	EQU	14H		; Adresse Ident High Byte (receive)
CAN_ADR_I2_RX	EQU	15H		; Adresse Ident Low Byte (receive)
CAN_ADR_D0_RX	EQU	16H		; Basisadresse 8 Datenbytes (receive)
CAN_ADR_D1_RX	EQU	17H		; Datenbyte (receive)
CAN_ADR_D2_RX	EQU	18H		; Datenbyte (receive)
CAN_ADR_D3_RX	EQU	19H		; Datenbyte (receive)
CAN_ADR_D4_RX	EQU	1AH		; Datenbyte (receive)
CAN_ADR_D5_RX	EQU	1BH		; Datenbyte (receive)
CAN_ADR_D6_RX	EQU	1CH		; Datenbyte (receive)
CAN_ADR_D7_RX	EQU	1DH		; Datenbyte (receive)

CAN_ADR_CDR	EQU	1FH		; Adresse Clock Divider Register (CDR)

CAN_INI_CR	EQU	21H		; Initwert CAN Controllregister
CAN_INI_CMR	EQU	08H		; Initwert CAN Commandregister
CAN_INI_BTR0	EQU	80H		; Initwert CAN Bus Timing Register 0
CAN_INI_BTR1	EQU	49H		; Initwert CAN Bus Timing Register 1
CAN_INI_ACR	EQU	00H		; Initwert CAN Acceptance Code
CAN_INI_AMR	EQU	0FFH		; Initwert CAN Acceptance Mask
CAN_INI_OCR	EQU	0FAH		; Initwert CAN Output Control Register
CAN_INI_CDR	EQU	40H		; Initwert CAN Clock Divider Register	

CAN_CR_OPMODE	EQU	0FEH	; UND     Reset-Mode aufheben und in OP-Mode
					; umschalten nach der Initialisierung
					; durch loeschen von Bit 0
;CAN_CR_INTEN	EQU	1AH	; ODER	; schaltet RX, Error und Overrun frei
					; Bit 1: RX- Interrupt
					; Bit 2: TX- Interrupt
					; Bit 3: Error Interrupt
					; Bit 4: Overrun Interrupt
CAN_CMR_TXREQ	EQU	01H	; ODER	  Transmit-Request setzen um Botschaft
					; abzusenden
CAN_CMR_RXREL	EQU	04H	; ODER	  Release Receive Buffer- Bit setzen

	; Zuordnung CAN- Mailboxen zu den Botschaftsnummern

; BOX 0 ist fuer undefinierte Kennungen vorgesehen (default)

CAN_BOX_1_H	EQU	05H	; Box 1 = Botschaft 500H (STATUS 1 HSTG)
CAN_BOX_1_L	EQU	00H	

CAN_BOX_2_H	EQU	05H	; Box 2 = Botschaft 502H (Applikationsdaten)
CAN_BOX_2_L	EQU	02H	

CAN_BOX_3_H	EQU	05H	; Box 3 = Botschaft 503H (Heizung HSTG Data)
CAN_BOX_3_L	EQU	03H	

CAN_BOX_4_H	EQU	05H	; Box 4 = Botschaft 505H (Kommandos)
CAN_BOX_4_L	EQU	05H	
	
; Rx Routinen Aufruf-Timeout

CAN_RX_CALL_TO	EQU	10H	; Maximale Anzahl CAN-Buffer auslesen	

	;****** Definitionen fuer digital Inputs *****************************

DIG_SH		BIT	p1.0		; digital I/O, Shift/Load Schiebereg.
DIG_CLK		BIT	p1.1		; digital I/O, Schiebetakt
DIG_QH6		BIT	p1.2		; digital I/O, Eingang von IC6
DIG_DS		BIT	p1.3		; digital I/O, DS vom Ausgabe- SR

	;****** Definitionen fuer digital Outputs ****************************
	; ueber Schieberegister fuer Maskierung OUT_SHIFT
	
OUT_HEIZRELAIS_SET 	EQU	01H	; ODER	  Heizung einschalten
OUT_HEIZRELAIS_CLR 	EQU	0FEH	; UND	  Heizung ausschalten

OUT_OELLUEFT_SET 	EQU	08H	; ODER	  Luefter einschalten
OUT_OELLUEFT_CLR 	EQU	0F7H	; UND	  Luefter ausschalten

	;****** Definitionen fuer Standheizungstask **************************

;HZG_ALL_OFF	EQU	00H	; Heizung alle Quellen aus
HZG_MENU_ON	EQU	01H	; eingeschaltet ueber Menue
HZG_UHR_ON	EQU	02H	; eingeschaltet ueber Uhr
HZG_WAECO_ON	EQU	04H	; eingeschaltet ueber WAECO

	;****** Definitionen fuer Oelkuehlerzusatzlueftertask ****************

TEMP_LUEFT_AUS	EQU	5FH	; Ausschalttemperatur-Kennlinienwert ( 95C)
TEMP_LUEFT_EIN	EQU	64H	; Einschalttemperatur-Kennlinienwert (100C)

	;****** Definitionen fuer SPI ****************************************

SPI_SS		BIT	p1.4		; SPI, SS/
MOSI		BIT	p1.5		; SPI, MOSI (Dateneingang)
MISO		BIT	p1.6		; SPI, MISO (Datenausgang)
SPI_CLK		BIT	p1.7		; SPI, serial clock

	;****** Definitionen fuer Powerdown **********************************

POWERDOWN_MSTG	EQU	01H		; Powerdown Anforderung MSTG,
					; CAN stoppen

	;****** Definitionen LED, allgemein **********************************

LED_R		BIT	p2.6		; Leuchtdiode rot (LED an = LOW)
LED_G		BIT	p2.7		; Leuchtdiode gn (LED an=LOW)

HIGH_MASK	EQU	00001111b	; High nibble wegmaskieren

ASCII_ADDZ	EQU	30H		; addieren bei Zahlen
ASCII_ADDB	EQU	37H		; addieren bei Buchstaben
ASCII_COMP	EQU	09H		; Vergleichswert Zahl / Buchstabe

	;****** Definitionen Stackinitialisierung ****************************

STACK_INIT_VALUE	EQU	88H		; Initwert fuer Stackbereich
STACK_END_VALUE		EQU	55H		; Endemarkierung fuer Ueber-
						; wachung des Stackendes

	;****** Definitionen FehlerCodeworte *********************************

EW_STACK_OVERFLOW	EQU	07H	; Stack Overflow, Endemarkierung 
					; wurde ueberschrieben
EW_CAN_INI_MODE1	EQU	10H	; kein Reset-Mode des SJA1000
					; am Anfang von can_ini
EW_CAN_INI_MODE2	EQU	11H	; kein Operation-Mode des SJA1000
					; am Ende von can_ini
EW_CAN_TXBUF_NOT_REL	EQU	12H	; TX-Buffer not released am Ende von
					; Botschaftssendevorgang

;EW_INT_CANBUS_OFF	EQU	30H	; Interrupt vom CAN-Controller weil
					; CAN bus-off
;EW_INT_CANERROR	EQU	31H	; Interrupt vom CAN-Controller weil
					; allgemeiner Fehler
;EW_INT_CAN_UNKNOWN	EQU	32H	; Interrupt vom CAN-Controller aber
					; Flags nicht sinnvoll
;EW_INT_CAN_OVERFLOW	EQU	33H	; Interrupt vom CAN-Controller weil
					; berlauf, d.h. Datenverlust weil
					; nicht rechtzeitig abgeholt und 
					; daher ueberschrieben
;EW_INT_CAN_RX_WRONG	EQU	34H	; Der RX-Interrupt kam und der
					; Receive-Buffer-Status sagt "leer"


EW_CAN_IDENT		EQU	35H	; unbekannter Identifier angekommen
EW_CAN_RX_OVERLOAD	EQU	36H	; CAN-RX Routine kommt nicht mehr nach
					; (zuviele Empfangsbotschaften)


EW_IIC_NOT_READY	EQU	50H	; SCL und/oder SDA nicht high
					; IIC-Startbedingung nicht erfuellt
EW_IIC_BYTESEND_ACK	EQU	51H	; IIC-Bus-Fehler 
					; Kein Acknowledge nach ByteSend
							
EW_STOP			EQU	0FFH	; auf Programmende STOP aufgelaufen	

	;****** Definitionen Timeoutzeiten ***********************************

TO_CAN_INI_MODE1	EQU	0FFH	; kein Reset-Mode des SJA1000 
					; am Anfang von can_ini
TO_CAN_INI_MODE2	EQU	0FFH	; kein Operation-Mode des SJA1000 
					; am Ende von can_ini
TO_CAN_TXBUF_NOT_REL	EQU	0FFH	; TX-Buffer not released am Ende von
					; Botschaftssendevorgang

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

