;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 16.09.2000
;		
;	13_05_01: Bug beseitigt in UP "hex_dez_ascii": Fehler bei TEMP_H == 0
;	09_09_02: hex-dez-ascii fuer ADC umgebaut
;
;*****************************************************************************

        ;*********************************************************************
	; Umwandlung eines HEX- Wertes in zwei am LCD- Modul darstellbare
	; ASCII- Zeichen; Wertuebergabe (hierher) in Akku A
	; Rueckgabe in ASCII_L (low nibble) und ASCII_H (high nibble)
 
hex_in_ascii:

	push	ACC			; sichern fuer LOW- Nibble

	swap	A			; high nibble bearbeiten
	anl	A,#HIGH_MASK		; obere Bits loeschen
	mov	MERK,A			; sichern weil kaputt bei dec

	jz	zahl1			; Null zuerst aussortieren

	mov	CNT0,#ASCII_COMP	; Schleife 9 mal
vergl1:	dec	A
	jz	zahl1			; wenn nach 9 dec noch nicht Null:
					; dann ist es ein Buchstabe
	djnz	CNT0,vergl1

buch1:	mov	A,MERK
	add	A,#ASCII_ADDB		; A-F in ASCII A bis F umwandeln
	;mov	ASCII_H,A
	jmp 	lownib	

zahl1:	mov	A,MERK					
	add	A,#ASCII_ADDZ		; 1-9 in ASCII 1 bis 9 umwandeln
	;mov	ASCII_H,A
	;jmp	lownib

lownib:	mov	ASCII_H,A		; Ergebnis von oben ablegen
	pop	ACC			; Gesamtwert wieder holen
	anl	A,#HIGH_MASK		; obere Bits loeschen
	mov	MERK,A			; sichern weil kaputt bei dec

	jz	zahl2			; Null zuerst aussortieren

	mov	CNT0,#ASCII_COMP	; Schleife 9 mal
vergl2:	dec	A
	jz	zahl2			; wenn nach 9 dec noch nicht Null:
					; dann ist es ein Buchstabe
	djnz	CNT0,vergl2

buch2:	mov	A,MERK
	add	A,#ASCII_ADDB		; A-F in ASCII A bis F umwandeln
	;mov	ASCII_L,A
	jmp 	ascii_end	

zahl2:	mov	A,MERK					
	add	A,#ASCII_ADDZ		; 1-9 in ASCII 1 bis 9 umwandeln
	;mov	ASCII_L,A
	;jmp	ascii_end

ascii_end:
	mov	ASCII_L,A
	ret

        ;*********************************************************************
	; Umwandlung eines HEX- Wertes vom ADC in einen
	; Dezimalwert und Konvertierung in ASCII- Zeichen.
	; Eingangswert in ADC_DEZ_E.
	; Ergebnis in ADC_DEZ_H (Hunderterstelle in ASCII)
	; und in ADC_DEZ_Z (Zehnerstelle in ASCII)
	; sowie ADC_DEZ_E (Einerstelle in ASCII) 
	; negative Werte werden in positive gewandelt (Zweierkomplement)
	; bei negativen Werten wird Bit00 gesetzt zurckgegeben (Merker "-")
 
hex_dez_ascii:

	;****** zuerst auf Null pruefen
	
	mov	A,#0
	clr	Bit00			; Merker fuer "negativ" loeschen
	mov	ADC_DEZ_H,A		; loeschen Ergebnis Hunderterstelle
	mov	ADC_DEZ_Z,A		; loeschen Ergebnis Zehnerstelle
	mov	A,ADC_DEZ_E
	jz	end_dez_vorher		; nicht durch Null teilen !
	jmp	find_neg

	; vor dem beenden statt der Nullen die ASCII- Nullen eintragen:

end_dez_vorher:
	add	A,#ASCII_ADDZ		; 1-9 in ASCII 1 bis 9 umwandeln
	mov	ADC_DEZ_H,A
	mov	ADC_DEZ_Z,A
	mov	ADC_DEZ_E,A
	jmp	end_dez

	;****** negative Werte erkennen, evtl. Bit00 setzen

find_neg:
	push	ACC			; Wert sichern
	rlc	A
	jnc	pos1			; MSB war "0" --> positiv
negat:	pop	ACC			; gesicherten Wert zurueckholen
	setb	Bit00			; Merker fuer "negativ" setzen

	;****** Zweierkomplement berechnen (invertieren / +1)
	
	cpl	A			; alle Bits invertieren
	inc	A			; Akku +1;
	jmp	pos2 

	;****** HEX --> DEZ --> ASCII

pos1:	pop	ACC			; gesicherten Wert zurckholen
		
pos2:	mov	B,#100			; zuerst durch hundert teilen
	div	AB			; Ergebnis: A = ganze Hunderter
					;           B = Rest
	add	A,#ASCII_ADDZ		; 1-9 in ASCII 1 bis 9 umwandeln
	mov	ADC_DEZ_H,A

	mov	A,B			; Rest in A weiterbearbeiten
	mov	B,#10			; duch zehn teilen
	div	AB			; Ergebnis: A = ganze Zehner
					;           B = Rest
	add	A,#ASCII_ADDZ		; 1-9 in ASCII 1 bis 9 umwandeln
	mov	ADC_DEZ_Z,A
	
	mov	A,B
	add	A,#ASCII_ADDZ		; 1-9 in ASCII 1 bis 9 umwandeln
	mov	ADC_DEZ_E,A

end_dez:
	ret

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************


