;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 16.09.2000		
;
;	Aenderungen:
;	24_10_00: Routinen fuer Mailboxen eingebunden
; 	22_04_01: weitere Mailboxen eingebunden
;	20_07_02: rx_Routine mit Rckgabewert in Akku
;	25_07_02: bugfix: changed from Transmit Status Polling to 
;		  Transmit Complete Status Polling (Tx-routine)
;	03_10_02: Bei BIT04==1 nicht mehr CAN-TX / Powerdownvorbereitung
;
;*****************************************************************************

        ;*********************************************************************
        ; Unterprogramm fuer Initialisierung CAN-Controller
        ;*********************************************************************

ini_can_basic:
	
	IF NO_CAN

	ret			; 1= Betrieb ohne physikalischen CAN
			        ;    erzeugt keine Fehlermeldungen

	ENDIF

	; zuerst pruefen, ob der Controller im Reset-Mode ist, denn nur dann
	; koennen die folgenden Register geschrieben werden

	mov	CAN_ADR,#CAN_ADR_CR	; CR-Register ruecklesen
	mov	R4,#00H			; setzen fuer Timeouterkennung
iniloop:
	call	can_read
	mov	A,CAN_DAT
	rrc	A			; Bit 0 abfragen ueber Carry

	jc	inigoon			; gesetzt = im Reset Mode	
	inc	R4
	cjne	R4,#TO_CAN_INI_MODE1,iniloop	
					; wenn gesetzt dann immer
					; noch nicht im Reset- Mode
	mov	ERROR,#EW_CAN_INI_MODE1
	call	errorcode_out		; Fehlermeldung generieren

inigoon:
	; CDR, ACR, AMR, BTR0, BTR1, OCR initialisieren
			
	mov	CAN_ADR,#CAN_ADR_CDR	; Clock Divider init
	mov	CAN_DAT,#CAN_INI_CDR	; (clock out, bypass, CAN-Mode)
	call	can_write

	mov	CAN_ADR,#CAN_ADR_CR	; Control Register init
	mov	CAN_DAT,#CAN_INI_CR	; (Interrupts vorerst sperren)
	call	can_write

	mov	CAN_ADR,#CAN_ADR_ACR	; Acceptance Code init
	mov	CAN_DAT,#CAN_INI_ACR	
	call	can_write
	mov	CAN_ADR,#CAN_ADR_AMR	; Acceptance Mask init
	mov	CAN_DAT,#CAN_INI_AMR	
	call	can_write

	mov	CAN_ADR,#CAN_ADR_BTR0	; BTR0 Register init
	mov	CAN_DAT,#CAN_INI_BTR0	
	call	can_write
	mov	CAN_ADR,#CAN_ADR_BTR1	; BTR1 Register init
	mov	CAN_DAT,#CAN_INI_BTR1	
	call	can_write

	mov	CAN_ADR,#CAN_ADR_OCR	; Output Control Register init
	mov	CAN_DAT,#CAN_INI_OCR	
	call	can_write

	mov	CAN_ADR,#CAN_ADR_CMR	; Command Register init
	mov	CAN_DAT,#CAN_INI_CMR	
	call	can_write

	; im Control Register das ResetModeBit loeschen
	; und damit den Controller in den OperationMode schalten,
	; danach Wechsel pruefen
iniloop2:
	mov	CAN_ADR,#CAN_ADR_CR		; CR lesen und 
	call	can_read			; Bit 0 loeschen, das
	mov	A,CAN_DAT			; schaltet von ResetMode
	anl	A,#CAN_CR_OPMODE		; in OperationMode
	mov	CAN_DAT,A
	call	can_write
	nop
 	nop
	mov	CAN_ADR,#CAN_ADR_CR	; CR-Register ruecklesen
	mov	R4,#00H			; setzen fuer Timeouterkennung
	call	can_read
	mov	A,CAN_DAT
	rrc	A			; Bit 0 abfragen ueber Carry
	jnc	inigoon2		; geloescht = im OperationMode	
	inc	R4
	cjne	R4,#TO_CAN_INI_MODE2,iniloop2	
					; wenn gesetzt dann immer
					; noch im Reset- Mode
	mov	ERROR,#EW_CAN_INI_MODE2
	call	errorcode_out		; Fehlermeldung generieren

inigoon2:

	ret

        ;*********************************************************************
        ; Unterprogramm fuer CAN-Controller: READ BYTE FROM SJA1000-BUS
        ;*********************************************************************

can_read:
	; erwarteter Grundzustand: 	ALE=low und RD/ WR/ CS/=high
	;				A/D- Bus (Port 0) = OUTPUT
	; Uebergabewerte:		Adresse in CAN_ADR
	;				erhaltene Daten in CAN_DAT

	IF NO_CAN

	mov	CAN_DAT,#00H	; 1= Betrieb ohne physikalischen CAN
	ret		        ;    erzeugt keine Fehlermeldungen

	ENDIF
	
	setb	CAN_ALE			; ALE vorbereitend nach HIGH
	nop
	nop
	mov	P0,CAN_ADR		; Adresse auf AD-Bus legen
	nop
	nop
	nop
	nop
	nop
	clr	CAN_ALE			; fallende Flanke ALE
	nop
	nop
	mov	P0,#0FFH		; Port 0 = INPUT
	nop				; ACHTUNG ! Umschalten dauert lange !
	nop
	nop
	nop
	nop
	clr	CAN_CS			; CS/ aktivieren fuer CAN Controller
	nop
	nop
	clr	CAN_RD			; RD/ aktivieren
	nop				; Daten liegen nach max 50 ns an
	nop
	nop
	nop
	mov	CAN_DAT,P0		; Daten uebernehmen
	nop
	nop
	nop
	nop
	setb	CAN_RD			; jetzt ausgegebene Daten wieder float
	setb	CAN_CS
	nop
	nop
	mov	P0,#00H			; Port 0 = OUTPUT (Grundzustand)
	nop
	
	; zurueck mit eingelesenen Daten in CAN_DAT	

	ret
        
	;*********************************************************************
        ; Unterprogramm fuer CAN-Controller: WRITE BYTE TO SJA1000-BUS
        ;*********************************************************************

can_write:
	; erwarteter Grundzustand: 	ALE=low und RD/ WR/ CS/=high
	;				A/D- Bus (Port 0) = OUTPUT
	; Uebergabewerte:		Adresse in CAN_ADR
	;				Daten (bzw. Befehl) in CAN_DAT

	IF NO_CAN

	ret			; 1= Betrieb ohne physikalischen CAN
			        ;    erzeugt keine Fehlermeldungen

	ENDIF

	setb	CAN_ALE			; ALE vorbereitend nach HIGH
	nop
	nop
	mov	P0,CAN_ADR		; Adresse auf AD-Bus legen
	nop
	nop
	nop
	nop
	nop
	clr	CAN_ALE			; fallende Flanke ALE
	nop
	nop
	clr	CAN_CS			; CS/ aktivieren fuer CAN Controller
	nop
	nop
	clr	CAN_WR			; WR/ aktivieren
	nop
	mov	P0,CAN_DAT		; Daten auf AD-Bus legen
	nop
	nop
	nop
	nop
	nop
	nop
	setb	CAN_WR
	nop
	nop
	setb	CAN_CS
	nop

	ret
 
        ;*********************************************************************
        ; Unterprogramm fuer CAN: Uebertrage komplette Botschaft an SJA1000
        ;*********************************************************************

can_tx:	; erwarteter Grundzustand: die abzuschickende Botschaft befindet sich
	; im CAN-Buffer dieses Controllers (CAN_I1,CAN_I2,CAN_D0, ..., CAN_D7)
	
	
	; bei Powerdown- Vorankuendigung CAN einstellen
	
	jb	BIT04,txend


	mov 	CAN_ADR,#CAN_ADR_I1_TX		; Adr. Identifier1 in TX
	mov	CAN_DAT,CAN_I1
	call	can_write

	mov 	CAN_ADR,#CAN_ADR_I2_TX		; Adr. Identifier2 in TX
	mov	CAN_DAT,CAN_I2
	call	can_write

	mov 	CAN_ADR,#CAN_ADR_D0_TX		; Adr. Datenbyte 0 in TX
	mov	CAN_DAT,CAN_D0
	call	can_write

	inc 	CAN_ADR				; Adr. Datenbyte 1 in TX
	mov	CAN_DAT,CAN_D1
	call	can_write

	inc 	CAN_ADR				; Adr. Datenbyte 2 in TX
	mov	CAN_DAT,CAN_D2
	call	can_write

	inc 	CAN_ADR				; Adr. Datenbyte 3 in TX
	mov	CAN_DAT,CAN_D3
	call	can_write

	inc 	CAN_ADR				; Adr. Datenbyte 4 in TX
	mov	CAN_DAT,CAN_D4
	call	can_write

	inc 	CAN_ADR				; Adr. Datenbyte 5 in TX
	mov	CAN_DAT,CAN_D5
	call	can_write

	inc 	CAN_ADR				; Adr. Datenbyte 6 in TX
	mov	CAN_DAT,CAN_D6
	call	can_write

	inc 	CAN_ADR				; Adr. Datenbyte 7 in TX
	mov	CAN_DAT,CAN_D7
	call	can_write

	; Transmit Request setzen im Command Register

	mov	CAN_ADR,#CAN_ADR_CMR		; CMR lesen und 
;	call	can_read			; "Transmit Request" Bit
;	mov	A,CAN_DAT			; setzen
;	orl	A,#CAN_CMR_TXREQ
;	mov	CAN_DAT,A
	mov	CAN_DAT,#09H

	call	can_write

	; Transmit Buffer Status abfragen bevor's weitergeht
	; soll wieder frei sein bevor Routine beendet wird

	mov	CAN_ADR,#CAN_ADR_SR
	mov	R4,#00H				; setzen fuer Timeout
	
txloop:	call	can_read			; Ergebnis in CAN_DAT
	mov	A,CAN_DAT
;--- urspruengliche Loesung ---
;	rlc	A				; Bit 5 = Transmit Status Bit
;	rlc	A
;	rlc	A				; Bit 5 jetzt in Carry
	;;;; TEST ;;;;
	;clr	c				; 1 = is transmitting
	;;;;;;;;;;;;;;				; 0 = idle
;	jnc	txend
;------------------------------
	rrc	A				; Bit 3 = Transmit COMPLETE Status
	rrc	A
	rrc	A
	rrc	A				; Bit 3 jetzt in Carry
	;;;; TEST ;;;;
	;clr	c
	;;;;;;;;;;;;;;
	jc	txend				; 1 = complete
						; 0 = not yet completed

	inc	R4
	cjne	R4,#TO_CAN_TXBUF_NOT_REL,txloop ; wenn gesetzt dann Botschaft
						; noch nicht gesendet -->
						; warten
	mov	ERROR,#EW_CAN_TXBUF_NOT_REL
	call	errorcode_out

txend:	nop

	ret

        ;*********************************************************************
        ; Unterprogramm fuer CAN: 
	; Empfange komplette Botschaft von SJA1000 und uebertrage sie in 
	; die Mailbox die dieser Botschaft zugeordnet ist.
        ;*********************************************************************

can_rx:	; Diese Routine prft zunchst, ob eine Botschaft im RX-Buffer ist.
	; Falls nicht, wird sie sofort beendet.
	; Rckgabewert im Akku: * nichts ist im Puffer gewesen: 0x00H
	;			* Puffer war voll und wurde bearbeitet: 0x01H

	; Receive Buffer Status abfragen bevor's weitergeht

	mov	CAN_ADR,#CAN_ADR_SR
	call	can_read			; Ergebnis in CAN_DAT
	mov	A,CAN_DAT
	rrc	A			; Bit 0 = Receive Buffer Status Bit
					; 0=leer, 1=voll

	jnc	rxend_uml		; keine neue Botschaft, daher beenden
	jmp	somethingisthere

rxend_uml:
	mov	A,#00H			; Rckgabewert (s.o.) laden
	jmp	rxend			; keine neue Botschaft, daher beenden

somethingisthere:
	; es ist eine neue Botschaft vorhanden
	; zuerst Header lesen, Mailbox finden, Daten uebertragen

	mov	CAN_ADR,#CAN_ADR_I1_RX
	call	can_read			; lesen Identifier 1 (RX)
	mov	CAN_SORT_ID1,CAN_DAT		

	mov	CAN_ADR,#CAN_ADR_I2_RX
	call	can_read			; lesen Identifier 2 (RX)
	mov	CAN_SORT_ID2,CAN_DAT		

	call	can_ident_extract	; Botschaftsnummer aus ID herausholen
					; Quelldaten und Ergebnis in 
					; CAN_SORT_ID1 (high) bzw. ...2 (low)

	; Vergleich der Nummern, Mailbox zuordnen

	; BOX 0: Botschaft mit unbekannter Kennung
	; BOX 1: Botschaft CAN_BOX_1_H und CAN_BOX_1_L (z.B. 615H)
	; BOX 2: Botschaft CAN_BOX_2_H und CAN_BOX_2_L (z.B. 555H)
	; BOX 3: Botschaft CAN_BOX_3_H und CAN_BOX_3_L (z.B. 556H)
	; BOX 4: Botschaft CAN_BOX_4_H und CAN_BOX_4_L (z.B. 557H)

vgl_1:	mov	A,CAN_SORT_ID1			; high byte vergleichen
	cjne	A,#CAN_BOX_1_H,vgl_2
	mov	A,CAN_SORT_ID2			; low byte vergleichen
	cjne	A,#CAN_BOX_1_L,vgl_2
	mov	R0,#BOX1_C			; es passt fuer Box 1
						; R0 mit Basisadresse laden
	jmp	auspack

vgl_2:	mov	A,CAN_SORT_ID1			; high byte vergleichen
	cjne	A,#CAN_BOX_2_H,vgl_3
	mov	A,CAN_SORT_ID2			; low byte vergleichen
	cjne	A,#CAN_BOX_2_L,vgl_3
	mov	R0,#BOX2_C			; es passt fuer Box 2
						; R0 mit Basisadresse laden
	jmp	auspack

vgl_3:	mov	A,CAN_SORT_ID1			; high byte vergleichen
	cjne	A,#CAN_BOX_3_H,vgl_4
	mov	A,CAN_SORT_ID2			; low byte vergleichen
	cjne	A,#CAN_BOX_3_L,vgl_4
	mov	R0,#BOX3_C			; es passt fuer Box 3
						; R0 mit Basisadresse laden
	jmp	auspack

vgl_4:	mov	A,CAN_SORT_ID1			; high byte vergleichen
	cjne	A,#CAN_BOX_4_H,vgl_0
	mov	A,CAN_SORT_ID2			; low byte vergleichen
	cjne	A,#CAN_BOX_4_L,vgl_0
	mov	R0,#BOX4_C			; es passt fuer Box 4
						; R0 mit Basisadresse laden
	jmp	auspack

	; --- hier weitere Mailboxen einfuegen ---

vgl_0:	mov	R0,#BOX0_C		; R0 mit Basisadresse laden
;	jmp	auspack			; Box 0 = default fuer andere 
					; Botschaften
auspack:
	call	mailbox

rx_rel_end:

	; im Command Register "Release Receive Buffer" setzen
	; (loescht gleichzeitig auch RI-Flag)

	mov	CAN_ADR,#CAN_ADR_CMR		; CMR lesen und 
	call	can_read			; "Release RX-Buffer" Bit
	mov	A,CAN_DAT			; setzen
	orl	A,#CAN_CMR_RXREL
	mov	CAN_DAT,A
	call	can_write

	mov	A,#01H			; Rckgabewert (s.o.) laden

rxend:	nop
	ret

        ;*********************************************************************
        ; Unterprogramm fuer CAN: 
	; Identifier zerlegen und Botschaftsnummer herausholen
        ;*********************************************************************
	; Eingangswerte: Identifier wie vom CAN- Controller in den Merkern
	;                "CAN_SORT_ID1" und "CAN_SORT_ID2"
	; Ausgangswerte: Nummer der Botschaft in HEX, aufgeteilt auf die
	;		 beiden Bytes "CAN_SORT_ID1" und "CAN_SORT_ID2"
	; Hinweis: ID1 liegt zuerst im Rx-Buffer, enthaelt die MSBs der 
	;          fertigen Kennung, ID 2 enthaelt die 3 LSBs und anderes
	;	   Beim Ergebnis ist ID1 ebenfalls das HighByte, ID2 LowByte

	; - Von beiden bytes Sicherungskopien erstellen
	; - 3 MSBs aus ID1 ganz nach rechts schieben, andere Bits loeschen
	;   Dies ist das fertige High-Byte der Kennung
	; - 5 MSBs fuer Low-Byte herausholen durch 3 mal rechtschieben,
	;   andere bits loeschen un d Ergebnis zwischenspeichern
	; - Kopie "CAN_SORT_MERK2" nehmen und die 3 LSBs erzeugen,
	;   am Ende mit anderen 5 Bits verodern

can_ident_extract:
	mov	CAN_SORT_MERKID1,CAN_SORT_ID1	; ID1 sichern
	mov	CAN_SORT_MERKID2,CAN_SORT_ID2	; ID2 sichern
	mov	A,CAN_SORT_ID1			; ID1 verschieben
	rrc	A
	rrc	A
	rrc	A
	rrc	A
	rrc	A
	anl	A,#07H			; 5 MSBs auf Null setzen	
	mov	CAN_SORT_ID1,A		; fertiges HighByte der Kennung

	mov	A,CAN_SORT_MERKID1	; 5 MSBs fuer Low-Byte herausholen
	rlc	A
	rlc	A
	rlc	A
	anl	A,#0F8H			; drei LSBs loeschen vor Veroderung
	mov	CAN_SORT_ID2,A		; 5 MSBs des lowByte sichern

	mov	A,CAN_SORT_MERKID2	; low Byte verschieben
	rrc	A
	rrc	A
	rrc	A
	rrc	A
	rrc	A			; 3 Bits nach unten schieben
	anl	A,#07H			; 5 restliche Bits loeschen
	orl	A,CAN_SORT_ID2		; verodern der 5 MSBs und 3 LSBs
	mov	CAN_SORT_ID2,A		; fertiges Low-Byte der Kennung

	ret

        ;*********************************************************************
        ; Unterprogramm: CAN Botschaft in Mailbox uebertragen
        ;*********************************************************************

mailbox:
	mov	@R0,#01H		; setzen des Update- Flags (LSB) 
	inc	R0			; im Box-Control-Register
	mov	@R0,CAN_SORT_ID1	; Nummer ablegen, high byte [HEX]
	inc	R0
	mov	@R0,CAN_SORT_ID2	; Nummer ablegen, low byte [HEX]
	inc	R0
	mov	CAN_ADR,#CAN_ADR_D0_RX
	call	can_read			; lesen Datenbyte 0 (RX)
	mov	@R0,CAN_DAT			; im CAN_Buffer ablegen
	inc	R0

	mov	CAN_ADR,#CAN_ADR_D1_RX
	call	can_read			; lesen Datenbyte 1 (RX)
	mov	@R0,CAN_DAT			; im CAN_Buffer ablegen
	inc	R0

	mov	CAN_ADR,#CAN_ADR_D2_RX
	call	can_read			; lesen Datenbyte 2 (RX)
	mov	@R0,CAN_DAT			; im CAN_Buffer ablegen
	inc	R0

	mov	CAN_ADR,#CAN_ADR_D3_RX
	call	can_read			; lesen Datenbyte 3 (RX)
	mov	@R0,CAN_DAT			; im CAN_Buffer ablegen
	inc	R0

	mov	CAN_ADR,#CAN_ADR_D4_RX
	call	can_read			; lesen Datenbyte 4 (RX)
	mov	@R0,CAN_DAT			; im CAN_Buffer ablegen
	inc	R0

	mov	CAN_ADR,#CAN_ADR_D5_RX
	call	can_read			; lesen Datenbyte 5 (RX)
	mov	@R0,CAN_DAT			; im CAN_Buffer ablegen
	inc	R0

	mov	CAN_ADR,#CAN_ADR_D6_RX
	call	can_read			; lesen Datenbyte 6 (RX)
	mov	@R0,CAN_DAT			; im CAN_Buffer ablegen
	inc	R0

	mov	CAN_ADR,#CAN_ADR_D7_RX
	call	can_read			; lesen Datenbyte 7 (RX)
	mov	@R0,CAN_DAT			; im CAN_Buffer ablegen

	ret	

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************


