;*****************************************************************************
; 	All rights reserved by Dipl.-Ing (FH) Andreas Hoeger
;	Ditzenbrunner Str. 64, 71254 Ditzingen, Germany
;	Telefon: (+497156)490980	Telefax: (+497156)490981
;	E-Mail: ingbuero@andreas-hoeger.de
;*****************************************************************************
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;
;       Projekt: MSTG	 		Version Software: V0.05
;					Version Hardware: V1.00
;       
;       Autor: Andreas Hoeger		Build:300503
;
;       --> zustzlich aendern: 
;	Softwareversion bei den LCD- Ausgabetexten (am Fileende)
;
;	Timing ausgelegt fuer Systemtakt mit 16 MHz Quarz
;
;	Aenderungen:
;	02_05_02: Initial version (=ZSTG V003)
;	04_05_02: CAN_RX vervielfacht fuer mehrere Mailboxen
;	20_07_02: CAN Rx Routine mit dynamischer Aufrufanzahl
;	20_08_02: Inbetriebnahme; Identifier 519h geaendert, DCF77 Wartezeit
;		  entfernt, ERROR- Ausgabe in Statusbotschaft, Schieberegister 
;		  Ansteuerung eingebaut
;	25_08_02: Stack-Initialisierung und Overflowerkennung eingebaut
;	26_08_02: 1-wire Erstversion eingebunden
;	09_09_02: ADC ASCII-Werte ausgeben auf CAN 513h eingefuegt
;	10_09_02: Ladelufttemperatur Kennlinienfeld eingefuegt
;	11_09_02: Oeltemperatur Kennlinienfeld eingefuegt
;	24_09_02: Heizungseinschaltalgo geaendert
;	01_11_02: Bugfix: ERROR war nicht initialisiert
;	22_12_02: Bugfix: BIT04 wurde nicht zurueckgesetzt
;	05_02_03: Kennlinienfeld Ladedruck eingefuegt
;	16_05_03: Zusatzoelkuehler- Ansteuerung eingefuegt
;	21_05_03: Zusatzoelkuehler- Schaltpunktvergleich eingefuegt
;	30_05_03: Bugfix Oelkuehlerluefter- Auswertung
;			
;*****************************************************************************

        $MOD51                	; use 8051 predefined symbols
        $SYMBOLS               	; append symbol table to listing

	;****** Compilerschalter *********************************************

NO_CAN		EQU	0	; 1= Betrieb ohne physikalischen CAN,
			        ;    erzeugt keine Fehlermeldungen
				; 0= CAN-Bus angeschlossen mit Gegenstelle,
				;    CAN-Ausfall erzeugt Fehlermeldung

ERROR_STOP	EQU	1	; 1= Fehlermeldung ausgeben, LED blinken
				;    und in diesem Zustand bleiben
				; 0= Fehlermeldung kurz ausgeben und dann
				;    fortfahren

;*****************************************************************************
;	Einbinden der Speicher- Segmentierung und Konstantendefinitionen	
;*****************************************************************************

	$INCLUDE (dseg_equ.asm)	; enthlt die ORG, DS und EQU- Anweisungen

;*****************************************************************************
        
        CSEG

        ;*********************************************************************
        ; Interrupt- Vectortabelle
        ;*********************************************************************

        ORG     0000h				;power on / reset vector
        jmp     on_reset

	ORG	0003h				;external interrupt 0 vector
	reti

        ORG     000Bh                           ;timer 0 overflow vector
	jmp	irq_t0
        
	ORG     0013h                           ;external interrupt 1 vector
	reti

        ORG     001Bh                           ;timer 1 overflow vector
	reti

        org     0023h                           ;serial I/O interrupt vector
	reti                          

        ORG     002Bh                           ;timer 2 overflow vector
	reti

	ORG	0033h				;?? reserved ??
	reti

        ;*********************************************************************
        ; Beginn Anwendungs- Programmcode
        ;*********************************************************************
        
        ORG     0100H

on_reset:  

	;****** min. 500 ms Wartezeit wegen Errata-Sheet AT89S53 *************
	;****** ISP sonst ab dem zweiten mal blockiert ***********************

	call	sek_1

	;****** System-Initialisierung ***************************************

	mov     IE,#00H			; Interrupts nicht freigeben

	mov     SP,#STACK		; Stackpointer auf Stackbereich 
					; setzen

        mov     BITS,#00H		; Merkerbits loeschen

	setb	BIT05			; Merker fuer "Initphase"
					; 1 = in Init, 0 = Init vorbei
					; wird spaeter geloescht

	call	ini_system		; erst aufrufen, wenn der Stack 
					; aufgesetzt ist !

	;****** Initialisierung Stack ****************************************

	mov	CNT0,#20H		; Stacklaenge 20H
	mov	R0,#STACK		; indirect adressing
initstack:
	mov	@R0,#STACK_INIT_VALUE		
	inc	R0
	djnz	CNT0,initstack

	mov	STACK_END_MARK,#STACK_END_VALUE	; Endemarkierung fuer 
						; Stackoverflow Erkennung

	;****** Initialisierung fuer Benutzung Timer 0 Interrupt *************

	mov	TMOD,#00H		; Timer 0 im Mode 0 benutzt
	mov	IP,#00H			; Interrupt-Prio not used

	mov	TL0,#00H		; Timer Register loeschen
	mov	TH0,#00H		; Timer Register loeschen

	;*********************************************************************

	mov	IE,#82H			; Interrupt Timer 0 Overflow enable
					; und global Interrupt enable

	mov	TCON,#10H		; Timer 0 --> ON

	;****** Initialisierung zyklischer Ablauf ****************************

	mov     LOOPCNT,#00H		; Zaehler initialisieren fuer 
	mov	TASK_BITS,#00H		; zyklischen Ablauf

	mov	MSTG_ALIVE,#00H		; Alive-Zaehler fuer PartnerSGCheck
	mov	MSTG_BITS,#00H		; Einzelbits zur Infouebertragung

	mov	OUT_SHIFT,#00H		; Initwert fuer Schieberegister-
					; ausgabe (IC16)

	;****** Initialisierung CAN-Ausgabe-Variable ****************************

	mov     HZG_COMMAND,#00H	; fuer Ausgabe Lueftungsansteuerung
					; an HSTG
	mov	HZG_ONOFF_CNT,#00H	; Counter fuer Heizung- Quellen
					; Schaltvorgaenge 

	;****** Initialisierung Messvariablen ********************************

	mov     LLK_DRUCK,#00H		; Ladedruck 
	mov	LLK_TEMP,#00H		; Ladelufttemperatur
	mov	OEL_DRUCK,#00H		; Oeldruck
	mov	OEL_TEMP,#00H		; Oeltemperatur

	;****** Initialisierung 1-wire bus (ADC) *****************************

	call	ONEWIRE_INIT		; setup ADCs

	;****** System Init - Netzwerkmanagement *****************************

	; hier evtl. Code einfuegen

	;****** zyklischen Ablauf vorbereiten ********************************

	mov	ERROR,#00H

	;*********************************************************************
	;****** Beginn zyklischer Ablauf - Taskschema ************************
	;*********************************************************************

	clr	BIT05			; Merker fuer "Init-Phase" loeschen
					; da Init jetzt vorbei und alle 
					; Fehlermeldungen anzeigbar sind
start_loop:

	cpl	LED_G			; "zappelt noch"- Anzeige 
					; zur Messung Zykluszeit verwendbar

	call	zehn_ms
	call	zehn_ms
	call	zehn_ms
	call	zehn_ms	
	call	zehn_ms

	;****** NOTSTOP fuer Fehlerausgabe abfragen

notstop:
	jnb	BITS.7,notstop_end	; dieses Bit wurde bei Fehlermeldung
					; gesetzt. Dort kann aber nicht 
					; gestoppt werden da erst noch die
	IF ERROR_STOP			; LCD- Ausgabe drankommen muss

	jmp	blinkledstop		; verzweige in die
					; Endlosschleife mit Blink- LED
	ELSE

	call	sek_3			; lange genug anzeigen
	call	sek_3			; und weitermachen

	ENDIF

notstop_end:

	;****** Taskzaehler erhoehen

	inc	MSTG_ALIVE		; Zaehler fuer Partnersteuergeraete-
					; Ueberwachung auf HSTG

	inc	LOOPCNT			; Zaehler fuer Schleifendurchlaufe
					; erhoehen; bei 17 auf 1 zurcksetzen

	mov	TASK_BITS,#00H		; default: zunaechst kein Task aktiv

	;****** Taskmaske berechnen	
	;****** Tasks koennen in jedem zweiten, vierten, achten oder sechzehnten
	;****** Durchlauf aktiviert werden

	mov	A,#11H	
	cjne	A,LOOPCNT,no_overflow
overflow:
	mov	LOOPCNT,#01
no_overflow:
	mov	A,#02
	cjne	A,LOOPCNT,check04
	jmp	set2			
check04:mov	A,#04
	cjne	A,LOOPCNT,check06
	jmp	set24	
check06:mov	A,#06
	cjne	A,LOOPCNT,check08
	jmp	set2	
check08:mov	A,#08
	cjne	A,LOOPCNT,check10
	jmp	set248	
check10:mov	A,#0AH
	cjne	A,LOOPCNT,check12
	jmp	set2	
check12:mov	A,#0CH
	cjne	A,LOOPCNT,check14
	jmp	set24	
check14:mov	A,#0EH
	cjne	A,LOOPCNT,check16
	jmp	set2	
check16:mov	A,#10H
	cjne	A,LOOPCNT,checkend
	jmp	set24816	
checkend:jmp	task_calc_end		; no active task

set2:	mov	TASK_BITS,#01H
	jmp	task_calc_end
set24:	mov	TASK_BITS,#03H
	jmp	task_calc_end
set248: mov	TASK_BITS,#07H
	jmp	task_calc_end
set24816: mov	TASK_BITS,#0FH

task_calc_end:

task_shiftregs:

	call	io_shift		; liest Schieberegister ein, 
					; Ergebnis in
					; IN_OPTO (invertiert)

					; gibt OUT_SHIFT zerstoerungsfrei
					; an Ausgangsschiebregister

; Ausgaberelais:	; Bit 0 (LSB): Relais 04: Webasto Standheizung
; OUT_SHIFT		; Bit 1      : Relais 03: Heiz-Lueftanschluss Webasto
			; Bit 2      : Relais 02: Vorgluehschaltung wg. Heizg.
			; Bit 3	     : Relais 01: Zusatzoelkuehler-Luefter
			; Bit 4      : ---
			; Bit 5	     : ---
			; Bit 6	     : ---
			; Bit 7	(MSB): ---

task_shiftregs_end:

task_optokopp:
	;****** Task "Optokoppler Signale auswerten"

; Optokoppler (inv.)	; Bit 0 (LSB): Stecker 01: Lueftung von Webasto
; IN_OPTO		; Bit 1      : Stecker 03: Klemme W erfassen 
			; Bit 2	     : Stecker 05: Kaltstartzug
			; Bit 3	     : Stecker 07: Spritzwasser hinten
			; Bit 4	     : Stecker 09: Oelstand
			; Bit 5	     : Stecker 11: 
			; Bit 6	     : Stecker 13: --- nicht bestueckt
			; Bit 7 (MSB): Stecker 15: --- nicht bestueckt

	; AM OPTOKOPPLER SIND ALLE SIGNALE INVERTIERT !!!

	;****** Webasto meint: Lueftung einschalten
opto_bit0:
	mov	A,IN_OPTO
	rrc	A
	jc	bit0_isOff
bit0_isSet:
	call	lueftung_hzg_ein		; Lueftung fuer Webasto 
	jmp	task_optokopp_end		; schalten
bit0_isOff:
	call	lueftung_hzg_aus

task_optokopp_end:


task_ADC:
	;*****	ADC routines (1-wire bus)

	jnb	TASK_BITS.3,task_ADC_end	;!! wie CAN- Ausgabe
						; der Messdaten !!

	;call	READ_DEVICE_ID	; read ONE device ID an put result on CAN
				; only for busses with one device !!
				; --> nur fuer Erstinbetriebnahme

	call   	ADC_TEMP	; convert and put data in variables for CAN

	call	ADC_DRUCK	; convert and put data in variables for CAN

	call	ADC_FIELDCONVERT ; Kennlinienfeld- Umrechnung und
				 ; Rueckspeicherung in Ursprungsvariable
				 ;	- LLK_TEMP
				 ;	- OEL_TEMP
				 ;	- LLK_DRUCK
				 ;	(- OEL_DRUCK)

task_ADC_end:


task_oelkuehllueft:

	;****** Task "Luefter am Zusatzoelkuehler ein- und ausschalten"
	;****** Abhngig von gemessener (umgewandelter) Oeltemperatur OEL_TEMP
	;****** Einschaltschwelle: Oeltemperatur >= 100 C
        ;       dies entspricht einem OEL_TEMP Wert von 64hex (oder groesser)
	;****** Ausschaltschwelle: Oeltemperatur <=  95 C
	;	dies entspricht einem OEL_TEMP Wert von 5Fhex (oder kleiner)

	mov	A,OEL_TEMP		; in A kopieren fuer Berechnung
	jz	luefterOFF		; Gert kalt (<45C) bei Wert 0

	mov	CNT0,#TEMP_LUEFT_AUS	; entspricht 95C

checkcold:
	dec	A
	jz	luefterOFF		; Wert war < Vergleichswert
					; Temperatur unter 95C
	djnz	CNT0,checkcold	
					; Wert war > Vergleichswert
					; Temperatur also ueber 95C
checkhotstart:

	mov	A,OEL_TEMP		; Wert neu laden
	mov	CNT0,#TEMP_LUEFT_EIN	; entspricht 100C

checkhot:
	dec	A
	jz	luefterOFF		; Wert war < Vergleichswert
					; Temperatur also zwischen 95C und <100
	djnz	CNT0,checkhot	
					; Wert war > Vergleichswert
					; Temperatur ueber 100C
luefterON:
	call	oellueft_ein
	jmp	task_oelkuehllueftend

luefterOFF:
	call	oellueft_aus
	;jmp	task_oelkuehllueftend

task_oelkuehllueftend:


task_temp:	
	;****** Task "Temperatur messen"

	jb	TASK_BITS.1,temp_einlesen

task_temp_end_uml:

	jmp	task_temp_end

temp_einlesen:

	;****** Temperatur einlesen

	mov	I2C_ADR_H,#00H		
	mov	I2C_ADR_L,#DS_READ_TEMP	; Command: read temperature
	mov	I2C_ID,#DS_ID	

	call	read_ds_random_2byte	; Ergebnis in TEMP_H und TEMP_L
	
temp_restlich:

	;**** Ausgabe Temperatur auf CAN

	;mov	CAN_D1,TEMP_H		; in Sendepuffer schreiben
	;mov	CAN_D2,TEMP_L
	
task_temp_end:


task_cantx_1:

	;****** Task "CAN Grund-Botschaften senden"

	; in jedem Zyklus ausfuehren

	;**** zyklische CAN- Botschaftsausgabe 510 (Status 1 MSTG)

	mov	CAN_I1,#0A2H		; Botschaft definieren
	mov	CAN_I2,#08H		; 510h senden

	mov	CAN_D0,MSTG_ALIVE	; MSTG_ALIVE_Counter
	mov	CAN_D1,LOOPCNT		; Zykluszaehler
	mov	CAN_D2,TEMP_H		; TEMP_H
	mov	CAN_D3,TEMP_L		; TEMP_L
	mov	CAN_D4,MSTG_BITS	; Einzelbits fuer INFO		
	mov	CAN_D5,TASK_BITS	; TASK_Bits		
	mov	CAN_D6,#00H
	mov	CAN_D7,ERROR		; MSTG-Fehler
					
	call	can_tx

	; ERROR wieder zuruecksetzen damit keine Fehlermeldungs-
	; Dauerausgabe entsteht, sonst lassen sich die Steuergeraete 
	; nur noch exakt gleichzeitig einschalten 

	mov	ERROR,#00H

	;**** zyklische CAN- Botschaftsausgabe 511 (Standheizung MSTG Data)

hzg_mstg_out:

	mov	CAN_I1,#0A2H		; Botschaft definieren
	mov	CAN_I2,#28H		; 511h senden

	mov	CAN_D0,HZG_COMMAND	; Restliche Botschaft einfuegen
	mov	CAN_D1,#0FFH		; Restliche Botschaft einfuegen
	mov	CAN_D2,#0FFH		; Restliche Botschaft einfuegen
	mov	CAN_D3,#0FFH		; Restliche Botschaft einfuegen
	mov	CAN_D4,#0FFH		; Restliche Botschaft einfuegen
	mov	CAN_D5,#0FFH		; Restliche Botschaft einfuegen
	mov	CAN_D6,#0FFH		; Restliche Botschaft einfuegen
	mov	CAN_D7,#0FFH		; Restliche Botschaft einfuegen

	call	can_tx

task_cantx_1_end:

task_cantx_2:

	;****** Task "CAN Sensordaten und Debugging-Botschaften senden"

	jnb	TASK_BITS.3,task_cantx_2_end

	;**** zyklische CAN- Botschaftsausgabe 512 (MSTG Sensor HEX-Daten)
	;     --> Daten sind bereits nach Kennlinienfeld gewandelt

	mov	CAN_I1,#0A2H		; Botschaft definieren
	mov	CAN_I2,#48H		; 512h senden

	mov	CAN_D0,LLK_H2O_TEMP	; Wassertemperatur LLK
	mov	CAN_D1,MOTOR_H2O_TEMP	; Motor Kuehlwassertemperatur	
	mov	CAN_D2,LLK_TEMP		; Ladelufttemperatur		
	mov	CAN_D3,OEL_TEMP		; Oeltemperatur	
	mov	CAN_D4,OEL_DRUCK	; Oeldruck
	mov	CAN_D5,LLK_DRUCK	; Ladedruck
	mov	CAN_D6,#00H
	mov	CAN_D7,#00H
					
	call	can_tx

	;**** zyklische CAN- Botschaftsausgabe 513 (MSTG Sensor ASCII-Daten)

	mov	CAN_I1,#0A2H		; Botschaft definieren
	mov	CAN_I2,#68H		; 513h senden

	;**** 
	mov	ADC_DEZ_E,LLK_TEMP	; Ladelufttemperatur in ASCII 
	call	hex_dez_ascii		; umwandeln
	mov	CAN_D0,ADC_DEZ_Z	; Zehner LLK_TEMP
	mov	CAN_D1,ADC_DEZ_E	; Einer  LLK_TEMP
					; Hunderter verwerfen	
	;****
	mov	ADC_DEZ_E,OEL_TEMP	; Oeltemperatur in ASCII
	call	hex_dez_ascii		; umwandeln
	mov	CAN_D2,ADC_DEZ_H	; Hunderter OEL_TEMP
	mov	CAN_D3,ADC_DEZ_Z	; Zehner    OEL_TEMP
	mov	CAN_D4,ADC_DEZ_E	; Einer     OEL_TEMP	
	;****
	mov	ADC_DEZ_E,LLK_DRUCK	; Ladedruck in ASCII
	call	hex_dez_ascii		; umwandeln
	mov	CAN_D5,ADC_DEZ_H	; Vorkommastelle LLK_DRUCK
	mov	CAN_D6,ADC_DEZ_Z	; Zehntel	 LLK_DRUCK
	mov	CAN_D7,ADC_DEZ_E	; Hundertstel	 LLK_DRUCK
					
	call	can_tx

	;**** zyklische CAN- Botschaftsausgabe 519 (Debugging Botschaft)

	mov	CAN_I1,#0A3H		; Botschaft definieren
	mov	CAN_I2,#28H		; 519h senden

	mov	CAN_D0,BITS		; 
	mov	CAN_D1,IN_OPTO		; Daten von den Optokopplern 
	mov	CAN_D2,OUT_SHIFT	; Schieberegister- Ausgabedaten
	mov	CAN_D3,#00H		;
	mov	CAN_D4,#0DEH		; 
	mov	CAN_D5,#0BAH		;
	mov	CAN_D6,#0CCH		;
	mov	CAN_D7,#00H		;
					
	call	can_tx

task_cantx_2_end:

task_canrx:
	;****** Task "CAN_Botschaften empfangen"
	;****** und Inhalte in Mailboxen verteilen

	jnb	TASK_BITS.2,task_canrx_end

	mov	CAN_RX_CNT,#CAN_RX_CALL_TO	; maximale Anzahl

rx_again:	
	call	can_rx    	; pruefen ob Botschaft im Empfangspuffer
				; des SJA1000 ist; ggf. Identifier lesen 
				; und Botschaft in Mailbox uebertragen

	; Rckgabewerte in Akku: 0 = war nix
	;			 1 = Botschaft war da

	jnz	enter_rx_again

	jmp	task_canrx_end	; Rx Buffer is empty, go on

enter_rx_again:
	djnz	CAN_RX_CNT,rx_again 
	
	; number of calls too high (counter == zero)	

	mov	ERROR,#EW_CAN_RX_OVERLOAD
	call	errorcode_out		; Fehlermeldung generieren

task_canrx_end:

task_standheizung:

	;****** Task "Standheizung Anforderungen auswerten"
	;****** Pruefen ob Heizung eingeschaltet werden
	;       muss weil HSTG es anfordert ueber CAN
	;       Botschaft 503h in Mailbox 3 auswerten;
	;       Byte 0: Bit 0,1,2 sind die verschiedenen Quellen
	; 		jeweils Bit 0=aus, 1=ein
	; 		Bit 0 = Menue
	; 		Bit 1 = Schaltuhr
	; 		Bit 2 = WAECO

	jnb	TASK_BITS.2,task_standheizung_end	; wie CAN_RX !!

	;****** Mailbox 3, Botschaft 503 (Standheizung HSTG) abfragen

	; die soeben eingelesene CAN_Botschaft in BOX 3 auswerten

	; BOX3_C: 	CAN Mailbox 3	Controlbyte
	; BOX3_IH: 	CAN High Byte Botschaftsnumer [HEX]
	; BOX3_IL: 	CAN Low Byte Botschaftsnumer [HEX]
	; BOX3_0:	CAN Botschaft Mailbox --> Nutzdaten Heizung

	mov	R0,#BOX3_C		; indirect adressing
	inc	R0			; Basisadresse Mailbox 3
	inc	R0
	inc	R0			; zeigt auf Byte 0

	mov	ACC,@R0		; hole byte 0 in Akku
	
	cjne	A,#HZG_UHR_ON,hzg_testwaeco
	jmp	heizung_ein
hzg_testwaeco:
	cjne	A,#HZG_WAECO_ON,hzg_testmenu
	jmp	heizung_ein
hzg_testmenu:
	cjne	A,#HZG_MENU_ON,heizung_aus
	;jmp	heizung_ein
heizung_ein:

	call	heizrelais_ein		; Maskierung auf "OUT_SHIFT"
	jmp	task_standheizung_end

heizung_aus:

	call	heizrelais_aus


task_standheizung_end:

task_powerdown:

	;****** Task "Powerdown MSTG auswerten"
	;****** Pruefen ob MSTG CAN eingestellt werden
	;       muss weil HSTG es anfordert ueber CAN
	;       weil demnaechst der Strom ausfaellt

	;       Botschaft 505h in Mailbox 4 auswerten;
	;       Byte 0: Bit 0; 1=stoppen, 0=kein Powerdown

	jnb	TASK_BITS.2,task_powerdown_end	; wie CAN_RX !!

	;****** Mailbox 4, Botschaft 505 (Kommandos von HSTG)

	; die soeben eingelesene CAN_Botschaft in BOX 4 auswerten

	; BOX4_C: 	CAN Mailbox 4	Controlbyte
	; BOX4_IH: 	CAN High Byte Botschaftsnumer [HEX]
	; BOX4_IL: 	CAN Low Byte Botschaftsnumer [HEX]
	; BOX4_0:	CAN Botschaft Mailbox --> Nutzdaten

	mov	R0,#BOX4_C		; indirect adressing
	inc	R0			; Basisadresse Mailbox 4
	inc	R0
	inc	R0			; zeigt auf Byte 0

	mov	ACC,@R0		; hole byte 0 in Akku
	
	cjne	A,#POWERDOWN_MSTG,no_powerdown	
				; 00H = kein Powerdown
				; 01H = POWERDOWN_MSTG
CANstop:
	setb	BIT04		; Bit 04 hier ebenfalls Powerdown
				; wie bei HSTG
	
				; --> BIT04 wird in CAN-Routine zur 
				; Abschaltung verwendet

	jmp	task_powerdown_end
no_powerdown:
	clr	BIT04
task_powerdown_end:


task_stack_overflo:

	;****** Pruefen Stack- Endemarkierung (Init-Wert 55h) noch da ist

	mov	A,#55h
	cjne	A,STACK_END_MARK,stack_error
	jmp	task_stack_overflow_end
stack_error:	
	mov	ERROR,#EW_STACK_OVERFLOW
	call	errorcode_out		; Fehlermeldung generieren

task_stack_overflow_end:


end_loop:
	jmp	start_loop		; zum Anfang der zyklischen 
					; Abarbeitung zurueckspringen

	;****** Blink- LED als NOT-STOP ************************************** 
	; kann nicht mit normaler Fehlerausgabe gemacht werden da 
	; ausserhalb der Main-Routine

blinkstopend:	
	mov	CNT0,#0FFH		; Pulsdauer FF/FF = 150 ms
stop0:	nop				; Pulsdauer C0/FF = 115 ms
	mov	CNT1,#0FFH		; Pulsdauer 90/FF =  80 ms
stop1:	nop				; Pulsdauer 60/FF =  55 ms
	djnz	CNT1,stop1		; Pulsdauer 33/FF =  30 ms
	djnz	CNT0,stop0		; Pulsdauer 11/FF =  10 ms
					; Pulsdauer 10/1A =   1 ms
	cpl	LED_R
	jmp	blinkstopend		; LED toggeln

;*****************************************************************************
;	Einbinden der Unterprogramme / Treiber im Anschluss an den Main-Code	
;*****************************************************************************

	$INCLUDE (sys_ini.asm)	; Systeminitialisierung
	$INCLUDE (basiccan.asm)	; Treiber fuer Basic CAN
	$INCLUDE (convert.asm)	; Unterprogramme zur Datenumwandlung
	$INCLUDE (ds1621.asm)	; Unterprogramme fuer Temperaturmessbaustein
	$INCLUDE (ee_iic.asm)	; Treiber fuer IIC- Bus, noetig fuer EEPROM
	$INCLUDE (timeloop.asm)	; Zeitschleifen
	$INCLUDE (errorman.asm)	; Fehlermanagement
	$INCLUDE (1_wire.asm)	; Dallas 1-wire Bus Treiber fuer ADC
	$INCLUDE (mstg_irq.asm)	; Interruptroutinen MSTG
	$INCLUDE (shift.asm)	; Schieberegister-Treiber
	$INCLUDE (switch.asm)	; Schaltvorgaenge auf Relais / CAN Botschaften

;*****************************************************************************

        ;*********************************************************************
        ; Datensatzdefinitionen
        ;*********************************************************************
	; Texte enthalten 20 Zeichen und zustzlich die Endemarke
	; analog zu den LCD-Ausgabetexten des Master- Moduls

        ORG     1800H           

	;****** Lesbarer Text fuer HEX- Code *********************************

Kennung_Line_01: DB	'MSTG Software V0.05 ',16
Kennung_Line_02: DB     'Build 300503        ',16

Kennung_Line_03: DB	'Andreas Hoeger 05/03',16
Kennung_Line_04: DB	'C 2003 BY ANDI      ',16

Kennung_Line_05: DB     'MSTG Hardware V1.0  ',16


	ORG	2000H
	;****** Kennlinienfeld Ladelufttemperatur ****************************
LT_00:  DB            87h  ;  135        0   0
        DB            81h  ;  129        1   1
        DB            7Ch  ;  124        2   2
        DB            77h  ;  119        3   3
        DB            72h  ;  114        4   4
        DB            6Dh  ;  110        5   5
        DB            69h  ;  106        6   6
        DB            65h  ;  102        7   7
        DB            61h  ;   98        8   8
        DB            5Eh  ;   94        9   9
        DB            5Bh  ;   91       10   A
        DB            58h  ;   88       11   B
        DB            55h  ;   85       12   C
        DB            52h  ;   82       13   D
        DB            4Fh  ;   80       14   E
        DB            4Dh  ;   78       15   F
        DB            4Bh  ;   75       16  10
        DB            49h  ;   73       17  11
        DB            47h  ;   71       18  12
        DB            45h  ;   69       19  13
        DB            43h  ;   68       20  14
        DB            42h  ;   66       21  15
        DB            40h  ;   65       22  16
        DB            3Fh  ;   63       23  17
        DB            3Dh  ;   62       24  18
        DB            3Ch  ;   61       25  19
        DB            3Bh  ;   59       26  1A
        DB            3Ah  ;   58       27  1B
        DB            39h  ;   57       28  1C
        DB            38h  ;   56       29  1D
        DB            37h  ;   55       30  1E
        DB            36h  ;   54       31  1F
        DB            35h  ;   54       32  20
        DB            34h  ;   53       33  21
        DB            33h  ;   52       34  22
        DB            33h  ;   51       35  23
        DB            32h  ;   50       36  24
        DB            31h  ;   50       37  25
        DB            30h  ;   49       38  26
        DB            30h  ;   48       39  27
        DB            2Fh  ;   47       40  28
        DB            2Eh  ;   47       41  29
        DB            2Dh  ;   46       42  2A
        DB            2Dh  ;   45       43  2B
        DB            2Ch  ;   45       44  2C
        DB            2Bh  ;   44       45  2D
        DB            2Bh  ;   43       46  2E
        DB            2Ah  ;   43       47  2F
        DB            29h  ;   42       48  30
        DB            29h  ;   41       49  31
        DB            28h  ;   41       50  32
        DB            27h  ;   40       51  33
        DB            27h  ;   39       52  34
        DB            26h  ;   39       53  35
        DB            26h  ;   38       54  36
        DB            25h  ;   38       55  37
        DB            24h  ;   37       56  38
        DB            24h  ;   36       57  39
        DB            23h  ;   36       58  3A
        DB            23h  ;   35       59  3B
        DB            22h  ;   35       60  3C
        DB            22h  ;   35       61  3D
        DB            22h  ;   34       62  3E
        DB            22h  ;        34  63  3F
        DB            21h  ;        34  64  40
        DB            21h  ;        33  65  41
        DB            21h  ;        33  66  42
        DB            20h  ;        33  67  43
        DB            20h  ;        32  68  44
        DB            20h  ;        32  69  45
        DB            1Fh  ;        32  70  46
        DB            1Fh  ;        31  71  47
        DB            1Fh  ;        31  72  48
        DB            1Eh  ;        31  73  49
        DB            1Eh  ;        30  74  4A
        DB            1Eh  ;        30  75  4B
        DB            1Dh  ;        30  76  4C
        DB            1Dh  ;        30  77  4D
        DB            1Dh  ;        29  78  4E
        DB            1Ch  ;        29  79  4F
        DB            1Ch  ;        29  80  50
        DB            1Ch  ;        28  81  51
        DB            1Bh  ;        28  82  52
        DB            1Bh  ;        28  83  53
        DB            1Bh  ;        27  84  54
        DB            1Ah  ;        27  85  55
        DB            1Ah  ;        27  86  56
        DB            1Ah  ;        26  87  57
        DB            1Ah  ;        26  88  58
        DB            19h  ;        26  89  59
        DB            19h  ;        25  90  5A
        DB            19h  ;        25  91  5B
        DB            18h  ;        25  92  5C
        DB            18h  ;        25  93  5D
        DB            18h  ;        24  94  5E
        DB            17h  ;        24  95  5F
        DB            17h  ;        24  96  60
        DB            17h  ;        23  97  61
        DB            17h  ;        23  98  62
        DB            16h  ;        23  99  63
        DB            16h  ;        22 100  64
        DB            16h  ;        22 101  65
        DB            15h  ;        22 102  66
        DB            15h  ;        22 103  67
        DB            15h  ;        21 104  68
        DB            14h  ;        21 105  69
        DB            14h  ;        21 106  6A
        DB            14h  ;        20 107  6B
        DB            14h  ;        20 108  6C
        DB            13h  ;        20 109  6D
        DB            13h  ;        20 110  6E
        DB            13h  ;        19 111  6F
        DB            12h  ;        19 112  70
        DB            12h  ;        19 113  71
        DB            12h  ;        18 114  72
        DB            12h  ;        18 115  73
        DB            11h  ;        18 116  74
        DB            11h  ;        18 117  75
        DB            11h  ;        17 118  76
        DB            10h  ;        17 119  77
        DB            10h  ;        17 120  78
        DB            10h  ;        16 121  79
        DB            10h  ;        16 122  7A
        DB            0Fh  ;        16 123  7B
        DB            0Fh  ;        16 124  7C
        DB            0Fh  ;        15 125  7D
        DB            0Fh  ;        15 126  7E
        DB            0Eh  ;        15 127  7F
        DB            0Eh  ;        15 128  80
        DB            0Eh  ;        14 129  81
        DB            0Dh  ;        14 130  82
        DB            0Dh  ;        14 131  83
        DB            0Dh  ;        13 132  84
        DB            0Dh  ;        13 133  85
        DB            0Ch  ;        13 134  86
        DB            0Ch  ;        13 135  87
        DB            0Ch  ;        12 136  88
        DB            0Ch  ;        12 137  89
        DB            0Bh  ;        12 138  8A
        DB            0Bh  ;        12 139  8B
        DB            0Bh  ;        11 140  8C
        DB            0Bh  ;        11 141  8D
        DB            0Ah  ;        11 142  8E
        DB            0Ah  ;        11 143  8F
        DB            0Ah  ;        10 144  90
        DB            0Ah  ;        10 145  91
        DB            09h  ;        10 146  92
        DB            09h  ;        10 147  93
        DB            09h  ;         9 148  94
        DB            09h  ;         9 149  95
        DB            08h  ;         9 150  96
        DB            08h  ;         9 151  97
        DB            08h  ;         8 152  98
        DB            08h  ;         8 153  99
        DB            07h  ;         8 154  9A
        DB            07h  ;         8 155  9B
        DB            07h  ;         7 156  9C
        DB            07h  ;         7 157  9D
        DB            06h  ;         7 158  9E
        DB            06h  ;         7 159  9F
        DB            06h  ;         6 160  A0
        DB            06h  ;         6 161  A1
        DB            05h  ;         6 162  A2
        DB            05h  ;         6 163  A3
        DB            05h  ;         6 164  A4
        DB            05h  ;         5 165  A5
        DB            05h  ;         5 166  A6
        DB            04h  ;         5 167  A7
        DB            04h  ;         5 168  A8
        DB            04h  ;         4 169  A9
        DB            04h  ;         4 170  AA
        DB            03h  ;         4 171  AB
        DB            03h  ;         4 172  AC
        DB            03h  ;         3 173  AD
        DB            03h  ;         3 174  AE
        DB            03h  ;         3 175  AF
        DB            02h  ;         3 176  B0
        DB            02h  ;         3 177  B1
        DB            02h  ;         2 178  B2
        DB            02h  ;         2 179  B3
        DB            01h  ;         2 180  B4
        DB            01h  ;         2 181  B5
        DB            01h  ;         2 182  B6
        DB            01h  ;         1 183  B7
        DB            01h  ;         1 184  B8
        DB            00h  ;         1 185  B9
        DB            00h  ;         1 186  BA
        DB            00h  ;         0 187  BB
        DB            00h  ;         0 188  BC
        DB            00h  ;         0 189  BD
        DB            00h  ;         0 190  BE
        DB            00h  ;         0 191  BF
        DB            00h  ;        -1 192  C0
        DB            00h  ;        -1 193  C1
        DB            00h  ;        -1 194  C2
        DB    0FFh  ;        -1 195  C3
        DB    0FFh  ;        -1 196  C4
        DB    0FFh  ;        -2 197  C5
        DB    0FFh  ;        -2 198  C6
        DB    0FFh  ;        -2 199  C7
        DB    0FEh  ;        -2 200  C8
        DB    0FEh  ;        -2 201  C9
        DB    0FEh  ;        -3 202  CA
        DB    0FEh  ;        -3 203  CB
        DB    0FEh  ;        -3 204  CC
        DB    0FDh  ;        -3 205  CD
        DB    0FDh  ;        -3 206  CE
        DB    0FDh  ;        -3 207  CF
        DB    0FDh  ;        -4 208  D0
        DB    0FDh  ;        -4 209  D1
        DB    0FCh  ;        -4 210  D2
        DB    0FCh  ;        -4 211  D3
        DB    0FCh  ;        -4 212  D4
        DB    0FCh  ;        -5 213  D5
        DB    0FCh  ;        -5 214  D6
        DB    0FCh  ;        -5 215  D7
        DB    0FBh  ;        -5 216  D8
        DB    0FBh  ;        -5 217  D9
        DB    0FBh  ;        -6 218  DA
        DB    0FBh  ;        -6 219  DB
        DB    0FBh  ;        -6 220  DC
        DB    0FAh  ;        -6 221  DD
        DB    0FAh  ;        -6 222  DE
        DB    0FAh  ;        -6 223  DF
        DB    0FAh  ;        -7 224  E0
        DB    0FAh  ;        -7 225  E1
        DB    0FAh  ;        -7 226  E2
        DB    0F9h  ;        -7 227  E3
        DB    0F9h  ;        -7 228  E4
        DB    0F9h  ;        -7 229  E5
        DB    0F9h  ;        -8 230  E6
        DB    0F9h  ;        -8 231  E7
        DB    0F9h  ;        -8 232  E8
        DB    0F8h  ;        -8 233  E9
        DB    0F8h  ;        -8 234  EA
        DB    0F8h  ;        -8 235  EB
        DB    0F8h  ;        -9 236  EC
        DB    0F8h  ;        -9 237  ED
        DB    0F8h  ;        -9 238  EE
        DB    0F8h  ;        -9 239  EF
        DB    0F7h  ;        -9 240  F0
        DB    0F7h  ;        -9 241  F1
        DB    0F7h  ;        -9 242  F2
        DB    0F7h  ;       -10 243  F3
        DB    0F7h  ;       -10 244  F4
        DB    0F7h  ;       -10 245  F5
        DB    0F6h  ;       -10 246  F6
        DB    0F6h  ;       -10 247  F7
        DB    0F6h  ;       -10 248  F8
        DB    0F6h  ;       -11 249  F9
        DB    0F6h  ;       -11 250  FA
        DB    0F6h  ;       -11 251  FB
        DB    0F6h  ;       -11 252  FC
        DB    0F5h  ;       -11 253  FD
        DB    0F5h  ;       -11 254  FE
        DB    0F5h  ;       -11 255  FF

	ORG	2100H
	;****** Kennlinienfeld Ladedruck *************************************
LD_00:    DB                   0          ;                                	            00                                     0
          DB                   0          ;                                                 11                                     0
          DB                   0          ;                                                 22                                     0
          DB                   0          ;                                                 33                                     0
          DB                   0          ;                                                 44                                     0
          DB                   0          ;                                                 55                                     0
          DB                   0          ;                                                 66                                     0
          DB                   0          ;                                                 77                                     0
          DB                   0          ;                                                 88                                     0
          DB                   0          ;                                                 99                                     0
          DB                   0          ;                                                10A                                     0
          DB                   0          ;                                                11B                                     0
          DB                   0          ;                                                12C                                     0
          DB                   0          ;                                                13D                                     0
          DB                   0          ;                                                14E                                     0
          DB                   0          ;                                                15F                                     0
          DB                   0          ;                                                1610                                    0
          DB                   0          ;                                                1711                                    0
          DB                   0          ;                                                1812                                    0
          DB                   0          ;                                                1913                                    0
          DB                   0          ;                                                2014                                    0
          DB                   0          ;                                                2115                                    0
          DB                   0          ;                                                2216                                    0
          DB                   0          ;                                                2317                                    0
          DB                   0          ;                                                2418                                    0
          DB                   0          ;                                                2519                                    0
          DB                   0          ;                                                261A                                    0
          DB                   0          ;                                                271B                                    0
          DB                   0          ;                                                281C                                    0
          DB                   0          ;                                                291D                                    0
          DB                   0          ;                                                301E                                    0
          DB                   0          ;                                                311F                                    0
          DB                   0          ;                                                3220                                    0
          DB                   0          ;                                                3321                                    0
          DB                   0          ;                                                3422                                    0
          DB                   0          ;                                                3523                                    0
          DB                   0          ;                                                3624                                    0
          DB                   0          ;                                                3725                                    0
          DB                   0          ;                                                3826                                    0
          DB                   0          ;                                                3927                                    0
          DB                   0          ;                                                4028                                    0
          DB                   0          ;                                                4129                                    0
          DB                   0          ;                                                  2A                                    0
          DB                   0          ;                                                  2B                                    0
          DB                   0          ;                                                  2C                                    0
          DB                   0          ;         0        0          10        0,9090909092D                     0                          0,00
          DB                   0          ;                                                  2E
          DB                   0          ;                                                  2F
          DB                   0          ;         10,0078125 10,68779778        0,96558048830                     0                          0,01
          DB                   0          ;                                                  31
          DB                   0          ;                                                  32
          DB                   1          ;         2 0,015625 11,37618599        1,02141996433                     1                          0,02
          DB                   1          ;                                                  34
          DB                   2          ;         30,0234375 12,06515689        1,07661981935                     2                          0,02
          DB                   2          ;                                                  36
          DB                   2          ;                                                  37
          DB                   3          ;         4  0,03125 12,75470276        1,13119031438                     3                          0,03
          DB                   3          ;                                                  39
          DB                   3          ;                                                  3A
          DB                   3          ;         50,0390625 13,44481587        1,1851414953B                     3                          0,04
          DB                   4          ;                                                  3C
          DB                   4          ;         6 0,046875 14,13548851        1,2384832013D                     4                          0,05
          DB                   4          ;                                                  3E
          DB                   5          ;                                                  3F
          DB                   5          ;         70,0546875 14,82671294        1,29122506140                     5                          0,05
          DB                   5          ;                                                  41
          DB                   6          ;                                                  42
          DB                   6          ;         8   0,0625 15,51848145         1,3433765143                     6                          0,06
          DB                   6          ;                                                  44
          DB                   7          ;         90,0703125 16,21078629        1,39494678745                     7                          0,07
          DB                   7          ;                                                  46
          DB                   7          ;                                                  47
          DB                   7          ;        10 0,078125 16,90361977        1,44594494248                     7                          0,08
          DB                   8          ;                                                  49
          DB                   8          ;        110,0859375 17,59697413         1,496379844A                     8                          0,09
          DB                   8          ;                                                  4B
          DB                   9          ;                                                  4C
          DB                   9          ;        12  0,09375 18,29084167        1,5462601684D                     9                          0,09
          DB                   9          ;                                                  4E
          DB                  0Ah          ;        130,1015625 18,98521466        1,5955944374F                     A                          0,10
          DB                  0Ah          ;                                                  50
          DB                  0Ah          ;                                                  51
          DB                  0Ah          ;        14 0,109375 19,68008537        1,64439098752                     A                          0,11
          DB                  0Bh          ;                                                  53
          DB                  0Bh          ;        150,1171875 20,37544608        1,69265799254                     B                          0,12
          DB                  0Bh          ;                                                  55
          DB                  0Ch          ;                                                  56
          DB                  0Ch          ;        16    0,125 21,07128906        1,74040346257                     C                          0,13
          DB                  0Dh          ;                                                  58
          DB                  0Dh          ;        170,1328125 21,76760659        1,78763525159                     D                          0,13
          DB                  0Dh          ;                                                  5A
          DB                  0Eh          ;        18 0,140625 22,46439095        1,8343610565B                     E                          0,14
          DB                  0Eh          ;                                                  5C
          DB                  0Eh          ;                                                  5D
          DB                  0Eh          ;        190,1484375  23,1616344        1,8805884245E                     E                          0,15
          DB                  0Fh          ;                                                  5F
          DB                  0Fh          ;        20  0,15625 23,85932922        1,92632475760                     F                          0,16
          DB                  10h          ;                                                  61
          DB                  10h         ;        210,1640625  24,5574677        1,97157730962                     10                         0,16
          DB                  10h          ;                                                  63
          DB                  11h          ;        22 0,171875  25,2560421        2,01635319764                     11                         0,17
          DB                  11h          ;                                                  65
          DB                  11h          ;                                                  66
          DB                  11h          ;        230,1796875  25,9550447        2,06065940167                     11                         0,18
          DB                  12h          ;                                                  68
          DB                  12h          ;        24   0,1875 26,65446777        2,10450276669                     12                         0,19
          DB                  13h          ;                                                  6A
          DB                  13h          ;        250,1953125  27,3543036        2,1478900076B                     13                         0,20
          DB                  14h          ;                                                  6C
          DB                  14h          ;        26 0,203125 28,05454445        2,1908277116D                     14                         0,20
          DB                  14h          ;                                                  6E
          DB                  15h          ;        270,2109375  28,7551826        2,2333223426F                     15                         0,21
          DB                  15h          ;                                                  70
          DB                  15h          ;        28  0,21875 29,45621033        2,27538024371                     15                         0,22
          DB                  16h          ;                                                  72
          DB                  16h          ;        290,2265625 30,15761991        2,31700763573                     16                         0,23
          DB                  17h          ;                                                  74
          DB                  17h          ;        30 0,234375 30,85940361        2,35821062675                     17                         0,23
          DB                  18h          ;                                                  76
          DB                  18h          ;        310,2421875 31,56155372         2,3989952177                     18                         0,24
          DB                  18h          ;                                                  78
          DB                  19h          ;        32     0,25  32,2640625         2,4393672779                     19                         0,25
          DB                  19h          ;                                                  7A
          DB                  19h          ;        330,2578125 32,96692224         2,479332587B                     19                         0,26
          DB                  1Ah          ;                                                  7C
          DB                  1Ah          ;        34 0,265625  33,6701252         2,518896817D                     1A                         0,27
          DB                  1Bh          ;                                                  7E
          DB                  1Bh          ;        350,2734375 34,37366366        2,5580655267F                     1B                         0,27
          DB                  1Bh          ;                                                  80
          DB                  1Ch          ;        36  0,28125 35,07752991        2,59684419281                     1C                         0,28
          DB                  1Ch          ;                                                  82
          DB                  1Ch          ;        370,2890625  35,7817162        2,63523817583                     1C                         0,29
          DB                  1Dh          ;                                                  84
          DB                  1Dh          ;        38 0,296875 36,48621483        2,67325274485                     1D                         0,30
          DB                  1Eh          ;                                                  86
          DB                  1Eh          ;        390,3046875 37,19101806        2,71089307387                     1E                         0,30
          DB                  1Eh          ;                                                  88
          DB                  1Fh          ;        40   0,3125 37,89611816        2,74816424689                     1F                         0,31
          DB                  1Fh          ;                                                  8A
          DB                  20h          ;        410,3203125 38,60150743        2,7850712558B                     20                         0,32
          DB                  20h          ;                                                  8C
          DB                  20h          ;        42 0,328125 39,30717812        2,8216190048D                     20                         0,33
          DB                  21h          ;        430,3359375 40,01312251         2,857812318E                     21                         0,34
          DB                  21h          ;                                                  8F
          DB                  22h          ;        44  0,34375 40,71933289        2,89365590790                     22                         0,34
          DB                  22h          ;                                                  91
          DB                  23h          ;        450,3515625 41,42580152        2,92915444592                     23                         0,35
          DB                  23h          ;                                                  93
          DB                  23h          ;        46 0,359375 42,13252068        2,96431249394                     23                         0,36
          DB                  24h          ;        470,3671875 42,83948264        2,99913454295                     24                         0,37
          DB                  24h          ;                                                  96
          DB                  25h          ;        48    0,375 43,54667969        3,03362500597                     25                         0,38
          DB                  25h          ;                                                  98
          DB                  26h          ;        490,3828125 44,25410409        3,06778821899                     26                         0,38
          DB                  26h          ;                                                  9A
          DB                  27h          ;        50 0,390625 44,96174812        3,1016284449B                     27                         0,39
          DB                  27h          ;        510,3984375 45,66960406        3,1351498739C                     27                         0,40
          DB                  28h          ;                                                  9D
          DB                  28h          ;        52  0,40625 46,37766418        3,1683566239E                     28                         0,41
          DB                  29h          ;                                                  9F
          DB                  29h          ;        530,4140625 47,08592076        3,201252745A0                     29                         0,41
          DB                  2Ah          ;        54 0,421875 47,79436607        3,233842219A1                     2A                         0,42
          DB                  2Ah          ;                                                  A2
          DB                  2Ah          ;        550,4296875 48,50299239        3,266128959A3                     2A                         0,43
          DB                  2Bh          ;        56   0,4375 49,21179199        3,298116813A4                     2B                         0,44
          DB                  2Bh          ;                                                  A5
          DB                  2Ch          ;        570,4453125 49,92075715        3,329809567A6                     2C                         0,45
          DB                  2Ch          ;                                                  A7
          DB                  2Dh          ;        58 0,453125 50,62988014        3,361210943A8                     2D                         0,45
          DB                  2Eh          ;        590,4609375 51,33915324          3,3923246A9                     2E                         0,46
          DB                  2Eh         ;                                                  AA
          DB                  2Eh          ;        60  0,46875 52,04856873        3,423154138AB                     2E                         0,47
          DB                  2Fh          ;        610,4765625 52,75811887          3,4537031AC                     2F                         0,48
          DB                  2Fh          ;                                                  AD
          DB                  30h          ;        62 0,484375 53,46779594        3,483974968AE                     30                         0,48
          DB                  31h          ;        630,4921875 54,17759223        3,513973169AF                     31                         0,49
          DB                  31h          ;                                                  B0
          DB                  32h          ;        64      0,5     54,8875        3,543701073B1                     32                         0,50
          DB                  32h          ;        650,5078125 55,59751153        3,573161999B2                     32                         0,51
          DB                  33h          ;                                                  B3
          DB                  33h          ;        66 0,515625 56,30761909        3,602359208B4                     33                         0,52
          DB                  34h          ;        670,5234375 57,01781497        3,631295913B5                     34                         0,52
          DB                  35h          ;        68  0,53125 57,72809143        3,659975272B6                     35                         0,53
          DB                  35h          ;                                                  B7
          DB                  35h          ;        690,5390625 58,43844075        3,688400395B8                     35                         0,54
          DB                  36h          ;        70 0,546875 59,14885521        3,716574344B9                     36                         0,55
          DB                  36h          ;                                                  BA
          DB                  37h          ;        710,5546875 59,85932708        3,744500128BB                     37                         0,55
          DB                  38h          ;        72   0,5625 60,56984863        3,772180714BC                     38                         0,56
          DB                  39h          ;        730,5703125 61,28041215         3,79961902BD                     39                         0,57
          DB                  39h          ;                                                  BE
          DB                  39h          ;        74 0,578125  61,9910099        3,826817917BF                     39                         0,58
          DB                  3Ah          ;        750,5859375 62,70163417        3,853780233C0                     3A                         0,59
          DB                  3Ah          ;                                                  C1
          DB                  3Bh          ;        76  0,59375 63,41227722        3,880508754C2                     3B                         0,59
          DB                  3Ch          ;        770,6015625 64,12293134        3,907006219C3                     3C                         0,60
          DB                  3Ch          ;        78 0,609375 64,83358879        3,933275327C4                     3C                         0,61
          DB                  3Dh          ;        790,6171875 65,54424186        3,959318737C5                     3D                         0,62
          DB                  3Dh          ;                                                  C6
          DB                  3Eh          ;        80    0,625 66,25488281        3,985139064C7                     3E                         0,63
          DB                  3Fh          ;        810,6328125 66,96550393        4,010738886C8                     3F                         0,63
          DB                  40h          ;        82 0,640625 67,67609749        4,036120741C9                     40                         0,64
          DB                  40h          ;                                                  CA
          DB                  40h          ;        830,6484375 68,38665576        4,061287128CB                     40                         0,65
          DB                  41h          ;        84  0,65625 69,09717102        4,086240509CC                     41                         0,66
          DB                  42h          ;        850,6640625 69,80763555        4,110983309CD                     42                         0,66
          DB                  43h          ;        86 0,671875 70,51804161        4,135517916CE                     43                         0,67
          DB                  43h          ;        870,6796875 71,22838149        4,159846684CF                     43                         0,68
          DB                  44h          ;                                                  D0
          DB                  44h          ;        88   0,6875 71,93864746         4,18397193D1                     44                         0,69
          DB                  45h          ;        890,6953125  72,6488318        4,207895938D2                     45                         0,70
          DB                  46h          ;        90 0,703125 73,35892677        4,231620958D3                     46                         0,70
          DB                  47h          ;        910,7109375 74,06892467        4,255149206D4                     47                         0,71
          DB                  47h          ;        92  0,71875 74,77881775        4,278482868D5                     47                         0,72
          DB                  48h          ;                                                  D6
          DB                  48h          ;        930,7265625  75,4885983        4,301624096D7                     48                         0,73
          DB                  49h          ;        94 0,734375 76,19825859         4,32457501D8                     49                         0,73
          DB                  4Ah          ;        950,7421875  76,9077909        4,347337701D9                     4A                         0,74
          DB                  4Bh          ;        96     0,75  77,6171875        4,369914229DA                     4B                         0,75
          DB                  4Bh          ;        970,7578125 78,32644067        4,392306625DB                     4B                         0,76
          DB                  4Ch          ;        98 0,765625 79,03554268        4,414516888DC                     4C                         0,77
          DB                  4Dh          ;        990,7734375 79,74448581        4,436546993DD                     4D                         0,77
          DB                  4Eh          ;       100  0,78125 80,45326233        4,458398883DE                     4E                         0,78
          DB                  4Eh          ;                                                  DF
          DB                  4Eh          ;       1010,7890625 81,16186452        4,480074476E0                     4E                         0,79
          DB                  4Fh          ;       102 0,796875 81,87028465        4,501575659E1                     4F                         0,80
          DB                  50h          ;       1030,8046875 82,57851501        4,522904297E2                     50                         0,80
          DB                  51h          ;       104   0,8125 83,28654785        4,544062225E3                     51                         0,81
          DB                  52h          ;       1050,8203125 83,99437547        4,565051255E4                     52                         0,82
          DB                  52h          ;       106 0,828125 84,70199013        4,585873172E5                     52                         0,83
          DB                  53h          ;       1070,8359375 85,40938411        4,606529735E6                     53                         0,84
          DB                  54h          ;       108  0,84375 86,11654968        4,627022682E7                     54                         0,84
          DB                  55h          ;       1090,8515625 86,82347913        4,647353723E8                     55                         0,85
          DB                  55h          ;       110 0,859375 87,53016472        4,667524547E9                     55                         0,86
          DB                  56h          ;       1110,8671875 88,23659873        4,687536819EA                     56                         0,87
          DB                  57h          ;       112    0,875 88,94277344        4,707392181EB                     57                         0,88
          DB                  58h          ;       1130,8828125 89,64868112        4,727092252EC                     58                         0,88
          DB                  59h          ;       114 0,890625 90,35431404         4,74663863ED                     59                         0,89
          DB                  59h          ;       1150,8984375 91,05966449         4,76603289EE                     59                         0,90
          DB                  5Ah          ;       116  0,90625 91,76472473        4,785276586EF                     5A                         0,91
          DB                  5Bh          ;       1170,9140625 92,46948705        4,804371252F0                     5B                         0,91
          DB                  5Ch          ;       118 0,921875 93,17394371          4,8233184F1                     5C                         0,92
          DB                  5Ch          ;       1190,9296875   93,878087        4,842119522F2                     5C                         0,93
          DB                  5Dh          ;       120   0,9375 94,58190918        4,860776091F3                     5D                         0,94
          DB                  5Eh          ;       1210,9453125 95,28540254        4,879289558                       5E                         0,95
          DB                  5Fh          ;       122 0,953125 95,98855934        4,897661357F4                     5F                         0,95
          DB                  60h          ;       1230,9609375 96,69137187        4,915892901F5                     60                         0,96
          DB                  60h          ;       124  0,96875  97,3938324        4,933985587F6                     60                         0,97
          DB                  61h          ;       1250,9765625  98,0959332         4,95194079F7                     61                         0,98
          DB                  62h          ;       126 0,984375 98,79766655         4,96975987F8                     62                         0,98
          DB                  63h          ;       1270,9921875 99,49902472        4,987444167F9                     63                         0,99
          DB                  63h          ;       128        1       100,2        5,004995005FA                     64                         1,00
          DB                  63h         ;       1291,0078125 100,9005847        5,022413689                                                  1,01
          DB                  63h         ;       130 1,015625  101,600771        5,039701509                                                  1,02
          DB                  63h         ;       1311,0234375 102,3005512        5,056859736                                                  1,02
          DB                  63h         ;       132  1,03125 102,9999176        5,073889626                                                  1,03
                                          ; hier ist 5,1 Volt Messbereich Vollaussteuerung     

	ORG	2200H
	;****** Kennlinienfeld Oeltemperatur *********************************
OT_00:    DB     94h ;                0                  148,45
          DB     93h ;                1             147,4706348
          DB     92h ;                2             146,4988739
          DB     91h ;                3             145,5346792
          DB     90h ;                4             144,5780124
          DB     8Fh ;                5             143,6288354
          DB     8Eh ;                6             142,6871102
          DB     8Dh ;                7             141,7527985
          DB     8Ch ;                8             140,8258622
          DB     8Bh ;                9             139,9062632
          DB     8Ah ;               10             138,9939633
          DB     8Ah ;               11             138,0889244
          DB     89h ;               12             137,1911084
          DB     88h ;               13             136,3004771
          DB     87h ;               14             135,4169924
          DB     86h ;               15             134,5406161
          DB     85h ;               16             133,6713102
          DB     84h ;               17             132,8090363
          DB     83h ;               18             131,9537565
          DB     83h ;               19             131,1054326
          DB     82h ;               20             130,2640264
          DB     81h ;               21             129,4294998
          DB     80h ;               22             128,6018147
          DB     7Fh ;               23             127,7809328
          DB     7Eh ;               24             126,9668162
          DB     7Eh ;               25             126,1594266
          DB     7Dh ;               26             125,3587258
          DB     7Ch ;               27             124,5646759
          DB     7Bh ;               28             123,7772385
          DB     7Ah ;               29             122,9963756
          DB     7Ah ;               30             122,2220491
          DB     79h ;               31             121,4542208
          DB     78h ;               32             120,6928525
          DB     77h ;               33             119,9379061
          DB     77h ;               34             119,1893435
          DB     76h ;               35             118,4471265
          DB     75h ;               36              117,711217
          DB     74h ;               37             116,9815769
          DB     74h ;               38              116,258168
          DB     73h ;               39             115,5409521
          DB     72h ;               40             114,8298912
          DB     72h ;               41             114,1249471
          DB     71h ;               42             113,4260816
          DB     70h ;               43             112,7332567
          DB     70h ;               44             112,0464341
          DB     6Fh ;               45             111,3655757
          DB     6Eh ;               46             110,6906434
          DB     6Eh ;               47             110,0215991
          DB     6Dh ;               48             109,3584046
          DB     6Ch ;               49             108,7010218
          DB     6Ch ;               50             108,0494125
          DB     6Bh ;               51             107,4035386
          DB     6Ah ;               52             106,7633619
          DB     6Ah ;               53             106,1288444
          DB     69h ;               54             105,4999478
          DB     68h ;               55              104,876634
          DB     68h ;               56              104,258865
          DB     67h ;               57             103,6466025
          DB     67h ;               58             103,0398083
          DB     66h ;               59             102,4384445
          DB     65h ;               60             101,8424728
          DB     65h ;               61             101,2518551
          DB     64h ;               62             100,6665532
          DB     64h ;               63              100,086529
          DB     63h ;               64             99,51174444
          DB     62h ;               65             98,94216126
          DB     62h ;               66             98,37774138
          DB     61h ;               67             97,81844664
          DB     61h ;               68             97,26423891
          DB     60h ;               69             96,71508004
          DB     60h ;               70              96,1709319
          DB     5Fh ;               71             95,63175635
          DB     5Fh ;               72             95,09751524
          DB     5Eh ;               73             94,56817044
          DB     5Eh ;               74              94,0436838
          DB     5Dh ;               75             93,52401719
          DB     5Dh ;               76             93,00913246
          DB     5Ch ;               77             92,49899148
          DB     5Bh ;               78              91,9935561
          DB     5Bh ;               79             91,49278819
          DB     5Ah ;               80              90,9966496
          DB     5Ah ;               81              90,5051022
          DB     5Ah ;               82             90,01810783
          DB     59h ;               83             89,53562838
          DB     59h ;               84             89,05762568
          DB     58h ;               85             88,58406161
          DB     58h ;               86             88,11489802
          DB     57h ;               87             87,65009678
          DB     57h ;               88             87,18961974
          DB     56h ;               89             86,73342876
          DB     56h ;               90              86,2814857
          DB     55h ;               91             85,83375242
          DB     55h ;               92             85,39019079
          DB     54h ;               93             84,95076266
          DB     54h ;               94             84,51542989
          DB     54h ;               95             84,08415434
          DB     53h ;               96             83,65689787
          DB     53h ;               97             83,23362234
          DB     52h ;               98             82,81428961
          DB     52h ;               99             82,39886155
          DB     51h ;              100                 81,9873
          DB     51h ;              101             81,57956683
          DB     51h ;              102             81,17562391
          DB     50h ;              103             80,77543308
          DB     50h ;              104             80,37895621
          DB     4Fh ;              105             79,98615516
          DB     4Fh ;              106             79,59699179
          DB     4Fh ;              107             79,21142796
          DB     4Eh ;              108             78,82942553
          DB     4Eh ;              109             78,45094636
          DB     4Eh ;              110              78,0759523
          DB     4Dh ;              111             77,70440522
          DB     4Dh ;              112             77,33626698
          DB     4Ch ;              113             76,97149944
          DB     4Ch ;              114             76,61006446
          DB     4Ch ;              115             76,25192389
          DB     4Bh ;              116              75,8970396
          DB     4Bh ;              117             75,54537344
          DB     4Bh ;              118             75,19688729
          DB     4Ah ;              119             74,85154298
          DB     4Ah ;              120              74,5093024
          DB     4Ah ;              121             74,17012739
          DB     49h ;              122             73,83397982
          DB     49h ;              123             73,50082154
          DB     49h ;              124             73,17061442
          DB     48h ;              125             72,84332031
          DB     48h ;              126             72,51890108
          DB     48h ;              127             72,19731858
          DB     47h ;              128             71,87853468
          DB     47h ;              129             71,56251123
          DB     47h ;              130              71,2492101
          DB     46h ;              131             70,93859314
          DB     46h ;              132             70,63062221
          DB     46h ;              133             70,32525918
          DB     46h ;              134              70,0224659
          DB     45h ;              135             69,72220424
          DB     45h ;              136             69,42443604
          DB     45h ;              137             69,12912318
          DB     44h ;              138             68,83622752
          DB     44h ;              139              68,5457109
          DB     44h ;              140              68,2575352
          DB     43h ;              141             67,97166227
          DB     43h ;              142             67,68805397
          DB     43h ;              143             67,40667216
          DB     43h ;              144             67,12747871
          DB     42h ;              145             66,85043546
          DB     42h ;              146             66,57550429
          DB     42h ;              147             66,30264705
          DB     42h ;              148             66,03182559
          DB     41h ;              149             65,76300179
          DB     41h ;              150              65,4961375
          DB     41h ;              151             65,23119458
          DB     40h ;              152             64,96813489
          DB     40h ;              153             64,70692028
          DB     40h ;              154             64,44751263
          DB     40h ;              155             64,18987379
          DB     3Fh ;              156             63,93396561
          DB     3Fh ;              157             63,67974997
          DB     3Fh ;              158             63,42718871
          DB     3Fh ;              159              63,1762437
          DB     3Eh ;              160              62,9268768
          DB     3Eh ;              161             62,67904987
          DB     3Eh ;              162             62,43272476
          DB     3Eh ;              163             62,18786335
          DB     3Dh ;              164             61,94442748
          DB     3Dh ;              165             61,70237901
          DB     3Dh ;              166             61,46167982
          DB     3Dh ;              167             61,22229175
          DB     3Ch ;              168             60,98417667
          DB     3Ch ;              169             60,74729643
          DB     3Ch ;              170              60,5116129
          DB     3Ch ;              171             60,27708794
          DB     3Ch ;              172              60,0436834
          DB     3Bh ;              173             59,81136115
          DB     3Bh ;              174             59,58008304
          DB     3Bh ;              175             59,34981094
          DB     3Bh ;              176              59,1205067
          DB     3Ah ;              177             58,89213219
          DB     3Ah ;              178             58,66464926
          DB     3Ah ;              179             58,43801978
          DB     3Ah ;              180              58,2122056
          DB     39h ;              181             57,98716859
          DB     39h ;              182             57,76287059
          DB     39h ;              183             57,53927349
          DB     39h ;              184             57,31633912
          DB     39h ;              185             57,09402936
          DB     38h ;              186             56,87230606
          DB     38h ;              187             56,65113109
          DB     38h ;              188              56,4304663
          DB     38h ;              189             56,21027355
          DB     37h ;              190              55,9905147
          DB     37h ;              191             55,77115161
          DB     37h ;              192             55,55214615
          DB     37h ;              193             55,33346017
          DB     37h ;              194             55,11505553
          DB     36h ;              195             54,89689409
          DB     36h ;              196             54,67893771
          DB     36h ;              197             54,46114825
          DB     36h ;              198             54,24348757
          DB     36h ;              199             54,02591754
          DB     35h ;              200                 53,8084
          DB     35h ;              201             53,59089682
          DB     35h ;              202             53,37336987
          DB     35h ;              203             53,15578099
          DB     34h ;              204             52,93809205
          DB     34h ;              205             52,72026491
          DB     34h ;              206             52,50226143
          DB     34h ;              207             52,28404347
          DB     34h ;              208             52,06557289
          DB     33h ;              209             51,84681155
          DB     33h ;              210              51,6277213
          DB     33h ;              211             51,40826401
          DB     33h ;              212             51,18840154
          DB     32h ;              213             50,96809575
          DB     32h ;              214              50,7473085
          DB     32h ;              215             50,52600164
          DB     32h ;              216             50,30413704
          DB     32h ;              217             50,08167655
          DB     31h ;              218             49,85858205
          DB     31h ;              219             49,63481537
          DB     31h ;              220              49,4103384
          DB     31h ;              221             49,18511298
          DB     30h ;              222             48,95910098
          DB     30h ;              223             48,73226425
          DB     30h ;              224             48,50456466
          DB     30h ;              225             48,27596406
          DB     30h ;              226             48,04642432
          DB     2Fh ;              227             47,81590729
          DB     2Fh ;              228             47,58437484
          DB     2Fh ;              229             47,35178882
          DB     2Fh ;              230              47,1181111
          DB     2Eh ;              231             46,88330353
          DB     2Eh ;              232             46,64732797
          DB     2Eh ;              233             46,41014629
          DB     2Eh ;              234             46,17172034
          DB     2Dh ;              235             45,93201199
          DB     2Dh ;              236             45,69098308
          DB     2Dh ;              237             45,44859549
          DB     2Dh ;              238             45,20481108
          DB     00h ;              239             44,95959169
;
; ab index 240 (Temperaturen unter 45C) auf Null setzen da diese
; ADC Spannungen groesser 4,7 V liegen und begrenzt werden.
; --> Auswertung: bei Wert "0" Textausgabe "kalt"
;
          DB     00h ;              240              44,7128992
          DB     00h ;              241             44,46469546
          DB     00h ;              242             44,21494233
          DB     00h ;              243             43,96360167
          DB     00h ;              244             43,71063535
          DB     00h ;              245             43,45600521
          DB     00h ;              246             43,19967313
          DB     00h ;              247             42,94160096
          DB     00h ;              248             42,68175055
          DB     00h ;              249             42,42008378
          DB     00h ;              250              42,1565625
          DB     00h ;              251             41,89114857
          DB     00h ;              252             41,62380385
          DB     00h ;              253             41,35449019
          DB     00h ;              254             41,08316947
          DB     00h ;              255             40,80980354

	ORG	2300H
	;****** Kennlinienfeld Oeldruck **************************************
OD_00:  DB	00010000b		;  





;*****************************************************************************
; ENDE DES GESAMTEN QUELLTEXTES
;*****************************************************************************

        END

