;*****************************************************************************
; 	All rights reserved by Dipl.-Ing (FH) Andreas Hoeger
;	Ditzenbrunner Str. 64, 71254 Ditzingen, Germany
;	Telefon: (+497156)490980	Telefax: (+497156)490981
;	E-Mail: ingbuero@andreas-hoeger.de
;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm fr XSTG, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 26.08.2002		
;
;	Aenderungen:
;	14_02_02: Initial version from Dallas Internet Website
;	26_08_02: Neue Funktionen eingefuegt fuer Erstinbetriebnahme mit ADC
;	29_08_02: added ADC_TEMP, Bugfix Timing Resetpulse
;	09_09_02: Neue Funktion fuer Kennlinienfelder / Umrechnung
;	12_09_02: Umwandlung der Ladedruckwerte auskommentiert solange
;		  Kennlinienfeld noch fehlt
;	05_02_03: LLK Druck Umwandlung durch Kennlinienfeld einkommentiert
;	xx_xx_xx: 
;
;*****************************************************************************
;
; The following 8051 code uses a bi-directional port pin (specified by
; ONE_WIRE) for 1-wire I/O. 
;
;*****************************************************************************

READ_DEVICE_ID:	; !! can only be used with one single device on bus
		; otherwise SEARCH ROM is necessary
		; The ID is put on CAN
		
		; use this function to find out the device IDs on new boards
		; and write the result in DSEG_EQU.asm

	;****** transmit reset pulse and wait for presence pulse

	call 	RESETPULSE

	;****** search for ID of device on bus
	;       use READ ROM command (33h)
	; 	- 08 bit family code (20h) 	at the LSBs
	;	- 48 bit serial number
	;	- 08 bit CRC			at the MSBs

	mov	ACC,#READROM		; search for device on bus
	call	SENDBYTE		; ROM command 33h
	
	call	DATA_IN			; get family code
	mov	CAN_D0,ACC
	call	DATA_IN			; get serial number
	mov	CAN_D1,ACC
	call	DATA_IN			; get serial number
	mov	CAN_D2,ACC
	call	DATA_IN			; get serial number
	mov	CAN_D3,ACC
	call	DATA_IN			; get serial number
	mov	CAN_D4,ACC
	call	DATA_IN			; get serial number
	mov	CAN_D5,ACC
	call	DATA_IN			; get serial number
	mov	CAN_D6,ACC
	call	DATA_IN			; get CRC code
	mov	CAN_D7,ACC

	;****** put first ID on CAN for debugging
	;****** CAN- Botschaftsausgabe 517

	mov	CAN_I1,#0A2H		; Botschaft definieren
	mov	CAN_I2,#0E8H		; 517h senden

;	mov	CAN_D0,#00H		;
;	mov	CAN_D1,#00H		;
;	mov	CAN_D2,#00H		; 
;	mov	CAN_D3,#00H		; 
;	mov	CAN_D4,#00H		; 
;	mov	CAN_D5,#00H		;
;	mov	CAN_D6,#00H		;
;	mov	CAN_D7,#00H		;
					
	call	can_tx

	;****** transmit reset pulse and wait for presence pulse

	call 	RESETPULSE

	ret

;*****************************************************************************

ONEWIRE_INIT:

	;****** transmit reset pulse and wait for presence pulse

	call	RESETPULSE

	;****** address first device on bus (ADC temperature)

	call	ADDR_DEVICE_1	; DEVICE 1 = TEMP

	;****** write configuration data of first device
	; 	config data
	;	reset "power on bit" of first device
	;	write 40h --> address 1Ch because VCC powered 

	; write config data for all channels, begin at adr. 08

	mov	ACC,#WRITEMEMORY	; command 55h
	call	SENDBYTE
	mov	ACC,#08h		; adress low
	call	SENDBYTE
	mov	ACC,#00h		; address high
	call	SENDBYTE

	mov	ACC,#DEV1_P1_A_08	; data
	call	SENDBYTE

	; read back 16 bit CRC to confirm
	call	DATA_IN			; get CRC first 8 bit
	;mov	...			; throw away
	call	DATA_IN			; get CRC second 8 bit
	mov	A,#00H			; throw away
	; read back memory copy 8 bit to confirm data
	call	DATA_IN			; 
	;mov	...			; 
	mov	A,#DEV1_P1_A_09	; data
	call	SENDBYTE
	; read back 16 bit CRC to confirm
	call	DATA_IN			; get CRC first 8 bit
	;mov	...			; throw away
	call	DATA_IN			; get CRC second 8 bit
	mov	A,#00H			; throw away
	; read back memory copy 9 bit to confirm data
	call	DATA_IN			; 
	;mov	...			; 

	mov	A,#DEV1_P1_B_0A	; data
	call	SENDBYTE
	; read back 16 bit CRC to confirm
	call	DATA_IN			; get CRC first 8 bit
	;mov	...			; throw away
	call	DATA_IN			; get CRC second 8 bit
	mov	A,#00H			; throw away
	; read back memory copy A bit to confirm data
	call	DATA_IN			; 
	;mov	...			; 

	mov	A,#DEV1_P1_B_0B	; data
	call	SENDBYTE
	; read back 16 bit CRC to confirm
	call	DATA_IN			; get CRC first 8 bit
	;mov	...			; throw away
	call	DATA_IN			; get CRC second 8 bit
	mov	A,#00H			; throw away
	; read back memory copy B bit to confirm data
	call	DATA_IN			; 
	;mov	...			; 

	mov	A,#DEV1_P1_C_0C	; data
	call	SENDBYTE
	; read back 16 bit CRC to confirm
	call	DATA_IN			; get CRC first 8 bit
	;mov	...			; throw away
	call	DATA_IN			; get CRC second 8 bit
	mov	A,#00H			; throw away
	; read back memory copy C bit to confirm data
	call	DATA_IN			; 
	;mov	...			; 

	mov	A,#DEV1_P1_C_0D	; data
	call	SENDBYTE
	; read back 16 bit CRC to confirm
	call	DATA_IN			; get CRC first 8 bit
	;mov	...			; throw away
	call	DATA_IN			; get CRC second 8 bit
	mov	A,#00H			; throw away
	; read back memory copy D bit to confirm data
	call	DATA_IN			; 
	;mov	...			; 

	mov	A,#DEV1_P1_D_0E	; data
	call	SENDBYTE
	; read back 16 bit CRC to confirm
	call	DATA_IN			; get CRC first 8 bit
	;mov	...			; throw away
	call	DATA_IN			; get CRC second 8 bit
	mov	A,#00H			; throw away
	; read back memory copy E bit to confirm data
	call	DATA_IN			; 
	;mov	...			; 

	mov	A,#DEV1_P1_D_0F	; data
	call	SENDBYTE
	; read back 16 bit CRC to confirm
	call	DATA_IN			; get CRC first 8 bit
	;mov	...			; throw away
	call	DATA_IN			; get CRC second 8 bit
	mov	A,#00H			; throw away
	; read back memory copy F bit to confirm data
	call	DATA_IN			; 
	;mov	...			; 
 
	;****** transmit reset pulse at the end

	call	RESETPULSE

	;****** address second device on bus

	call	ADDR_DEVICE_2

	;****** write configuration data of first device
	; 	config data
	;	reset "power on bit" of first device
	;	write 40h --> address 1Ch because VCC powered 

	; write config data for C,D channels, begin at adr. 0C

	mov	ACC,#WRITEMEMORY	; command 55h
	call	SENDBYTE
	mov	ACC,#0Ch		; adress low
	call	SENDBYTE
	mov	ACC,#00h		; address high
	call	SENDBYTE

	mov	A,#DEV2_P1_C_0C	; data
	call	SENDBYTE
	; read back 16 bit CRC to confirm
	call	DATA_IN			; get CRC first 8 bit
	;mov	...			; throw away
	call	DATA_IN			; get CRC second 8 bit
	mov	A,#00H			; throw away
	; read back memory copy 8 bit to confirm data
	call	DATA_IN			; 
	;mov	...			; 

	mov	A,#DEV2_P1_C_0D	; data
	call	SENDBYTE
	; read back 16 bit CRC to confirm
	call	DATA_IN			; get CRC first 8 bit
	;mov	...			; throw away
	call	DATA_IN			; get CRC second 8 bit
	mov	A,#00H			; throw away
	; read back memory copy D bit to confirm data
	call	DATA_IN			; 
	;mov	...			; 

	mov	A,#DEV2_P1_D_0E	; data
	call	SENDBYTE
	; read back 16 bit CRC to confirm
	call	DATA_IN			; get CRC first 8 bit
	;mov	...			; throw away
	call	DATA_IN			; get CRC second 8 bit
	mov	A,#00H			; throw away
	; read back memory copy E bit to confirm data
	call	DATA_IN			; 
	;mov	...			; 

	mov	A,#DEV2_P1_D_0F	; data
	call	SENDBYTE
	; read back 16 bit CRC to confirm
	call	DATA_IN			; get CRC first 8 bit
	;mov	...			; throw away
	call	DATA_IN			; get CRC second 8 bit
	mov	A,#00H			; throw away
	; read back memory copy F bit to confirm data
	call	DATA_IN			; 
	;mov	...			; 
 
	;****** transmit reset pulse at the end

	call	RESETPULSE

	RET

;*****************************************************************************

ADDR_DEVICE_1:	; to be called after resetpulse to send 
		; MATCH ROM command of device 1 and address of device 1

		; DEVICE 1 = TEMPERATURE		

		; TX ROM command "MATCH ROM"

	mov	ACC,#MATCHROM		; command 55h
	call	SENDBYTE

	mov	ACC,#DEV1_ID_0		; ID LSBs
	call	SENDBYTE
	mov	ACC,#DEV1_ID_1		; ID
	call	SENDBYTE
	mov	ACC,#DEV1_ID_2		; ID
	call	SENDBYTE
	mov	ACC,#DEV1_ID_3		; ID
	call	SENDBYTE
	mov	ACC,#DEV1_ID_4		; ID
	call	SENDBYTE
	mov	ACC,#DEV1_ID_5		; ID
	call	SENDBYTE
	mov	ACC,#DEV1_ID_6		; ID
	call	SENDBYTE
	mov	ACC,#DEV1_ID_7		; ID MSBs
	call	SENDBYTE
	
	; go back and be ready for memory functions

	ret

;*****************************************************************************

ADDR_DEVICE_2:	; to be called after resetpulse to send 
		; MATCH ROM command of device 2 and address of device 2

		; DEVICE 2 = DRUCK		

		; TX ROM command "MATCH ROM"

	mov	ACC,#MATCHROM		; command 55h
	call	SENDBYTE

	mov	ACC,#DEV2_ID_0		; ID LSBs
	call	SENDBYTE
	mov	ACC,#DEV2_ID_1		; ID
	call	SENDBYTE
	mov	ACC,#DEV2_ID_2		; ID
	call	SENDBYTE
	mov	ACC,#DEV2_ID_3		; ID
	call	SENDBYTE
	mov	ACC,#DEV2_ID_4		; ID
	call	SENDBYTE
	mov	ACC,#DEV2_ID_5		; ID
	call	SENDBYTE
	mov	ACC,#DEV2_ID_6		; ID
	call	SENDBYTE
	mov	ACC,#DEV2_ID_7		; ID MSBs
	call	SENDBYTE
	
	; go back and be ready for memory functions

	ret

;*****************************************************************************

ADC_DRUCK: 	; DRUCK = DEVICE 2

	;****** transmit reset pulse and wait for presence pulse

	call	RESETPULSE

	;****** address device on bus

	call	ADDR_DEVICE_2

	;****** transmit CONVERT command and parameters
	;	- input select
	;	- read out control

	mov	ACC,#CONVERT		; command 3Ch
	call	SENDBYTE
	mov	ACC,#0Ch		; input select mask
	call	SENDBYTE		; only channel C,D
	mov	ACC,#55h		; read out control
	call	SENDBYTE		; preset all channels to zero

	call	DATA_IN			; get CRC first 8 bit
	;mov	...			; throw away
	call	DATA_IN			; get CRC second 8 bit
	mov	A,#00H			; throw away


	;****** wait until conversion finished (some millisek)

	call	zehn_ms

	;****** transmit reset pulse and wait for presence pulse

	call	RESETPULSE

	;****** address device on bus

	call	ADDR_DEVICE_2

	;****** transmit READ MEMORY command and parameters
	;	- address low
	;	- address high
	;       channel C and D used --> start at address 04h
	;			     --> get four bytes

	mov	ACC,#READMEMORY		; command AAh
	call	SENDBYTE
	mov	ACC,#04h		; adress low
	call	SENDBYTE
	mov	ACC,#00h		; address high
	call	SENDBYTE


	call	DATA_IN			; get channel C low
	;mov	...			; throw away
	call	DATA_IN			; get channel C high
	mov	OEL_DRUCK,ACC

	call	DATA_IN			; get channel D low
	;mov	...			; throw away
	call	DATA_IN			; get channel D high
	mov	LLK_DRUCK,ACC

	call	DATA_IN			; get CRC first 8 bit
	;mov	...			; throw away
	call	DATA_IN			; get CRC second 8 bit
	mov	A,#00H			; throw away

	;****** transmit reset pulse and wait for presence pulse

	call	RESETPULSE

	RET

;*****************************************************************************

ADC_TEMP:	; TEMP = DEVICE 1

	;****** transmit reset pulse and wait for presence pulse

	call	RESETPULSE

	;****** address device on bus

	call	ADDR_DEVICE_1

	;****** transmit CONVERT command and parameters
	;	- input select
	;	- read out control

	mov	ACC,#CONVERT		; command 3Ch
	call	SENDBYTE
	mov	ACC,#0Fh		; input select mask
	call	SENDBYTE		; all channels A,B,C,D
	mov	ACC,#55h		; read out control
	call	SENDBYTE		; preset all channels to zero

	call	DATA_IN			; get CRC first 8 bit
	;mov	...			; throw away
	call	DATA_IN			; get CRC second 8 bit
	mov	A,#00H			; throw away


	;****** wait until conversion finished (some millisek)

	call	zehn_ms

	;****** transmit reset pulse and wait for presence pulse

	call	RESETPULSE

	;****** address device on bus

	call	ADDR_DEVICE_1

	;****** transmit READ MEMORY command and parameters
	;	- address low
	;	- address high
	;       channel A to D used --> start at address 00h
	;			    --> get all eight bytes

	mov	ACC,#READMEMORY		; command AAh
	call	SENDBYTE
	mov	ACC,#00h		; adress low
	call	SENDBYTE
	mov	ACC,#00h		; address high
	call	SENDBYTE


	call	DATA_IN			; get channel A low
	;mov	...			; throw away
	call	DATA_IN			; get channel A high
	mov	LLK_H2O_TEMP,ACC

	call	DATA_IN			; get channel B low
	;mov	...			; throw away
	call	DATA_IN			; get channel B high
	mov	MOTOR_H2O_TEMP,ACC

	call	DATA_IN			; get channel C low
	;mov	...			; throw away
	call	DATA_IN			; get channel C high
	mov	LLK_TEMP,ACC

	call	DATA_IN			; get channel D low
	;mov	...			; throw away
	call	DATA_IN			; get channel D high
	mov	OEL_TEMP,ACC

	call	DATA_IN			; get CRC first 8 bit
	;mov	...			; throw away
	call	DATA_IN			; get CRC second 8 bit
	mov	A,#00H			; throw away

	;****** transmit reset pulse and wait for presence pulse

	call	RESETPULSE

	RET

;*****************************************************************************

ADC_FIELDCONVERT:	

	;****** takes the ADC results
	;	- LLK_TEMP
	;	- OEL_TEMP
	;	- LLK_DRUCK
	;	- OEL_DRUCK
	;       and converts the data according to the "Kennlinienfeld"
	; 	input and output in same variable

	;****** LLK_TEMP

	mov	A,LLK_TEMP	; lade den urspruenglichen Messwert
				; und nehme ihn als index (Offset)
				; im Kennlinienfeld
	mov	DPTR,#LT_00	; lade Beginn des Kennlinienfeldes
				; mit Index 00h (von 00h ... FFh)
	movc	A,@A+DPTR	; lade das korrigierte Byte in Akku
	mov	LLK_TEMP,A	; speichere zurueck

	;****** OEL_TEMP

	mov	A,OEL_TEMP	; lade den urspruenglichen Messwert
				; und nehme ihn als index (Offset)
				; im Kennlinienfeld
	mov	DPTR,#OT_00	; lade Beginn des Kennlinienfeldes
				; mit Index 00h (von 00h ... FFh)
	movc	A,@A+DPTR	; lade das korrigierte Byte in Akku
	mov	OEL_TEMP,A	; speichere zurueck

	;****** LLK_DRUCK

	mov	A,LLK_DRUCK	; lade den urspruenglichen Messwert
				; und nehme ihn als index (Offset)
				; im Kennlinienfeld
	mov	DPTR,#LD_00	; lade Beginn des Kennlinienfeldes
				; mit Index 00h (von 00h ... FFh)
	movc	A,@A+DPTR	; lade das korrigierte Byte in Akku
	mov	LLK_DRUCK,A	; speichere zurueck

	;****** OEL_DRUCK

;	mov	A,OEL_DRUCK	; lade den urspruenglichen Messwert
				; und nehme ihn als index (Offset)
				; im Kennlinienfeld
;	mov	DPTR,#OD_00	; lade Beginn des Kennlinienfeldes
				; mit Index 00h (von 00h ... FFh)
;	movc	A,@A+DPTR	; lade das korrigierte Byte in Akku
;	mov	OEL_DRUCK,A	; speichere zurueck


	RET	

;*****************************************************************************
;         Procedure Resetpulse
;
;         This procedure transmits the Reset signal to the ADC
;         and watches for a presence pulse. On return,
;         the Carry bit is set if a presence pulse was detected,
;         otherwise the Carry is cleared.
;
;
RESETPULSE:
          PUSH      B                     ;       Save the B register.
          PUSH      ACC                   ;       Save the accumulator.
          MOV       A,        #4          ;       Load outer loop variable.
          CLR       ONEWIRE               ;       Start the reset pulse.
;---- min 640 cycles LOW bei 16MHz
          MOV       B,        #180        ;   2.  Set time interval.
          DJNZ      B,        $           ; 360.  Wait with Data low.
          MOV       B,        #180        ;   2.  Set time interval.
          DJNZ      B,        $           ; 360.  Wait with Data low.
;----
          SETB      ONEWIRE               ;   1.  Release Data line.
          MOV       B,        #6          ;   2.  Set time interval.
          CLR       C                     ;   1.  Clear presence flag.
WAITLOW:
          JB        ONEWIRE, WH           ;       Exit loop if line high.
          DJNZ      B,        WAITLOW     ;       Hang around if line is low.
          DJNZ      ACC,      WAITLOW     ; 
          SJMP      SHORT                 ;       Line could not go high.
WH:
          MOV       B,        #160        ;       Delay for presence detect.
HL:
          ORL       C,        /ONEWIRE    ; 320.  Catch presence pulse.
          DJNZ      B,        HL          ; 320.  Wait with Data high.
SHORT:
          POP       ACC                   ;       Restore accumulator.
          POP       B                     ;       Restore B register.
          RET                             ;       Return.

;*****************************************************************************
;         Procedure DATA_IN: returns byte from 1-wire device in ACC
;	  Procedure SENDBYTE: sends byte in ACC to 1-wire device
;         Timing for 16MHz
;
;BIT_IO:
;          RRC       A                     ; Get bit to send in carry.
;          CALL      TOUCHBIT              ; Send bit.
;          RLC       A                     ; Collect returned bit in ACC.
;          RET                             ; Return to caller.

DATA_IN:
          MOV       A,        #0FFH       ;       Initialize for input.
SENDBYTE:
          PUSH      B                     ;       Save the B register.
          MOV       B,        #8          ;       Setup for 8 bits.
BIT_LOOP:
          RRC       A                     ;   1.  Get bit in carry.
          CALL      TOUCHBIT              ;   2.  Send bit.
          DJNZ      B,        BIT_LOOP    ;   2.  Get next bit.
          RRC       A                     ;       Get final bit in ACC.
          POP       B                     ;       Restore B register.
          RET                             ;       Return to caller.
TOUCHBIT:
          CLR       ONEWIRE               ;   1.  Start the time slot.
          NOP                             ;   1.  Delay to make sure
          NOP                             ;   1.    that the 1-wire device
          NOP                             ;   1.      sees a low for at
          NOP                             ;   1.        least 1 microsecond.
	  NOP				; added for 16 MHz
	  NOP				; added for 16 MHz
          MOV       ONEWIRE, C            ;   2.  Send out the data bit.
          NOP                             ;   1.  Delay to give the
          NOP                             ;   1.    data returned from
          NOP                             ;   1.      the 1-wire device
          NOP                             ;   1.        time to settle
          NOP                             ;   1.          before reading
          NOP                             ;   1.            the bit.
	  NOP				; added for 16 MHz
	  NOP				; added for 16 MHz
          MOV       C,        ONEWIRE     ;   1.  Sample input data bit.
          PUSH      B                     ;   2.  Save B register.
          MOV       B,        #18H        ;   2.  Delay until the end
          DJNZ      B,        $           ;   54.   of the time slot.
          POP       B                     ;       Restore B register.
          SETB      ONEWIRE               ;       Terminate time slot.
          RET                             ;       Return to caller.

;*****************************************************************************

ONEWIRE_SEARCH_DEVICES: ; --> not finished yet !!

	;****** transmit reset pulse and wait for presence pulse

	call 	RESETPULSE

	;****** search for ID of first device on bus
	;       use SEARCH ROM command (F0h)
	; 	- 08 bit family code (20h) 	at the LSBs
	;	- 48 bit serial number
	;	- 08 bit CRC			at the MSBs

	mov	ACC,#SEARCHROM		; search for devices on bus
	call	SENDBYTE		; ROM command 0F0h
	
	;--> send bits to test here 


	; ALGORITHM MISSING



	;****** put first ID on CAN for debugging
	;****** CAN- Botschaftsausgabe 517

	mov	CAN_I1,#0A2H		; Botschaft definieren
	mov	CAN_I2,#0E8H		; 517h senden

	mov	CAN_D0,#00H		; 
	mov	CAN_D1,#00H		; 
	mov	CAN_D2,#00H		; 
	mov	CAN_D3,#00H		; 
	mov	CAN_D4,#00H		; 
	mov	CAN_D5,#00H		;
	mov	CAN_D6,#00H		;
	mov	CAN_D7,#00H		;
					
	call	can_tx

	;****** transmit reset pulse and wait for presence pulse

	call 	RESETPULSE


	;****** search for ID of second device on bus
	;       use SEARCH ROM command (F0h)
	; 	- 08 bit family code (20h) 	at the LSBs
	;	- 48 bit serial number
	;	- 08 bit CRC			at the MSBs


	; ....

	;****** put second ID on CAN for debugging
	;****** CAN- Botschaftsausgabe 518

	mov	CAN_I1,#0A3H		; Botschaft definieren
	mov	CAN_I2,#08H		; 518h senden

	mov	CAN_D0,#00H		; 
	mov	CAN_D1,#00H		; 
	mov	CAN_D2,#00H		; 
	mov	CAN_D3,#00H		; 
	mov	CAN_D4,#00H		; 
	mov	CAN_D5,#00H		;
	mov	CAN_D6,#00H		;
	mov	CAN_D7,#00H		;
					
	call	can_tx


	RET

;*****************************************************************************
	
;CRC_check:
          
;	EXTRN     DATA(TEMP, ROMDTA)
;
;   The following code checks the Dallas Semiconductor 1-Wire CRC of the
;   data in the 8 byte array romdta. The function dowchk initializes the
;   cummulative crc byte (TEMP) and computes the crc of all eight bytes.
;   It returns with the carry set if TEMP = 0. Otherwise it returns with
;   the carry clear.
;
;DOWCHK:
;          MOV       A,        R0          ; Get contents of R0 in accumulator.
;          PUSH      ACC                   ; Save contents of R0.
;          PUSH      B                     ; Save the B register.
;          MOV       B,        #8          ; Prepare for 8 bytes.
;          MOV       TEMP,     #0          ; Initialize CRC variable.
;          MOV       R0,       #ROMDTA     ; Point to first byte of ROM data.
;CALCMORE:
;          MOV       A,       @R0          ; Get byte of ROM data in acc.
;          CALL      DOW_CRC               ; Calculate cummulative CRC.
;          INC       R0                    ; Point to next byte of ROM data.
;          DJNZ      B,        CALCMORE    ; Repeat until finished.
;          MOV       A,        TEMP        ; Get CRC value in ACC.
;          JZ        SUCCESS               ; Jump if successful.
;          SJMP      FAILURE               ; Exit with failure.
;SUCCESS:
;          SETB      C                     ; Indicate success.
;          SJMP      GOODCRC               ; Leave.
;FAILURE:
;          CLR       C                     ; Indicate failure.
;GOODCRC:
;          POP       B                     ; Restore the B register.
;          POP       ACC                   ; Get old R0 in accumulator.
;          MOV       R0,       A           ; Restore R0.
;          RET                             ; Return to caller.
;
;         Procedure DOW_CRC
;
;         The assembly language procedure DOW_CRC given below
;         calculates the cumulative CRC of all the bytes passed
;         to it in the accumulator. Before it is used to calculate
;         the CRC of a data stream, it should be initialized by
;         setting the variable TEMP to zero. Each byte of the data
;         is then placed in the accumulator and DOW_CRC is called
;         to update the CRC. After all the data has been passed
;         to DOW_CRC, the variable TEMP will contain the result.
;
;DOW_CRC:
;          PUSH      ACC                   ; Save the Accumulator.
;          PUSH      B                     ; Save the B register.
;          PUSH      ACC                   ; Save bits to be shifted.
;          MOV       B,        #8          ; Set to shift eight bits.
;CRC_LOOP:
;          XRL       A,        TEMP        ; Calculate DQIN xor CRCT0.
;          RRC       A                     ; Move it to the carry.
;          MOV       A,        TEMP        ; Get the last CRC value.
;          JNC       ZERO                  ; Skip if DQIN xor CRCT0 = 0.
;          XRL       A,        #18H        ; Update the CRC value.
;ZERO:
;          RRC       A                     ; Position the new CRC.
;          MOV       TEMP,     A           ; Store the new CRC.
;          POP       ACC                   ; Get the remaining bits.
;          RR        A                     ; Position next bit in LSB.
;          PUSH      ACC                   ; Save the remaining bits.
;          DJNZ      B,        CRC_LOOP    ; Repeat for eight bits.
;          POP       ACC                   ; Clean up the stack.
;          POP       B                     ; Restore the B register.
;          POP       ACC                   ; Restore the Accumulator.
;          RET                             ; Return.

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

