;*****************************************************************************
; 	All rights reserved by Dipl.-Ing (FH) Andreas Hoeger
;	Ditzenbrunner Str. 64, 71254 Ditzingen, Germany
;	Telefon: (+497156)490980	Telefax: (+497156)490981
;	E-Mail: ingbuero@andreas-hoeger.de
;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm, wird durch INCLUDE eingebunden
; 	Unterprogramme fr Schaltfunktionen durch Menuesteuerung
;
;       Autor: Andreas Hoeger
;       Datum: 26.11.2000		
;
;	Aenderungen:
;	05_03_02: HZG_COMMAND eingefuegt
;	08_03_02: aktualisiert fuer XSTG
;	11_03_02: COMMAND_ZSTG_1 eingefuegt
;	12_03_02: Bugfix Maskierung
;	11_06_02: Erweiterung der Standheizungs-Funktionen
;	03_10_02: mstg_on / off beeinflusst BIT04 ...
;	09_03_03: Beeinflussung PowerDownBits bei MSTG_12V herausgenommen
;
;*****************************************************************************
	; Belegung des Wortes 'OUT_SHIFT' (an Relais)
	; Bit 0 (LSB): 
	; Bit 1      :  
	; Bit 2	     : 
	; Bit 3	     : Geblaese Heizung Stufe 1
	; Bit 4	     : 
	; Bit 5	     : 
	; Bit 6	     : 
	; Bit 7 (MSB): 
;*****************************************************************************
	; Belegung CAN Botschaft 'COMMAND_ZSTG_1' Botschaft 504
	; Byte 0: Bit 0: Versorgung MSTG 12 Volt	1=ein, 0=aus (auf CAN)
	;	  Bit 1: Innenbeleuchtung		1=ein, 0=aus (auf CAN)
	;	  Bit 2: Steckdose			1=ein, 0=aus (auf CAN)
	;	  Bit 3: Trennrelais			1=ein, 0=aus (auf CAN)
	;	  Bit 4: Gong				1=ein, 0=aus (auf CAN)
	;	  Bit 5:
	;	  Bit 6:
	;	  Bit 7:
;*****************************************************************************
	; Belegung CAN Botschaft 'COMMAND_MSTG_1' Botschaft 505
	;
;*****************************************************************************

mstg12v_ein:			; Versorgung MSTG einschalten 
				; ueber CAN an ZSTG
	mov	A,COMMAND_ZSTG_1
	orl	A,#CAN_MSTG12V_SET	; OR 01H
	mov	COMMAND_ZSTG_1,A
	ret

mstg12v_aus:			; Versorgung MSTG ausschalten 
				; ueber CAN an ZSTG
	mov	A,COMMAND_ZSTG_1
	anl	A,#CAN_MSTG12V_CLR	; AND FEH
	mov	COMMAND_ZSTG_1,A
	ret

;******

innenbel_ein:			; Innenbeleuchtung einschalten 
				; ueber CAN an ZSTG
	mov	A,COMMAND_ZSTG_1
	orl	A,#CAN_BEL_SET		; OR 02H
	mov	COMMAND_ZSTG_1,A
	ret

innenbel_aus:			; Innenbeleuchtung ausschalten 
				; ueber CAN an ZSTG
	mov	A,COMMAND_ZSTG_1
	anl	A,#CAN_BEL_CLR		; AND FDH
	mov	COMMAND_ZSTG_1,A
	ret

;******

steckdose_ein:			; Steckdose einschalten
				; ueber CAN an ZSTG
	mov	A,COMMAND_ZSTG_1
	orl	A,#CAN_DOSE_SET		; OR 04H
	mov	COMMAND_ZSTG_1,A
	ret

steckdose_aus:			; Steckdose ausschalten
				; ueber CAN an ZSTG
	mov	A,COMMAND_ZSTG_1
	anl	A,#CAN_DOSE_CLR		; AND FBH
	mov	COMMAND_ZSTG_1,A
	ret

;****** 

trennrel_ein:			; Trennrelais einschalten
				; ueber CAN an ZSTG
	mov	A,COMMAND_ZSTG_1
	orl	A,#CAN_TRENN_SET		; OR 08H
	mov	COMMAND_ZSTG_1,A
	ret

trennrel_aus:			; Trennrelais ausschalten
				; ueber CAN an ZSTG
	mov	A,COMMAND_ZSTG_1
	anl	A,#CAN_TRENN_CLR		; AND F7H
	mov	COMMAND_ZSTG_1,A
	ret

;****** 

heizluft_ein:			; Ansteuerung Relais
				; an HSTG_Basisplatine
	mov	A,OUT_SHIFT
	orl	A,#OUT_HEIZLUFT_SET	; OR 08H
	mov	OUT_SHIFT,A
	ret

heizluft_aus:			; Ansteuerung Relais
				; an HSTG_Basisplatine
	mov	A,OUT_SHIFT
	anl	A,#OUT_HEIZLUFT_CLR	; AND F7H
	mov	OUT_SHIFT,A
	ret

;******

displaybel_ein:

	setb	LED		; LED Beleuchtung einschalten
	ret			; direkt Portpin HSTG

displaybel_aus:

	clr	LED		; LED Beleuchtung ausschalten
	ret			; direkt Portpin HSTG

;******

displaybel_58_ein:
				; aufgrund Klemme 58 aktiv
	setb	LED		; LED Beleuchtung einschalten
	ret			; direkt Portpin HSTG

displaybel_58_aus:
				; aufgrund Klemme 58 nicht aktiv	
	clr	LED		; LED Beleuchtung ausschalten
	ret			; direkt Portpin HSTG

;******
menu_hzg_ein:			; Standheizung einschalten
				; ueber CAN an MSTG
	mov 	A,HZG_COMMAND
	orl	A,#01H
	mov 	HZG_COMMAND,A		;Bit [0]    1 = ein
	ret
schaltuhr_hzg_ein:
	mov 	A,HZG_COMMAND
	orl	A,#02H
	mov 	HZG_COMMAND,A		;Bit [1]    1 = ein
	ret
waeco_hzg_ein:
	mov 	A,HZG_COMMAND
	orl	A,#04H
	mov 	HZG_COMMAND,A		;Bit [2]    1 = ein
	ret
				
menu_hzg_aus:			; Standheizung ausschalten
				; ueber CAN an MSTG
	mov 	A,HZG_COMMAND
	anl	A,#0FEH
	mov 	HZG_COMMAND,A		;Bit [0]    0 = aus
	ret
schaltuhr_hzg_aus:
	mov 	A,HZG_COMMAND
	anl	A,#0FDH
	mov 	HZG_COMMAND,A		;Bit [1]    0 = aus
	ret
waeco_hzg_aus:
	mov 	A,HZG_COMMAND
	anl	A,#0FBH
	mov 	HZG_COMMAND,A		;Bit [2]    0 = aus
	ret

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

