 ;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 16.09.2000		
;
;	Aenderungen:
;	31_10_00: Switch fuer HW-Version 1.2 eingebunden
;	10_11_00: Tastaturinvertierung eingefuegt
;	12_11_00: Switch und Komponenten < V1.2 entfernt
;	26_11_00: OUT_Shift bleibt erhalten durch Verwendung von IN_TAST
;		  als temporaerer Zwischenspeicher
;
;*****************************************************************************

        ;*********************************************************************
        ; Unterprogramm zum Einlesen der Schieberegister
        ;*********************************************************************
	
io_shift:	
	; Diese geaenderte Routine fuer Version 1.2 gibt ein Byte an das
	; Ausgangsschieberegister aus und liest die Eingangsdaten von den 
	; beiden Eingangsschieberegistern ein, MSB first (Bit Nr. H von IC2 
	; kommt zuerst).
	; Portpins Eingang / Ausgang ist bereits definiert.
	; DIG_CLK wird low erwartet und kehrt low zurueck.
	; DIG_SH wird high erwartet und kehrt high zurueck.
	; DIG_DS wird low erwartet und kehrt low zurueck.
	; Erhaltenes Byte von IC2 (Tastatur) wird in IN_TAST zurueckgegeben.
	; Erhaltenes Byte von IC6 (Optokoppler) wird in IN_OPTO zurueckgegeben.

	; !! Das erste Bit kann vor dem ersten Takt eingelesen werden !!

	; Ausgabewerte werden in OUT_SHIFT erwartet und von dort verwendet.
	; Inhalt des Registers OUT_SHIFT wird bei der Ausgabe nicht zerstoert, 
	; weil IN_TAST als Zwischenspeicher funktioniert, das spaeter sowieso
	; neu geladen wird mit echten Eingangswerten.	

	; Ablauf:
	; * zuerst die 8 Ausgangsbits raustakten
	; * in Ausgangsreg. uebernehmen und von Eingangsreg. latchen
	; * dann 16 Eingangswerte reintakten

	push	ACC
	mov	IN_TAST,#00H
	mov	IN_OPTO,#00H

sh_out:
	; Ausgabebits raustakten
	mov	CNT0,#8		; Anzahl Schiebeaktionen fr 8 Bit
	mov	IN_TAST,OUT_SHIFT	; OUT_SHIFT umladen damit es 
					; erhalten bleibt
sh_ic16:
	mov	A,IN_TAST	; fuer Zwischenspeicherung beim Schieben
	rlc	A
	mov	DIG_DS,C	; output Bit an IC16
	mov	IN_TAST,A	; sichern fuer Zwischenspeicherung
		
	setb	DIG_CLK		; steigende Flanke Takt
	call	us_50
	clr	DIG_CLK		; Taktpuls beenden
	call	us_50
	djnz	CNT0,sh_ic16

sh_over:
	; Datenuebernahme / Datenuebergabe	

	clr	DIG_SH		; DIG_SH auf low, Daten parallel laden
				; bei steigender Flanke Ausgangsdaten
				; in Ausgangslatch uebernehmen
	call	us_50						
	setb	DIG_SH		; DIG_SH auf high, Daten jetzt schieben

sh_in:
	; Eingangsbits hereintakten, zuerst die fuer IC2
	mov	CNT0,#8		; Anzahl Bits pro Byte
	
sh_ic2:	mov	A,IN_TAST	; fuer Zwischenspeicherung beim Schieben
	mov	C,DIG_QH6_2	; input Bit von IC2
	rlc	A
	mov	IN_TAST,A	; sichern fuer Zwischenspeicherung
		
	setb	DIG_CLK		; steigende Flanke Takt
	call	us_50
	clr	DIG_CLK		; Taktpuls beenden
	call	us_50
	djnz	CNT0,sh_ic2

	; Eingangsbits hereintakten, jetzt fuer IC6
	mov	CNT0,#8		; Anzahl Bits pro Byte
	
sh_ic6:	mov	A,IN_OPTO	; fuer Zwischenspeicherung beim Schieben
	mov	C,DIG_QH6_2	; input Bit von IC6
	rlc	A
	mov	IN_OPTO,A	; sichern fuer Zwischenspeicherung
		
	setb	DIG_CLK		; steigende Flanke Takt
	call	us_50
	clr	DIG_CLK		; Taktpuls beenden
	call	us_50
	djnz	CNT0,sh_ic6

	pop	ACC
	ret

;*****************************************************************************
 
tast_invert:
	; invertiert das Ergebnis der Tastatur	
	; Eingangsdaten: IN_TAST
	; Ausgangsdaten: IN_TAST, alle Bits invertiert

	jb	IN_TAST.7,clr7
	setb	IN_TAST.7
	jmp	tast6
clr7:	clr	IN_TAST.7
tast6:	jb	IN_TAST.6,clr6
	setb	IN_TAST.6
	jmp	tast5
clr6:	clr	IN_TAST.6	
tast5:	jb	IN_TAST.5,clr5
	setb	IN_TAST.5
	jmp	tast4
clr5:	clr	IN_TAST.5	
tast4:	jb	IN_TAST.4,clr4
	setb	IN_TAST.4
	jmp	tast3
clr4:	clr	IN_TAST.4	
tast3:	jb	IN_TAST.3,clr3
	setb	IN_TAST.3
	jmp	tast2
clr3:	clr	IN_TAST.3	
tast2:	jb	IN_TAST.2,clr2
	setb	IN_TAST.2
	jmp	tast1
clr2:	clr	IN_TAST.2	
tast1:	jb	IN_TAST.1,clr1
	setb	IN_TAST.1
	jmp	tast0
clr1:	clr	IN_TAST.1	
tast0:	jb	IN_TAST.0,clr0
	setb	IN_TAST.0
	jmp	tastend
clr0:	clr	IN_TAST.0	
tastend:
	ret    
   
;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

 
