;*****************************************************************************
; 	All rights reserved by Dipl.-Ing (FH) Andreas Hoeger
;	Ditzenbrunner Str. 64, 71254 Ditzingen, Germany
;	Telefon: (+497156)490980	Telefax: (+497156)490981
;	E-Mail: ingbuero@andreas-hoeger.de
;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 03.03.2002		
;
;	Aenderungen:
;	03_03_02: Initial version for Network-initialization
;	22_06_02: more rx commands because more CAN mailboxes exist
;	21_08_02: MSTG init included
;	25_08_02: Timeoutzeit mit CAN- Rx Wiederholung eingefuegt
;	xx_yy_zz: 
;
;*****************************************************************************
	
ini_network:
	
	mov	MERK,#TO_NETINI_SEARCH	; Timeoutzeit fuer Suche nach 
					; Partnersteuergeraeten

ini_net_zstg_loop:

	;****** mindestend soviele Botschaften holen wie Mailboxen

	call	sek_1

	call	can_rx    	; pruefen ob Botschaft im Empfangspuffer
				; des SJA1000 ist; ggf. Identifier lesen 
				; und Botschaft in Mailbox uebertragen
	call	can_rx    	; pruefen ob Botschaft im Empfangspuffer
				; des SJA1000 ist; ggf. Identifier lesen 
				; und Botschaft in Mailbox uebertragen
	call	can_rx    	; pruefen ob Botschaft im Empfangspuffer
				; des SJA1000 ist; ggf. Identifier lesen 
				; und Botschaft in Mailbox uebertragen
	call	can_rx    	; pruefen ob Botschaft im Empfangspuffer
				; des SJA1000 ist; ggf. Identifier lesen 
				; und Botschaft in Mailbox uebertragen
	call	can_rx    	; pruefen ob Botschaft im Empfangspuffer
				; des SJA1000 ist; ggf. Identifier lesen 
				; und Botschaft in Mailbox uebertragen
	call	can_rx    	; pruefen ob Botschaft im Empfangspuffer
				; des SJA1000 ist; ggf. Identifier lesen 
				; und Botschaft in Mailbox uebertragen
	call	can_rx    	; pruefen ob Botschaft im Empfangspuffer
				; des SJA1000 ist; ggf. Identifier lesen 
				; und Botschaft in Mailbox uebertragen

	;****** Mailbox 3 nach Botschaft 520 (ZSTG Status) abfragen

	; die soeben eingelesene CAN_Botschaft in BOX 3 auswerten

	; BOX3_C: 	CAN Mailbox 3	Controlbyte
	; BOX3_IH: 	CAN High Byte Botschaftsnumer [HEX]
	; BOX3_IL: 	CAN Low Byte Botschaftsnumer [HEX]
	; BOX3_0:	CAN Botschaft Mailbox 3 	Datenbyte 0
	; BOX3_1:	CAN Botschaft Mailbox 3 	Datenbyte 1
	; BOX3_2:	CAN Botschaft Mailbox 3 	Datenbyte 2
	; BOX3_3:	CAN Botschaft Mailbox 3 	Datenbyte 3
	; BOX3_4:	CAN Botschaft Mailbox 3 	Datenbyte 4
	; BOX3_5:	CAN Botschaft Mailbox 3 	Datenbyte 5
	; BOX3_6:	CAN Botschaft Mailbox 3 	Datenbyte 6
	; BOX3_7:	CAN Botschaft Mailbox 3 	Datenbyte 7

	mov	R0,#BOX3_C		; indirect adressing
	inc	R0			; Basisadresse Mailbox 3
	inc	R0
	inc	R0			; zeigt auf Byte 0

;****** Pruefen ob ZSTG schon Statusmeldung sendet;
;	Dies ist erkennbar wenn der Zaehler != 0 ist 
;	(Initwert = 0, jedoch im Betrieb Ueberlauf von 17 --> 1)	

	mov	ACC,@R0		; hole byte 0 in Akku

checkZSTGstatus:

	jnz	ZSTG_found	; Byte Null = ZSTG_alive Counter

ZSTG_missing:

	djnz	MERK,ini_net_zstg_loop	; decrement Timeout und
					; wiederhole

	mov	A,#LCD_LINE1
	call	instr_out
	mov	DPTR,#MSG701		
	call	print_lcd

	mov	ERROR,#EW_ZSTG_MISSING_INIT
	call	errorcode_out		; Fehlermeldung generieren

	jmp	XSTG_all

	;****** TEXT: ZSTG gefunden

ZSTG_found:
	mov	A,#LCD_LINE1
	call	instr_out
	mov	DPTR,#MSG700		
	call	print_lcd

;	call	sek_1
;	call	sek_1
		
	;****** Timeout erneut setzen und MSTG suchen

	mov	MERK,#TO_NETINI_SEARCH	; Timeoutzeit fuer Suche nach 
					; Partnersteuergeraeten

ini_net_mstg_loop:

	;****** Mailbox 1 nach Botschaft 510 (MSTG Status) abfragen

	; die soeben eingelesene CAN_Botschaft in BOX 1 auswerten

	; BOX1_C: 	CAN Mailbox 1	Controlbyte
	; BOX1_IH: 	CAN High Byte Botschaftsnumer [HEX]
	; BOX1_IL: 	CAN Low Byte Botschaftsnumer [HEX]
	; BOX1_0:	CAN Botschaft Mailbox 1 	Datenbyte 0
	; BOX1_1:	CAN Botschaft Mailbox 1 	Datenbyte 1
	; BOX1_2:	CAN Botschaft Mailbox 1 	Datenbyte 2
	; BOX1_3:	CAN Botschaft Mailbox 1 	Datenbyte 3
	; BOX1_4:	CAN Botschaft Mailbox 1 	Datenbyte 4
	; BOX1_5:	CAN Botschaft Mailbox 1 	Datenbyte 5
	; BOX1_6:	CAN Botschaft Mailbox 1 	Datenbyte 6
	; BOX1_7:	CAN Botschaft Mailbox 1 	Datenbyte 7

	mov	R0,#BOX1_C		; indirect adressing
	inc	R0			; Basisadresse Mailbox 3
	inc	R0
	inc	R0			; zeigt auf Byte 0

;****** Pruefen ob MSTG schon Statusmeldung sendet;
;	Dies ist erkennbar wenn der Zaehler != 0 ist 
;	(Initwert = 0, jedoch im Betrieb Ueberlauf von 17 --> 1)	

	mov	ACC,@R0		; hole byte 0 in Akku

checkMSTGstatus:

	jnz	MSTG_found	; Byte Null = MSTG_alive Counter

MSTG_missing:

	djnz	MERK,ini_net_mstg_loop	; decrement Timeout und
					; wiederhole
	mov	A,#LCD_LINE2
	call	instr_out
	mov	DPTR,#MSG711		
	call	print_lcd

;	mov	ERROR,#EW_MSTG_MISSING_INIT
;	call	errorcode_out		; Fehlermeldung generieren

	jmp	XSTG_all

	;****** TEXT: ZSTG gefunden

MSTG_found:
	mov	A,#LCD_LINE2
	call	instr_out
	mov	DPTR,#MSG710		
	call	print_lcd

XSTG_all:

	mov	A,#LCD_LINE3
	call	instr_out
	mov	DPTR,#MSG000			; loeschen		 
	call	print_lcd

	mov	A,#LCD_LINE4			
	call	instr_out
	mov	DPTR,#MSG000			; loeschen		 
	call	print_lcd

	call	sek_1
;	call	sek_1

	ret

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

