;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 16.09.2000		
;
;	Aenderungen:
;	24_10_00: Vier Zeilen loeschen statt zwei (erweitert fuer neues LCD)
;	05_11_00: BLINKLEDSTOP hierher uebernommen
;	10_06_01: EEPROM Fehlerspeichereintrag implementiert
;	14_06_01: Init-Fehlermeldungen durch BIT05 unterschieden
;	04_05_02: ZSTG_Errormanagement eingefuegt
;	21_08_02: MSTG_Errormanagement eingefuegt
;
;*****************************************************************************

	;****** Ausgabe Fehlercode auf LCD *********************************** 

errorcode_out:

	; NEU: Bei Init-Phase keine Eintraege; Init ist bei BIT05=1

	jb	BIT05,errorcode_end

	;******

	; Dieser Abschnitt hat zur Aufgabe, die Fehlermeldung in Zeile 1 
	; anzuzeigen, egal was gerade losist.
	; dazu: - Modus "Standardausgabe" einschalten
	;       - Tasknummer der Fehlermeldung in Zeile 1 setzen, andere
	; 	  Inhalte eine Zeile nach unten rotieren
	;       - Updateflags aller Zeilen setzen

	clr	LCD_MENU_CONTROL.7	; in Standardmodus schalten
	clr	LCD_MENU_CONTROL.6

	mov	A,#TASKNUMMER_ERROR
	call	task_new_and_rotate	; traegt neue Tasknummer ein
					; rotiert und setzt alle Updateflags

	; Eintragen der Fehlermeldung in den EEPROM Fehlerspeicherplatz, 
	; jedoch nur, wenn der Fehler ungleich des neuesten Eintrages ist.
	; in der Speicherzelle ERROR befindet sich die Fehlernummer.
	
	; lesen des EEPROM Fehlerspeicherplatzes Null

	mov	I2C_ADR_L,#EE_ERRORMEM_0	 ; Adresse des Nutzbytes
	mov	I2C_ID,#EE_ID
	call	read_random			 ; Ergebnis in I2C_DATA

	mov	A,ERROR
	cjne	A,I2C_DATA,new_error
	jmp	errorcode_end		 

new_error:
        ; es liegt ein neuer Fehler vor, eintragen in 
	; Fehlerspeicherplatz Null und alle anderen Fehler rotieren;
	; aelteste Fehlermeldung verwerfen.

	; lese Platz 8 und speichere nach Platz 9
	; lese Platz 7 und speichere nach Platz 8
	; ...
	; lese Platz 0 und speichere nach Platz 1
	; trage neueste Fehlermeldung in Platz 0 ein

	mov	I2C_ID,#EE_ID
	mov	CNT1,#EE_ERRORMEM_LENGTH	; Laenge des EEPROM
						; Fehlerspeichers
	dec	CNT1				; Anzahl "Rotieraktionen"

	mov	I2C_ADR_L,#EE_ERRORMEM_8	; Byte 8
err_loop:
	call	read_random			; lese Byte 8 (in I2C_DATA)
	inc	I2C_ADR_L			; schreibe Byte 9 (aus I2C_DATA)
	call	write_byte
	dec	I2C_ADR_L
	dec	I2C_ADR_L
	djnz	CNT1,err_loop	
	
	; jetzt noch den neuesten Fehler eintragen

	mov	I2C_ADR_L,#EE_ERRORMEM_0	; Byte 0
	mov	I2C_DATA,ERROR			; Fehler eintragen
	call	write_byte
	
errorcode_end:

	ret

	;****** Ausgabe Fehlercode ZSTG ************************************** 

zstg_errorcode_out:
	; Dieser Abschnitt hat zur Aufgabe, die Fehlermeldung in Zeile 1 
	; anzuzeigen, egal was gerade losist.
	; dazu: - Modus "Standardausgabe" einschalten
	;       - Tasknummer der Fehlermeldung in Zeile 1 setzen, andere
	; 	  Inhalte eine Zeile nach unten rotieren
	;       - Updateflags aller Zeilen setzen

	clr	LCD_MENU_CONTROL.7	; in Standardmodus schalten
	clr	LCD_MENU_CONTROL.6

	mov	A,#TASKNUMMER_ERROR_ZSTG
	call	task_new_and_rotate	; traegt neue Tasknummer ein
					; rotiert und setzt alle Updateflags

	; Eintragen der Fehlermeldung in den EEPROM Fehlerspeicherplatz, 
	; jedoch nur, wenn der Fehler ungleich des neuesten Eintrages ist.
	; in der Speicherzelle ERROR befindet sich die Fehlernummer.
	
	; lesen des EEPROM Fehlerspeicherplatzes Null

	mov	I2C_ADR_L,#EE_ERRORMEM_ZSTG_0	 ; Adresse des Nutzbytes
	mov	I2C_ID,#EE_ID
	call	read_random			 ; Ergebnis in I2C_DATA

	mov	A,ERROR
	cjne	A,I2C_DATA,new_error_zstg
	jmp	zstg_errorcode_end		 

new_error_zstg:
        ; es liegt ein neuer Fehler vor, eintragen in 
	; Fehlerspeicherplatz Null und alle anderen Fehler rotieren;
	; aelteste Fehlermeldung verwerfen.

	; Achtung! Fuer ZSTG / MSTG nur vier Plaetze

	; lese Platz 2 und speichere nach Platz 3
	; lese Platz 1 und speichere nach Platz 2
	; lese Platz 0 und speichere nach Platz 1
	; trage neueste Fehlermeldung in Platz 0 ein

	mov	I2C_ID,#EE_ID
	mov	CNT1,#EE_ERRORMEM_LENGTH_ZSTG	; Laenge des EEPROM
						; Fehlerspeichers
	dec	CNT1				; Anzahl "Rotieraktionen"

	mov	I2C_ADR_L,#EE_ERRORMEM_ZSTG_2	; Byte 2
err_loop_zstg:
	call	read_random			; lese Byte 2 (in I2C_DATA)
	inc	I2C_ADR_L			; schreibe Byte 3 (aus I2C_DATA)
	call	write_byte
	dec	I2C_ADR_L
	dec	I2C_ADR_L
	djnz	CNT1,err_loop_zstg	
	
	; jetzt noch den neuesten Fehler eintragen

	mov	I2C_ADR_L,#EE_ERRORMEM_ZSTG_0	; Byte 0
	mov	I2C_DATA,ERROR			; Fehler eintragen
	call	write_byte
	
zstg_errorcode_end:

	ret

	;****** Ausgabe Fehlercode MSTG ************************************** 

mstg_errorcode_out:
	; Dieser Abschnitt hat zur Aufgabe, die Fehlermeldung in Zeile 1 
	; anzuzeigen, egal was gerade losist.
	; dazu: - Modus "Standardausgabe" einschalten
	;       - Tasknummer der Fehlermeldung in Zeile 1 setzen, andere
	; 	  Inhalte eine Zeile nach unten rotieren
	;       - Updateflags aller Zeilen setzen

	clr	LCD_MENU_CONTROL.7	; in Standardmodus schalten
	clr	LCD_MENU_CONTROL.6

	mov	A,#TASKNUMMER_ERROR_MSTG
	call	task_new_and_rotate	; traegt neue Tasknummer ein
					; rotiert und setzt alle Updateflags

	; Eintragen der Fehlermeldung in den EEPROM Fehlerspeicherplatz, 
	; jedoch nur, wenn der Fehler ungleich des neuesten Eintrages ist.
	; in der Speicherzelle ERROR befindet sich die Fehlernummer.
	
	; lesen des EEPROM Fehlerspeicherplatzes Null

	mov	I2C_ADR_L,#EE_ERRORMEM_MSTG_0	 ; Adresse des Nutzbytes
	mov	I2C_ID,#EE_ID
	call	read_random			 ; Ergebnis in I2C_DATA

	mov	A,ERROR
	cjne	A,I2C_DATA,new_error_mstg
	jmp	mstg_errorcode_end		 

new_error_mstg:
        ; es liegt ein neuer Fehler vor, eintragen in 
	; Fehlerspeicherplatz Null und alle anderen Fehler rotieren;
	; aelteste Fehlermeldung verwerfen.

	; Achtung! Fuer ZSTG / MSTG nur vier Plaetze

	; lese Platz 2 und speichere nach Platz 3
	; lese Platz 1 und speichere nach Platz 2
	; lese Platz 0 und speichere nach Platz 1
	; trage neueste Fehlermeldung in Platz 0 ein

	mov	I2C_ID,#EE_ID
	mov	CNT1,#EE_ERRORMEM_LENGTH_MSTG	; Laenge des EEPROM
						; Fehlerspeichers
	dec	CNT1				; Anzahl "Rotieraktionen"

	mov	I2C_ADR_L,#EE_ERRORMEM_MSTG_2	; Byte 2
err_loop_mstg:
	call	read_random			; lese Byte 2 (in I2C_DATA)
	inc	I2C_ADR_L			; schreibe Byte 3 (aus I2C_DATA)
	call	write_byte
	dec	I2C_ADR_L
	dec	I2C_ADR_L
	djnz	CNT1,err_loop_mstg	
	
	; jetzt noch den neuesten Fehler eintragen

	mov	I2C_ADR_L,#EE_ERRORMEM_MSTG_0	; Byte 0
	mov	I2C_DATA,ERROR			; Fehler eintragen
	call	write_byte
	
mstg_errorcode_end:

	ret

	;****** Blink- LED als NOT-STOP ************************************** 

	; wird nach Fehlerausgabe aufgerufen wenn ERRORSTOP- Switch aktiv ist
	; --> ENDLOSSCHLEIFE !!

blinkledstop:	
	mov	CNT0,#0FFH		; Pulsdauer FF/FF = 150 ms
loop0:	nop				; Pulsdauer C0/FF = 115 ms
	mov	CNT1,#0FFH		; Pulsdauer 90/FF =  80 ms
loop1:	nop				; Pulsdauer 60/FF =  55 ms
	djnz	CNT1,loop1		; Pulsdauer 33/FF =  30 ms
	djnz	CNT0,loop0		; Pulsdauer 11/FF =  10 ms
					; Pulsdauer 10/1A =   1 ms
	cpl	LED
	jmp	blinkledstop		; LED toggeln

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

