;*****************************************************************************
; 	All rights reserved by Dipl.-Ing (FH) Andreas Hoeger
;	Ditzenbrunner Str. 64, 71254 Ditzingen, Germany
;	Telefon: (+497156)490980	Telefax: (+497156)490981
;	E-Mail: ingbuero@andreas-hoeger.de
;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 12.11.2000		
;
;	Aenderungen:
;	12_11_00: Neuerstellung 
;	04_03_02: Anpassung an HSTG, nur vier LSBs sind Tastatur
;
;*****************************************************************************
	; Tastenentprellung
	; Voraussetzungen: Die Tasten wurden aktuell eingelesen in IN_TAST
	;		   und invertiert, so da gedrueckt = Bit gesetzt
	; Vorgehensweise:
	; Es darf nur max. eine Taste gedrueckt sein (keine oder eine).
	; Bei mehr Tasten wird der Zaehler geloescht und alles ignoriert.
	; Fuer jede Taste gibt es ein Merkerbit, auch fuer "keine Taste".
	; Ein Zaehler zaehlt die Tastendruecke, kommt was anderes dazwischen
	; wird er zurueckgesetzt. Erst nach einer bestimmten Anzahl gleicher 
	; Tasten wird die Taste durchgeschaltet zum Menue.
	; Nach einer Taste wird eine "keine Taste" Lcke benoetigt um die
	; Tastendruecke voneinander unterscheiden zu koennen.
	; Dafuer gibt es ebenfalls ein Merkerbit "brauche ein NIX".

entprell:	
	; zuerst pruefen ob mehr als eine Taste gedrueckt ist

	mov	R7,#00H			; R7 zaehlt die Anzahl gedrueckter 
					; Tasten
	jnb	IN_TAST.7,nr6
	inc	R7
nr6:	jnb	IN_TAST.6,nr5
	inc	R7
nr5:	jnb	IN_TAST.5,nr4
	inc	R7
nr4:	jnb	IN_TAST.4,nr_end
	inc	R7
	
nr_end:	cjne	R7,#00H,nrx		; wenn R7 == 0: keine Taste gedrueckt
	jmp	keine_Taste
nrx:	dec	R7
	cjne	R7,#00H,zuviel_Tasten	; wenn jetzt == 0 war's eine Taste
	jmp	eine_Taste

zuviel_Tasten:	
	; Prell- Counter und alle Bits loeschen
	mov	PRELL_COUNT,#00H
	mov	PRELL_BITS,#00H
	jmp	eine_end

keine_Taste:
	; hier vorher auf NIX- Bit abfragen, sonst nicht hochzaehlen
	jnb	PRELL_BITS.0,anfang_nix 
					; Taste "nix" im Counter zaehlen
	inc	PRELL_COUNT
	mov	A,PRELL_COUNT		; Zaehlerendwert-Vergleich
	cjne	A,#PRELL_COUNT_MAX,ret_keine_Taste

	clr	PRELL_BITS.1		; Merker loeschen dass eine 
					; gueltige Null hermuss
	jmp	ret_keine_Taste

anfang_nix:
	mov	PRELL_COUNT,#01H	; Zaehlerstand fuer neuen Zustand
	mov	PRELL_BITS,#00H
	setb	PRELL_BITS.0
;	jmp	ret_keine_Taste

ret_keine_Taste:	
	jmp	eine_end

eine_Taste:
	; zuerst vergleichen welche Taste, dann den entsprechenden Counter
	; hochzaehlen
	
eine_7:	jnb	IN_TAST.7,eine_6	; Taste H gedrueckt
	jnb	PRELL_BITS.7,oth_7	; selbe wie letztesmal?
	inc	PRELL_COUNT		; es ist wieder diese Taste H
					; Zaehler erhoehen
	mov	A,PRELL_COUNT
	cjne	A,#PRELL_COUNT_MAX,eine_end_7
	
	; Endwert erreicht, pruefe Merker "brauche jetzt ein NIX"

	jb	PRELL_BITS.1,eine_end_7
	setb	PRELL_BITS.1		; setzen weil jetzt ein NIX noetig
	jmp	gotomenu		; eine gueltige Taste kann durch
					; weil kein NIX noetig

oth_7:	mov	PRELL_COUNT,#01H	; andere Taste als letztesmal,
					; Counter auf eins fuer die
					; neue Taste H
	mov	PRELL_BITS,#00H	
	setb	PRELL_BITS.7		; nur Bit von Taste H setzen
;	jmp	eine_end

eine_end_7:
	jmp	eine_end


eine_6:	jnb	IN_TAST.6,eine_5	; Taste G gedrueckt
	jnb	PRELL_BITS.6,oth_6	; selbe wie letztesmal?
	inc	PRELL_COUNT		; es ist wieder diese Taste G
					; Zaehler erhoehen
	mov	A,PRELL_COUNT
	cjne	A,#PRELL_COUNT_MAX,eine_end_6
	
	; Endwert erreicht, pruefe Merker "brauche jetzt ein NIX"

	jb	PRELL_BITS.1,eine_end_6
	setb	PRELL_BITS.1		; setzen weil jetzt ein NIX noetig
	jmp	gotomenu		; eine gueltige Taste kann durch
					; weil kein NIX noetig
	
oth_6:	mov	PRELL_COUNT,#01H	; andere Taste als letztesmal,
					; Counter auf eins fuer die
					; neue Taste G
	mov	PRELL_BITS,#00H	
	setb	PRELL_BITS.6		; nur Bit von Taste G setzen
;	jmp	eine_end

eine_end_6:
	jmp	eine_end

eine_5:	jnb	IN_TAST.5,eine_4	; Taste F gedrueckt
	jnb	PRELL_BITS.5,oth_5	; selbe wie letztesmal?
	inc	PRELL_COUNT		; es ist wieder diese Taste F
					; Zaehler erhoehen
	mov	A,PRELL_COUNT
	cjne	A,#PRELL_COUNT_MAX,eine_end_5
	
	; Endwert erreicht, pruefe Merker "brauche jetzt ein NIX"

	jb	PRELL_BITS.1,eine_end_5
	setb	PRELL_BITS.1		; setzen weil jetzt ein NIX noetig
	jmp	gotomenu		; eine gueltige Taste kann durch
					; weil kein NIX noetig
	
oth_5:	mov	PRELL_COUNT,#01H	; andere Taste als letztesmal,
					; Counter auf eins fuer die
					; neue Taste F
	mov	PRELL_BITS,#00H	
	setb	PRELL_BITS.5		; nur Bit von Taste F setzen
;	jmp	eine_end

eine_end_5:
	jmp	eine_end

eine_4:	jnb	IN_TAST.4,eine_1	; Taste E gedrueckt
	jnb	PRELL_BITS.4,oth_4	; selbe wie letztesmal?
	inc	PRELL_COUNT		; es ist wieder diese Taste E
					; Zaehler erhoehen
	mov	A,PRELL_COUNT
	cjne	A,#PRELL_COUNT_MAX,eine_end_4
	
	; Endwert erreicht, pruefe Merker "brauche jetzt ein NIX"

	jb	PRELL_BITS.1,eine_end_4
	setb	PRELL_BITS.1		; setzen weil jetzt ein NIX noetig
	jmp	gotomenu		; eine gueltige Taste kann durch
					; weil kein NIX noetig
	
oth_4:	mov	PRELL_COUNT,#01H	; andere Taste als letztesmal,
					; Counter auf eins fuer die
					; neue Taste E
	mov	PRELL_BITS,#00H	
	setb	PRELL_BITS.4		; nur Bit von Taste E setzen
;	jmp	eine_end

eine_end_4:
	jmp	eine_end

eine_1:	mov	ERROR,#EW_TAST_PRELL
	call	errorcode_out		 ; Fehlermeldung generieren
					 ; weil unsinniger Zustand
	jmp	eine_end

gotomenu:
	; mit gesetztem Merker LCD_MENU_CONTROL.5 zurueck
	; die gedrueckte Taste kann in PRELL_BITS[7:4] abgefragt werden

	setb	LCD_MENU_CONTROL.5
	jmp	entprell_end

eine_end:
	; hier Merker setzen fuer "keine gueltige Taste"
	; mit geloeschtem Merker LCD_MENU_CONTROL.5 zurueck

	clr	LCD_MENU_CONTROL.5
;	jmp	entprell_end

entprell_end:

	ret	

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

