;*****************************************************************************
; 	All rights reserved by Dipl.-Ing (FH) Andreas Hoeger
;	Ditzenbrunner Str. 64, 71254 Ditzingen, Germany
;	Telefon: (+497156)490980	Telefax: (+497156)490981
;	E-Mail: ingbuero@andreas-hoeger.de
;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm fuer HSTG, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 03.03.2002		
;
;	Aenderungen:
;	03_03_02: initial version to make HSTG code better
;	23_04_02: default for Standardausgabe in EE eintragen (einmalig)
;	07_05_02: CAN- Datenausgabe Identifier in EE eintragen
; 	18_07_02: EEPROM Ersteinst. zusammengefasst; Bugfix Pageumschaltung
;		  (nur Page 0 beschreiben und mit "internal" Routine)
;	10_11_02: Defaultanzeigen geaendert
;	tt_mm_yy:
;
;*****************************************************************************

	;*********************************************************************
        ; Unterprogramm fr Ersteinstellungen neuer EEPROMs und EEPOTs
	; --> nur aktiv bei eingeschaltetem Compilerswitch
        ;*********************************************************************

ee_new:
	;****** Ersteinstellung EEPOT bei Neuinbetriebnahme ******************
	; EEPOT so einstellen da ca. 1,0V am Schleifer liegt
	; das ist ca. 10 bis 20 Schritte von unten entfernt. 
	; da das EEPOT oben nicht ueberlaeuft, kann zuerst 111 Schritte nach
	; oben (up) gefahren werden und dann 88 herunter (down). 

	IF	EEPOT_NEU

	mov	MERK,#111	; 111 Stufen bis garantiert "oberer Anschlag"	

testup:		; in Richtung "blass" verstellen
	
	call	eepot_up
;	call	sek_1		; nur zum Test (zuschauen)
	dec	MERK
	mov	A,MERK
	jnz	testup	

	mov	MERK,#88	; 88 Stufen herunter	

testdown:	; in Richtung "dunkel" verstellen

	call	eepot_down
;	call	sek_1		; nur zum Test (zuschauen)
	dec	MERK
	mov	A,MERK
	jnz	testdown

	ENDIF

	;****** Eintrag Hardwareversion in EEPROM bei Neuinbetriebnahme ******
	; Hardwareversion hier fest eintragen und Switch aktivieren

	; !! Die Eintraege erfolgen nur in Page 0.
	; Diese wird dann beim Start in die andere Page kopiert
	; (was eine Fehlermeldung erzeugt)

	; ACHTUNG !!  WIRKT ERST NACH ZWEITEM RESET DENN ANZEIGE ERFOLGT
	; AUF LCD SCHON IN SYS_INI (DIESER EINTRAG KOMMT DANACH) !!

	IF	EEPROM_NEU

	;****** Page 0 als gueltige Seite eintragen und danach beschreiben *****
	; EE_VALID_PAGE	--> Page 0

	mov	I2C_ADR_H,#00H			  ; Page 0
	mov	I2C_ID,#EE_ID

	mov	I2C_ADR_L,#EE_VALID_PAGE	  ; Adresse des Nutzbytes
	mov	I2C_DATA,#00H			  ; <--- hier eintragen
	call	write_byte_internal		  ; ohne EE- Pageverwaltung
						  ; aufrufen !!

	;****** Hardwareversion Vorkommastellen im EEPROM ablegen als *******
	; EE_HARDWARE_VERSION_H	--> Page 0

	mov	I2C_ADR_L,#EE_HARDWARE_VERSION_H  ; Adresse des Nutzbytes
	mov	I2C_DATA,#01H			  ; <--- hier eintragen
	call	write_byte_internal		  ; ohne EE- Pageverwaltung
						  ; aufrufen !!

	; Hardwareversion Nachkommastellen im EEPROM ablegen als
	; EE_HARDWARE_VERSION_L	--> Page 0

	mov	I2C_ADR_L,#EE_HARDWARE_VERSION_L  ; Adresse des Nutzbytes
	mov	I2C_DATA,#00H			  ; <--- hier eintragen
	call	write_byte_internal		  ; ohne EE- Pageverwaltung
						  ; aufrufen !!

	;****** Eintrag Defaultwerte in EEPROM bei Neuinbetriebnahme ********
	; Defaultwerte fuer Standardausgabe hier fest eintragen und 
	; Switch aktivieren

	mov	I2C_ADR_L,#EE_MENU_DEF_LINE_1	; Default Zeile 1:
	mov	I2C_DATA,#TASKNUMMER_DCF77	; DCF77
	call	write_byte_internal		; ohne EE- Pageverwaltung
						; aufrufen !!

	mov	I2C_ADR_L,#EE_MENU_DEF_LINE_2	; Default Zeile 2:
	mov	I2C_DATA,#TASKNUMMER_VOLTAMP	; Batterie
	call	write_byte_internal		; ohne EE- Pageverwaltung
						; aufrufen !!

	mov	I2C_ADR_L,#EE_MENU_DEF_LINE_3	; Default Zeile 3:
	mov	I2C_DATA,#TASKNUMMER_OELTEMP	; Oeltemperatur
	call	write_byte_internal		; ohne EE- Pageverwaltung
						; aufrufen !!

	mov	I2C_ADR_L,#EE_MENU_DEF_LINE_4	; Default Zeile 4:
	mov	I2C_DATA,#TASKNUMMER_LLK_TEMP	; Ladelufttemperatur
	call	write_byte_internal		; ohne EE- Pageverwaltung
						; aufrufen !!

	;****** Eintrag ID fuer CAN Datenausgabe bei Neuinbetriebnahme ******
	; Defaultwerte hier fest eintragen und Switch aktivieren

	mov	I2C_ADR_L,#EE_CAN_BOX_SWITCH	; Platz fuer Identifier
	mov	I2C_DATA,#00H			; Kennung eintragen ID 500h
	call	write_byte_internal		; ohne EE- Pageverwaltung
						; aufrufen !!

	mov	I2C_ADR_L,#EE_CAN_BOX_6_L	; Platz fuer Identifier
	mov	I2C_DATA,#00H			; Kennung eintragen ID 500h
	call	write_byte_internal		; ohne EE- Pageverwaltung
						; aufrufen !!

	;****** Eintrag Schaltverhalten Trennrelais  ******
	; Defaultwerte hier fest eintragen und Switch aktivieren

	mov	I2C_ADR_L,#EE_DPLUS_SOWI	; Platz fuer Identifier
	mov	I2C_DATA,#10H			; Kennung eintragen "Winter"
	call	write_byte_internal		; ohne EE- Pageverwaltung
						; aufrufen !!

	ENDIF

	ret			

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

