;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 02.11.2000		
;
;	Aenderungen:
;	02_11_00: Neuerstellung 
;	12_11_00: Switch entfernt fuer Versionen < 1.2
;
;*****************************************************************************

	; Diese Routinen verndern die EEPOT- Einstellung um eine Stufe
	; pro Aufruf und speichern die Position ab.

	; Voraussetzung fuer beide Routinen ist folgendes:
	; LCD nicht gleichzeitig ansteuern oder durcheinander weil der 
	; LCD- Bus mitverwendet wird.
	; erwarteter Ausgangszustand vor der Verstellung:
	; CS/, INC/ und U/D/ sind alle high

	; Bit DB4 entspricht U/D/
	; Bit DB5 entspricht INC/

eepot_up:
	setb	DB4		; Eingangsvoraussetzungen schaffen
	setb	DB5		; Eingangsvoraussetzungen schaffen
				; CS/ sollte high sein (Grundzustand)

	clr	EEPOT_CS	; CS/ des EEPOTS aktivieren
	call	us_50
	; U/D/ hier high lassen
	clr	DB5		; INC/ low ziehen
	call	us_50
	setb	DB5		; INC/ wieder high ziehen
	call	us_50
	setb	EEPOT_CS	; CS/ wieder high und damit auch abspeichern

	call	zehn_ms		; maximale Wartezeit fuer das Abspeichern
				; im EEPROM einhalten
	ret

eepot_down:
	setb	DB4		; Eingangsvoraussetzungen schaffen
	setb	DB5		; Eingangsvoraussetzungen schaffen
				; CS/ sollte high sein (Grundzustand)

	clr	EEPOT_CS	; CS/ des EEPOTS aktivieren
	call	us_50
	clr	DB4		; U/D/ low ziehen
	call	us_50
	clr	DB5		; INC/ low ziehen
	call	us_50
	setb	DB5		; INC/ wieder high ziehen
	call	us_50
	setb	DB4		; U/D/ wieder high ziehen
	call	us_50
	setb	EEPOT_CS	; CS/ wieder high und damit auch abspeichern

	call	zehn_ms		; maximale Wartezeit fuer das Abspeichern
				; im EEPROM einhalten
	ret

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

