;*****************************************************************************
; 	All rights reserved by Dipl.-Ing (FH) Andreas Hoeger
;	Ditzenbrunner Str. 64, 71254 Ditzingen, Germany
;	Telefon: (+497156)490980	Telefax: (+497156)490981
;	E-Mail: ingbuero@andreas-hoeger.de
;*****************************************************************************
;
;       8051- Programm fuer ATMEL Flash- Mikrocontroller AT89S53
;	
;	Teilprogramm fuer HSTG, wird durch INCLUDE eingebunden
;
;       Autor: Andreas Hoeger
;       Datum: 27.10.2000		
;
;	Aenderungen:
;	16_02_02: initial version for HSTG from version 18
;	16_02_02: new CAN TX Timing Definitions
;	18_02_02: CAN Mailbox Zuordnung gemaess Spec
;	28_02_02: HSTG_BITS eingefuehrt
;	03_03_02: TASK_BITS und neue Tasksteuerung eingefuehrt, Stack
;	05_03_02: HZG_COMMAND eingefuehrt
;	11_03_02: defines fuer COMMAND_ZSTG eingefuegt
;	04_04_02: neue Tasknummern und EEPROM Plaetze eingefuegt
;	30_04_02: EE_DPLUS_SOWI eingefuegt, DPLUS_SOMMER, DPLUS_WINTER
;		  Error ZSTG
;	06_05_02: zusaetzliche CAN- mailbox eingefuegt und Definitionen
;		  fuer EEPROM
;	07_05_02: CAN Box Switch eingefuegt
;	11_06_02: Definitionen OUT_SHIFT geaendert
;	18_07_02: EE_DEBUG_CAN_OUT eingefuegt
;	20_07_02: EW_CAN_RX_OVERLOAD, CAN_RX_CALL_TO und CAN_RX_CNT eingefuegt
;	26_07_02: EW_CAN_RX_OVERRUN eingefuegt
;	21_08_02: OLD_MSTG_CNT und TASKNUMMER_ERROR_MSTG eingefuegt
;	25_08_02: TO_NETINI_SEARCH eingefuegt
;	09_09_02: weitere CAN-Mailbox 7 eingefuegt
;	27_09_02: weitere CAN-Mailbox 8 eingefuegt
;	30_09_02: OLD_ZSTG_CNT_1 und OLD_ZSTG_CNT_2 eingefuegt
;	02_10_02: EW_GEBLAESE_PLAUSI eingefuegt
;	03_10_02: POWERDOWN_MSTG_CNT eingefuegt, OLD_MSTG_CNT entfernt
;		  MSTG_OFF_DELAY_CYCLES eingefuegt
;	01_11_02: Acceptance Code and Mask is now used
;	04_03_03: MSTG_OFF_DELAY_CYCLES_PD wegen PowerDown angepasst
;	09_03_03: CAN-sleep eingefuehrt und PD_BITS uns PDBIT0x_DELAY_CYCLES
;	27_07_03: TASKNUMMER_STANDBY eingefuehrt
;	10_08_03: PowerDown Bits umnummeriert (0 bis 7)
;
;
;*****************************************************************************

        DSEG

	;****** 00h bis 1Fh = Registerbaenke 0 bis 3 *************************
	;****** 20h bis 2Fh = bitadressierbarer Bereich **********************

       	ORG     20h

BITS:   	  DS    1      	; Merker- Bits
PD_BITS:	  DS	1	; PowerDown Bits im HSTG

IN_TAST:	  DS	1	; Eingangsdaten von IC2 (Schieberegister)
				; Tastaturdaten (ohne Optokoppler)
IN_OPTO:          DS	1	; Eingangsdaten von IC6 (Schieberegister)
				; Optokoppler- Eingangsdaten
OUT_SHIFT:	  DS	1       ; Datenbyte fr das Ausgangsschieberegister 


LOOPCNT:	  DS	1	; Zaehler fuer Taskschema auf CAN
TASK_BITS:	  DS	1	; Task-Steuerung schaltet aufgrund dieser Bits
	
PRELL_BITS:	  DS	1	; Bits fuer Tasten bei der Entprellung
PRELL_COUNT:	  DS	1	; Entprell-Counter

LCD_MENU_CONTROL: DS	1	; Menue- Kontrollwort und
				; Update- Flags fuer "MenueModus"

LCD_MENU_MODE_NR: DS	1	; Menue- Modenummer 

LCD_DATA_TASK_L1: DS	1	; "ShowdataModus" Tasknummer Zeile 1
				; MSB ist Update-Flag
LCD_DATA_TASK_L2: DS	1	; "ShowdataModus" Tasknummer Zeile 2
				; MSB ist Update-Flag
LCD_DATA_TASK_L3: DS	1	; "ShowdataModus" Tasknummer Zeile 3
				; MSB ist Update-Flag
LCD_DATA_TASK_L4: DS	1	; "ShowdataModus" Tasknummer Zeile 4
				; MSB ist Update-Flag

LCD_XDATA_TASK:   DS	1	; "SonderdatenModus" Tasknummer
				; MSB ist Update-Flag

	;****** 30h bis 3Fh = Allzweckbytes **********************************

	ORG	30h

CNT0:		DS	1	; Counter- Byte 0
CNT1:		DS	1	; Counter- Byte 1
CNT2: 		DS	1	; Counter- Byte 2

MERK:		DS	1	; Allzweckmerker

TEMP_H:		DS	1	; Temperatur-Ergebnis vom DS1621, high byte
TEMP_L: 	DS	1	; Temperatur-Ergebnis vom DS1621, low byte
TEMP_DEZ_H:	DS	1	; Hunderterstelle
TEMP_DEZ_Z:	DS	1	; Zehnerstelle

ASCII_H:	DS	1	; ASCII- Zeichen, HIGH- Teil eines Hexwerts
ASCII_L:	DS	1	; ASCII- Zeichen, LOW- Teil eines Hexwerts

I2C_ADR_H:	DS	1	; oberer Teil der Bit- Adresse im EEPROM
I2C_ADR_L:	DS	1	; unterer Teil der Bit- Adresse im EEPROM
I2C_ID:		DS	1	; Device- ID des Bausteines
I2C_DATA:	DS	1	; (erstes) Datenbyte vom I2C- Bus
I2C_DATA_2:	DS	1	; zweites Datenbyte vom I2C- Bus

ERROR:		DS	1	; Fehlercode

	;****** 40h bis 4Fh = CAN- Sende- Puffer & sonstiges fuer CAN ********

	ORG	40h

CAN_I1:	DS	1		; CAN Botschaft Identifier Byte 1
CAN_I2:	DS	1		; CAN Botschaft Identifier Byte 1
CAN_D0:	DS	1		; CAN Botschaft Datenbyte 0
CAN_D1:	DS	1		; CAN Botschaft Datenbyte 1
CAN_D2:	DS	1		; CAN Botschaft Datenbyte 2
CAN_D3:	DS	1		; CAN Botschaft Datenbyte 3
CAN_D4:	DS	1		; CAN Botschaft Datenbyte 4
CAN_D5:	DS	1		; CAN Botschaft Datenbyte 5
CAN_D6:	DS	1		; CAN Botschaft Datenbyte 6
CAN_D7:	DS	1		; CAN Botschaft Datenbyte 7
	
CAN_ADR:	DS	1	; CAN Adresse fuer Read Byte/ Write Byte
CAN_DAT: 	DS	1	; CAN Daten fuer Read Byte/ Write Byte

CAN_SORT_MERKID1: DS	1	; Allgemeiner Merker fr ID-Extraktion
CAN_SORT_MERKID2: DS	1	; Allgemeiner Merker fr ID-Extraktion
CAN_SORT_ID1:	  DS	1	; Ident. der Botschaft fr RX- Routine
CAN_SORT_ID2:	  DS	1	; Ident. der Botschaft fr RX- Routine

	;****** 50h bis 5Fh = Merker fr Funktionen EIN / AUS ber CAN ********

	ORG	50h

OLD_ZSTG_CNT:	DS	1	; old ALIVE cnt; Plausibilisierung ZSTG lebt
OLD_ZSTG_CNT_1:	DS	1	
OLD_ZSTG_CNT_2:	DS	1

OLD_MSTG_CNT:	DS	1	; old ALIVE cnt; Plausibilisierung MSTG lebt
OLD_MSTG_CNT_1:	DS	1	
OLD_MSTG_CNT_2:	DS	1


POWERDOWN_CNT:	DS	1	; Abschaltverzoegerung PowerDown

HZG_COMMAND:	DS	1	; Kommando an Standheizung

COMMAND_ZSTG_1:	DS	1	; CAN 504 (Kommandos an ZSTG)

COMMAND_MSTG_1:	DS	1	; CAN 505 (Kommandos an MSTG)


; hier weitere einfuegen

CAN_BOX_SWITCH:	DS	1	; CAN Mailbox Identifier fuer CAN Datenausgabe
CAN_BOX_6_L:	DS	1	; Identifier Mailbox 6 Low Teil
				; High Teil immer fuer Botschaft 5xxh

EE_DEBUG_CAN_OUT: DS	1	; Counter fuer EEPROM Page 0 Inhalte auf CAN
CAN_RX_CNT_1:	DS	1	; Counter fuer CAN RX Routinen-Timeout
CAN_RX_CNT_2:	DS	1	; Counter fuer CAN RX Routinen-Timeout

	;****** 60h bis 7Fh = Stack ** Stack incrementiert ********************

        ORG     60h

;STACK:  	DS      20h     ; Stack definieren von 60h bis 80h
STACK:    	DS      8h      ; Stack definieren von 60h bis 80h
STACK_1:  	DS      8h      ; Stack definieren von 60h bis 80h
STACK_2:  	DS      8h      ; Stack definieren von 60h bis 80h
STACK_3:  	DS      5h      ; Stack definieren von 60h bis 80h
STACK_END_MARK: DS	1	; Endemarkierung fr Overflowerkennung
; reserve	DS	1
; reserve	DS  	1


	;****** von 80h bis FFH oberer RAM Bereich parallel zu SFRs **********
	;****** --> beachte Adressierungsart, sie whlt den Bereich **********
	;****** --> "direct adressing" spricht SFRs an (mov 0A0H #data) ******
	;****** --> "indirect adressing" spricht RAM an (mov @R0, #data) *****

	ORG	80h
	; 16- Bit- Adressmerker fuer LCD- Ausgabetask (Ersatz fuer DPTR)

MENU_LINE1_POINT_H:	DS	1	; Zeile 1, high
MENU_LINE1_POINT_L:	DS	1	; Zeile 1, low

MENU_LINE2_POINT_H:	DS	1	; Zeile 2, high
MENU_LINE2_POINT_L:	DS	1	; Zeile 2, low

MENU_LINE3_POINT_H:	DS	1	; Zeile 3, high
MENU_LINE3_POINT_L:	DS	1	; Zeile 3, low

MENU_LINE4_POINT_H:	DS	1	; Zeile 4, high
MENU_LINE4_POINT_L:	DS	1	; Zeile 4, low

	ORG	90h
	; pro empfangene (wichtige) Botschaft eine Mailbox anlegen mit
	; 8 Datenbytes und einem Kontrollwort
	; Kontrollwoerter am Anfang

BOX0_C:	DS	1		; CAN Mailbox 0 Controlbyte
BOX0_IH: DS	1		; CAN High Byte Botschaftsnumer [HEX]
BOX0_IL: DS	1		; CAN Low Byte Botschaftsnumer [HEX]
BOX0_0:	DS	1		; CAN Botschaft Mailbox 0 	Datenbyte 0
BOX0_1:	DS	1		; CAN Botschaft Mailbox 0 	Datenbyte 1
BOX0_2:	DS	1		; CAN Botschaft Mailbox 0 	Datenbyte 2
BOX0_3:	DS	1		; CAN Botschaft Mailbox 0 	Datenbyte 3
BOX0_4:	DS	1		; CAN Botschaft Mailbox 0 	Datenbyte 4
BOX0_5:	DS	1		; CAN Botschaft Mailbox 0 	Datenbyte 5
BOX0_6:	DS	1		; CAN Botschaft Mailbox 0 	Datenbyte 6
BOX0_7:	DS	1		; CAN Botschaft Mailbox 0 	Datenbyte 7

BOX1_C:	DS	1		; CAN Mailbox 1	Controlbyte
BOX1_IH: DS	1		; CAN High Byte Botschaftsnumer [HEX]
BOX1_IL: DS	1		; CAN Low Byte Botschaftsnumer [HEX]
BOX1_0:	DS	1		; CAN Botschaft Mailbox 1 	Datenbyte 0
BOX1_1:	DS	1		; CAN Botschaft Mailbox 1 	Datenbyte 1
BOX1_2:	DS	1		; CAN Botschaft Mailbox 1 	Datenbyte 2
BOX1_3:	DS	1		; CAN Botschaft Mailbox 1 	Datenbyte 3
BOX1_4:	DS	1		; CAN Botschaft Mailbox 1 	Datenbyte 4
BOX1_5:	DS	1		; CAN Botschaft Mailbox 1 	Datenbyte 5
BOX1_6:	DS	1		; CAN Botschaft Mailbox 1 	Datenbyte 6
BOX1_7:	DS	1		; CAN Botschaft Mailbox 1 	Datenbyte 7

BOX2_C:	DS	1		; CAN Mailbox 2	Controlbyte
BOX2_IH: DS	1		; CAN High Byte Botschaftsnumer [HEX]
BOX2_IL: DS	1		; CAN Low Byte Botschaftsnumer [HEX]
BOX2_0:	DS	1		; CAN Botschaft Mailbox 2 	Datenbyte 0
BOX2_1:	DS	1		; CAN Botschaft Mailbox 2 	Datenbyte 1
BOX2_2:	DS	1		; CAN Botschaft Mailbox 2 	Datenbyte 2
BOX2_3:	DS	1		; CAN Botschaft Mailbox 2 	Datenbyte 3
BOX2_4:	DS	1		; CAN Botschaft Mailbox 2 	Datenbyte 4
BOX2_5:	DS	1		; CAN Botschaft Mailbox 2 	Datenbyte 5
BOX2_6:	DS	1		; CAN Botschaft Mailbox 2 	Datenbyte 6
BOX2_7:	DS	1		; CAN Botschaft Mailbox 2 	Datenbyte 7

BOX3_C:	DS	1		; CAN Mailbox 3	Controlbyte
BOX3_IH: DS	1		; CAN High Byte Botschaftsnumer [HEX]
BOX3_IL: DS	1		; CAN Low Byte Botschaftsnumer [HEX]
BOX3_0:	DS	1		; CAN Botschaft Mailbox 3 	Datenbyte 0
BOX3_1:	DS	1		; CAN Botschaft Mailbox 3 	Datenbyte 1
BOX3_2:	DS	1		; CAN Botschaft Mailbox 3 	Datenbyte 2
BOX3_3:	DS	1		; CAN Botschaft Mailbox 3 	Datenbyte 3
BOX3_4:	DS	1		; CAN Botschaft Mailbox 3 	Datenbyte 4
BOX3_5:	DS	1		; CAN Botschaft Mailbox 3 	Datenbyte 5
BOX3_6:	DS	1		; CAN Botschaft Mailbox 3 	Datenbyte 6
BOX3_7:	DS	1		; CAN Botschaft Mailbox 3 	Datenbyte 7

BOX4_C:	DS	1		; CAN Mailbox 4	Controlbyte
BOX4_IH: DS	1		; CAN High Byte Botschaftsnumer [HEX]
BOX4_IL: DS	1		; CAN Low Byte Botschaftsnumer [HEX]
BOX4_0:	DS	1		; CAN Botschaft Mailbox 4 	Datenbyte 0
BOX4_1:	DS	1		; CAN Botschaft Mailbox 4 	Datenbyte 1
BOX4_2:	DS	1		; CAN Botschaft Mailbox 4 	Datenbyte 2
BOX4_3:	DS	1		; CAN Botschaft Mailbox 4 	Datenbyte 3
BOX4_4:	DS	1		; CAN Botschaft Mailbox 4 	Datenbyte 4
BOX4_5:	DS	1		; CAN Botschaft Mailbox 4 	Datenbyte 5
BOX4_6:	DS	1		; CAN Botschaft Mailbox 4 	Datenbyte 6
BOX4_7:	DS	1		; CAN Botschaft Mailbox 4 	Datenbyte 7

BOX5_C:	DS	1		; CAN Mailbox 5	Controlbyte
BOX5_IH: DS	1		; CAN High Byte Botschaftsnumer [HEX]
BOX5_IL: DS	1		; CAN Low Byte Botschaftsnumer [HEX]
BOX5_0:	DS	1		; CAN Botschaft Mailbox 5 	Datenbyte 0
BOX5_1:	DS	1		; CAN Botschaft Mailbox 5 	Datenbyte 1
BOX5_2:	DS	1		; CAN Botschaft Mailbox 5 	Datenbyte 2
BOX5_3:	DS	1		; CAN Botschaft Mailbox 5 	Datenbyte 3
BOX5_4:	DS	1		; CAN Botschaft Mailbox 5 	Datenbyte 4
BOX5_5:	DS	1		; CAN Botschaft Mailbox 5 	Datenbyte 5
BOX5_6:	DS	1		; CAN Botschaft Mailbox 5 	Datenbyte 6
BOX5_7:	DS	1		; CAN Botschaft Mailbox 5 	Datenbyte 7

BOX6_C:	DS	1		; CAN Mailbox 6	Controlbyte
BOX6_IH: DS	1		; CAN High Byte Botschaftsnumer [HEX]
BOX6_IL: DS	1		; CAN Low Byte Botschaftsnumer [HEX]
BOX6_0:	DS	1		; CAN Botschaft Mailbox 6 	Datenbyte 0
BOX6_1:	DS	1		; CAN Botschaft Mailbox 6 	Datenbyte 1
BOX6_2:	DS	1		; CAN Botschaft Mailbox 6 	Datenbyte 2
BOX6_3:	DS	1		; CAN Botschaft Mailbox 6 	Datenbyte 3
BOX6_4:	DS	1		; CAN Botschaft Mailbox 6 	Datenbyte 4
BOX6_5:	DS	1		; CAN Botschaft Mailbox 6 	Datenbyte 5
BOX6_6:	DS	1		; CAN Botschaft Mailbox 6 	Datenbyte 6
BOX6_7:	DS	1		; CAN Botschaft Mailbox 6 	Datenbyte 7

BOX7_C:	DS	1		; CAN Mailbox 7	Controlbyte
BOX7_IH: DS	1		; CAN High Byte Botschaftsnumer [HEX]
BOX7_IL: DS	1		; CAN Low Byte Botschaftsnumer [HEX]
BOX7_0:	DS	1		; CAN Botschaft Mailbox 7 	Datenbyte 0
BOX7_1:	DS	1		; CAN Botschaft Mailbox 7 	Datenbyte 1
BOX7_2:	DS	1		; CAN Botschaft Mailbox 7 	Datenbyte 2
BOX7_3:	DS	1		; CAN Botschaft Mailbox 7 	Datenbyte 3
BOX7_4:	DS	1		; CAN Botschaft Mailbox 7 	Datenbyte 4
BOX7_5:	DS	1		; CAN Botschaft Mailbox 7 	Datenbyte 5
BOX7_6:	DS	1		; CAN Botschaft Mailbox 7 	Datenbyte 6
BOX7_7:	DS	1		; CAN Botschaft Mailbox 7 	Datenbyte 7

BOX8_C:	DS	1		; CAN Mailbox 8	Controlbyte
BOX8_IH: DS	1		; CAN High Byte Botschaftsnumer [HEX]
BOX8_IL: DS	1		; CAN Low Byte Botschaftsnumer [HEX]
BOX8_0:	DS	1		; CAN Botschaft Mailbox 8 	Datenbyte 0
BOX8_1:	DS	1		; CAN Botschaft Mailbox 8 	Datenbyte 1
BOX8_2:	DS	1		; CAN Botschaft Mailbox 8 	Datenbyte 2
BOX8_3:	DS	1		; CAN Botschaft Mailbox 8 	Datenbyte 3
BOX8_4:	DS	1		; CAN Botschaft Mailbox 8 	Datenbyte 4
BOX8_5:	DS	1		; CAN Botschaft Mailbox 8 	Datenbyte 5
BOX8_6:	DS	1		; CAN Botschaft Mailbox 8 	Datenbyte 6
BOX8_7:	DS	1		; CAN Botschaft Mailbox 8 	Datenbyte 7

	;****** Definitionen Allzweck- Speicherbits **************************

BIT00	BIT	BITS.0
BIT01   BIT     BITS.1                 
BIT02   BIT     BITS.2                 
BIT03   BIT     BITS.3                 
BIT04   BIT     BITS.4                 
BIT05   BIT     BITS.5                 
BIT06   BIT     BITS.6
BIT07   BIT     BITS.7 

PD_BIT00	BIT	PD_BITS.0    
PD_BIT01	BIT	PD_BITS.1    
PD_BIT02	BIT	PD_BITS.2    
PD_BIT03	BIT	PD_BITS.3    
PD_BIT04	BIT	PD_BITS.4    
PD_BIT05	BIT	PD_BITS.5    
PD_BIT06	BIT	PD_BITS.6    
PD_BIT07	BIT	PD_BITS.7    
	
	;****** Definitionen fuer I2C- Bus (EEPROM, DS1621) ******************

SCL		BIT	p3.1		; serial clock
SDA		BIT	p3.0		; serial data

;PSIZE		EQU	16		; Pagesize bei AT24C04 EEPROM
EESIZE		EQU	512		; Anzahl Bytes bei AT24C04 EEPROM
EE_ID		EQU	0A0H		; EEPROM Device-Address (1010 00XX)

DS_ID		EQU	90H		; DS1621 Device-Address (1001_000X)

DS_READ_TEMP	EQU	0AAH		; Command "read temperature"
DS_START_CON	EQU	0EEH		; Command "initiate temp conversion"
DS_STOP_CON	EQU	22H		; Command "stop temp conversion"
DS_CONFIG	EQU	0ACH		; Command "access configuration reg"
DS_TH		EQU	0A1H		; Command "access TH- Register"
DS_TL		EQU	0A2H		; Command "access TL- Register"	

DS_CON_INIT	EQU	8AH		; Initwert Config-Register
					; Bit 7: DONE- Flag  = 1 = ready
					; Bit 6: TH Flag     = 0 = temp>=TH
					; Bit 5: TL Flag     = 0 = temp<=TL
					; Bit 4: NVB	     = 0 = EE ready
					; Bit 3 und 2: 	     = 10 (hardwired)
					; Bit 1: POL	     = 1 = active H
					; Bit 0: 1SHOT	     = 0 = continuous

DS_TH_INIT	EQU	05H		; Thermostat +5C
DS_TL_INIT	EQU	03H		; Thermostat +3C

	;****** Definitionen fuer EEPROM- Speicherplatzverwaltung ************

	; Das EEPROM 24C04 hat 4k Bit Speicherplatz, aufgeteilt in 512 Bytes
	; Fuer 512 benoetigt man 9 Adressbits oder man betrachtet das EE 
	; mit 8 bit Adresse (256 Bytes) *2, durch bit 9 = Pageumschaltung

	; Es werden zunaechst 256 Adressen vergeben, diese sind aus
	; Datensicherheitsgruenden zweimal vorhanden

	; Page 0: I2C_ADR_H bleibt immer 00H
	;         unten angegeben Werte in I2C_ADR_L laden

EE_HARDWARE_VERSION_H	EQU	00H	; Version der Hardware (Vorkomma)
EE_HARDWARE_VERSION_L	EQU	01H	; Version der Hardware (Nachkomma)

	;******

EE_TEMP_H_OLD		EQU	10H	; Temperaturwert TEMP_H wird hier 
					; abgelegt, um Tendenz zu ermitteln
EE_TEMP_MAX		EQU	11H	; Maximaltemperatur 
					; (bis zum Ruecksetzen)
EE_TEMP_MIN		EQU	12H	; Minimaltemperatur 
					; (bis zum Ruecksetzen)
EE_MENU_STD_LINE_1	EQU	30H	; Tasknummer Standardausgabe Zeile 1
EE_MENU_STD_LINE_2	EQU	31H	; Tasknummer Standardausgabe Zeile 2
EE_MENU_STD_LINE_3	EQU	32H	; Tasknummer Standardausgabe Zeile 3
EE_MENU_STD_LINE_4	EQU	33H	; Tasknummer Standardausgabe Zeile 4

EE_MENU_DEF_LINE_1	EQU	40H	; Tasknummer Defaultausgabe Zeile 1
EE_MENU_DEF_LINE_2	EQU	41H	; Tasknummer Defaultausgabe Zeile 2
EE_MENU_DEF_LINE_3	EQU	42H	; Tasknummer Defaultausgabe Zeile 3
EE_MENU_DEF_LINE_4	EQU	43H	; Tasknummer Defaultausgabe Zeile 4

EE_CAN_BOX_6_L		EQU	4EH	; CAN- Datenausgabe- Identifier RX Box 6
EE_CAN_BOX_SWITCH	EQU	4FH	; CAN- Datenausgabe- Botschaft Auswahl
EE_DPLUS_SOWI		EQU	50H	; Speicherplatz D+ 
					; Schaltverhalten Trennrelais

; Achtung! Fehlerspeicher loeschen beginnt hier und macht Laenge 
; EE_ERRORMEM_LENGTH_ZSTG + EE_ERRORMEM_LENGTH_MSTG + EE_ERRORMEM_LENGTH
EE_ERRORMEM_ZSTG_0	EQU	0E8H	; Fehlerspeicherplatz 0 (ZSTG)
					; --> neuester Eintrag
EE_ERRORMEM_ZSTG_1	EQU	0E9H	; Fehlerspeicherplatz 1
EE_ERRORMEM_ZSTG_2	EQU	0EAH	; Fehlerspeicherplatz 1
EE_ERRORMEM_ZSTG_3	EQU	0EBH	; Fehlerspeicherplatz 1


EE_ERRORMEM_MSTG_0	EQU	0ECH	; Fehlerspeicherplatz 1 (MSTG)
					; --> neuester Eintrag 
EE_ERRORMEM_MSTG_1	EQU	0EDH	; Fehlerspeicherplatz 1
EE_ERRORMEM_MSTG_2	EQU	0EEH	; Fehlerspeicherplatz 1
EE_ERRORMEM_MSTG_3	EQU	0EFH	; Fehlerspeicherplatz 1


EE_ERRORMEM_0		EQU	0F0H	; Fehlerspeicherplatz 0 
					; --> neuester Eintrag
EE_ERRORMEM_1		EQU	0F1H	; Fehlerspeicherplatz 1 
EE_ERRORMEM_2		EQU	0F2H	; Fehlerspeicherplatz 2 
EE_ERRORMEM_3		EQU	0F3H	; Fehlerspeicherplatz 3 
EE_ERRORMEM_4		EQU	0F4H	; Fehlerspeicherplatz 4 
EE_ERRORMEM_5		EQU	0F5H	; Fehlerspeicherplatz 5 
EE_ERRORMEM_6		EQU	0F6H	; Fehlerspeicherplatz 6 
EE_ERRORMEM_7		EQU	0F7H	; Fehlerspeicherplatz 7 
EE_ERRORMEM_8		EQU	0F8H	; Fehlerspeicherplatz 8
EE_ERRORMEM_9		EQU	0F9H	; Fehlerspeicherplatz 9 
 

EE_VALID_PAGE		EQU	0FFH	; Gueltige Seite bei doppelter Ablage
					; der Daten

	;****** Definition Fehlerspeicherlaenge ******************************

EE_ERRORMEM_LENGTH	EQU	 0AH	; Laenge des Fehlerspeichers im EEPROM
					; fuer HSTG
EE_ERRORMEM_LENGTH_ZSTG	EQU	 04H	; Laenge des Fehlerspeichers im EEPROM
					; fuer ZSTG
EE_ERRORMEM_LENGTH_MSTG EQU	 04H	; Laenge des Fehlerspeichers im EEPROM
					; fuer MSTG

EE_DOUBLE_DATA_LENGTH	EQU	0FEH	; Laenge der doppelt abgelegten Daten

	;****** Definitionen fuer CAN- Controller ****************************

CAN_ALE	BIT	p3.4			; ALE / AS
CAN_CS	BIT	p3.5			; CS/
CAN_RD	BIT	p3.6			; RD/E
CAN_WR	BIT	p3.7			; WR/

CAN_ADR_CR	EQU	00H		; Adresse Control Register (CR) 
CAN_ADR_CMR	EQU	01H		; Adresse Command Register (CMR)
CAN_ADR_SR	EQU	02H		; Adresse Status Register (SR)
CAN_ADR_IR	EQU	03H		; Adresse Interrupt Register (IR)
CAN_ADR_ACR	EQU	04H		; Adresse Acceptance Code (ACR)
CAN_ADR_AMR	EQU	05H		; Adresse Acceptance Mask (AMR)
CAN_ADR_BTR0	EQU	06H		; Adresse Bus Timing Reg 0 (BTR0)
CAN_ADR_BTR1	EQU	07H		; Adresse Bus Timing Reg 1 (BTR1)
CAN_ADR_OCR	EQU	08H		; Adresse Output Control (OCR)

CAN_ADR_I1_TX	EQU	0AH		; Adresse Ident High Byte (send)
CAN_ADR_I2_TX	EQU	0BH		; Adresse Ident Low Byte (send)
CAN_ADR_D0_TX	EQU	0CH		; Basisadresse 8 Datenbytes (send)
CAN_ADR_D1_TX	EQU	0DH		; Datenbyte (send)
CAN_ADR_D2_TX	EQU	0EH		; Datenbyte (send)
CAN_ADR_D3_TX	EQU	0FH		; Datenbyte (send)
CAN_ADR_D4_TX	EQU	10H		; Datenbyte (send)
CAN_ADR_D5_TX	EQU	11H		; Datenbyte (send)
CAN_ADR_D6_TX	EQU	12H		; Datenbyte (send)
CAN_ADR_D7_TX	EQU	13H		; Datenbyte (send)

CAN_ADR_I1_RX	EQU	14H		; Adresse Ident High Byte (receive)
CAN_ADR_I2_RX	EQU	15H		; Adresse Ident Low Byte (receive)
CAN_ADR_D0_RX	EQU	16H		; Basisadresse 8 Datenbytes (receive)
CAN_ADR_D1_RX	EQU	17H		; Datenbyte (receive)
CAN_ADR_D2_RX	EQU	18H		; Datenbyte (receive)
CAN_ADR_D3_RX	EQU	19H		; Datenbyte (receive)
CAN_ADR_D4_RX	EQU	1AH		; Datenbyte (receive)
CAN_ADR_D5_RX	EQU	1BH		; Datenbyte (receive)
CAN_ADR_D6_RX	EQU	1CH		; Datenbyte (receive)
CAN_ADR_D7_RX	EQU	1DH		; Datenbyte (receive)

CAN_ADR_CDR	EQU	1FH		; Adresse Clock Divider Register (CDR)

CAN_INI_CR	EQU	21H		; Initwert CAN Controllregister
CAN_INI_CMR	EQU	08H		; Initwert CAN Commandregister
CAN_INI_BTR0	EQU	80H		; Initwert CAN Bus Timing Register 0
CAN_INI_BTR1	EQU	49H		; Initwert CAN Bus Timing Register 1
CAN_INI_ACR	EQU	0A0H		; Initwert CAN Acceptance Code
CAN_INI_AMR	EQU	07H		; Initwert CAN Acceptance Mask
CAN_INI_OCR	EQU	0FAH		; Initwert CAN Output Control Register
CAN_INI_CDR	EQU	40H		; Initwert CAN Clock Divider Register	

CAN_CR_OPMODE	EQU	0FEH	; UND     Reset-Mode aufheben und in OP-Mode
					; umschalten nach der Initialisierung
					; durch loeschen von Bit 0
;CAN_CR_INTEN	EQU	1AH	; ODER	; schaltet RX, Error und Overrun frei
					; Bit 1: RX- Interrupt
					; Bit 2: TX- Interrupt
					; Bit 3: Error Interrupt
					; Bit 4: Overrun Interrupt
CAN_CMR_TXREQ	EQU	01H	; ODER	  Transmit-Request setzen um Botschaft
					; abzusenden
CAN_CMR_RXREL	EQU	04H	; ODER	  Release Receive Buffer- Bit setzen

CAN_CMR_CLROVR	EQU	08H	; ODER	  Clear Data Overrun Flag

CAN_CMR_SLEEP		EQU	10H	; HART	  Aktiviere Sleep Mode
CAN_CMR_SLEEP_END	EQU	00H	; HART	  Deaktiviere Sleep Mode

	; Zuordnung CAN- Mailboxen zu den Botschaftsnummern

; BOX 0 ist fuer undefinierte Kennungen vorgesehen (default)

CAN_BOX_1_H	EQU	05H	; Box 1 = Botschaft 510H (STATUS 1 MSTG)
CAN_BOX_1_L	EQU	10H		

CAN_BOX_2_H	EQU	05H	; Box 2 = Botschaft 511H (Standheizung MSTG)
CAN_BOX_2_L	EQU	11H	

CAN_BOX_3_H	EQU	05H	; Box 3 = Botschaft 520H (STATUS 1 ZSTG)
CAN_BOX_3_L	EQU	20H	

CAN_BOX_4_H	EQU	05H	; Box 4 = Botschaft 521H (DCF77 Daten)
CAN_BOX_4_L	EQU	21H	

CAN_BOX_5_H	EQU	05H	; Box 5 = Botschaft 512H (MSTG Sensor HEX-Data)
CAN_BOX_5_L	EQU	12H	

; Mailbox 6 LOW wird dynamisch ber Menue eingestellt fuer CAN- Datenausgabe
; immer 5xxh Identifier
CAN_BOX_6_H	EQU	05H	; Box 6 = Botschaft 5xxH (CAN- Ausgabe- Daten)
;CAN_BOX_6_L	EQU	xxH

CAN_BOX_7_H	EQU	05H	; Box 7 = Botschaft 513H (MSTG Sensor ASCII-Data)
CAN_BOX_7_L	EQU	13H	

CAN_BOX_8_H	EQU	05H	; Box 8 = Botschaft 522H (ZSTG Sensor ASCII-Data)
CAN_BOX_8_L	EQU	22H	

; Rx Routinen Aufruf-Timeout

CAN_RX_CALL_TO	   EQU	10H	; Maximale Anzahl CAN-Buffer auslesen	
CAN_RX_CALL_TO_PD  EQU  20H	; Maximale Anzahl CAN-Buffer auselsen
				; um zu erreichen dass CAN-Controller-RX-Int
				; weggenommen wird

	;****** Definitionen fuer LCD (20 Zeichen, 2 oder 4 Zeilen) **********

DB4		BIT	p2.0		; 4-Bit-Datenbus LSB
DB5		BIT	p2.1		; 4-Bit-Datenbus
DB6		BIT	p2.2		; 4-Bit-Datenbus
DB7		BIT	p2.3		; 4-Bit-Datenbus MSB

LCD_E		BIT	p2.4		; LCD enable
LCD_RW		BIT	p2.5		; LCD read/write
LCD_RS		BIT	p2.6		; LCD register select

LCD_IX		EQU	83H		; LCD- Init Befehl 1,2 und 3
LCD_I4		EQU	82H		; LCD- Init Befehl 4
					; setzt 4-Bit-Mode
LCD_I5		EQU	82H		; LCD- Init Befehl 5
LCD_I5A		EQU	8CH		; LCD- Init Befehl 5a
					; setzt Matrixformat
LCD_I6		EQU	80H		; LCD- Init Befehl 6
LCD_I6A		EQU	88H		; LCD- Init Befehl 6a
					; display off, cursor off, blink off
LCD_I7		EQU	80H		; LCD- Init Befehl 7
LCD_I7A		EQU	8CH		; LCD- Init Befehl 7a
					; display on, cursor off, no blink
LCD_I8		EQU	80H		; LCD- Init Befehl 8
LCD_I8A		EQU	86H		; LCD- Init Befehl 8a
					; cursor move right, no shift

LCD_LINE1	EQU	80H		; Befehl: Beginn 1.Zeile (00H - 13H)
					; 1XXX XXXX mit X = Adresse
					; entspricht DDRAM address set
LCD_LINE2	EQU	0C0H		; Befehl: Beginn 2.Zeile (40H - 53H)
LCD_LINE3	EQU	94H		; Befehl: Beginn 3.Zeile (14H - 27H)
LCD_LINE4	EQU	0D4H		; Befehl: Beginn 4.Zeile (54H - 67H)

RS_MASK		EQU	01000000b	; setze RS
CG_ADDR		EQU	01000000b	; macht Adresse zur CGRAM Adresse (OR)
					; 01XXXXXX
DD_ADDR		EQU	10000000b	; macht Adresse zur DDRAM Adresse (OR)
					; 10XXXXXX

	;****** Definitionen fuer digital Inputs *****************************

DIG_SH		BIT	p1.0		; digital I/O, Shift/Load Schiebereg.
DIG_CLK		BIT	p1.1		; digital I/O, Schiebetakt
DIG_QH6_2	BIT	p1.2		; digital I/O, Eingang von IC6 und IC2
DIG_DS		BIT	p1.3		; digital I/O, DS vom Ausgabe- SR

	;****** Definitionen fuer Schaltverhalten D+ *************************

	; Einstellung Sommer = 42h
	; Einstellung Winter = 10h

DPLUS_SOMMER	EQU	42H	; Einstellung D+ auf Sommer
DPLUS_WINTER	EQU	10H	; Einstellung D+ auf Winter

	;****** Definitionen fuer Standheizungstask **************************

	; Geblaese Stufe 1 ein = 01h
	; Geblaese Stufe 1 aus = 00h

GEBLAESE_SET	EQU	01H	; Lueftung Stufe 1 ein
;GEBLAESE_CLR	EQU	00H	; Lueftung Stufe 1 aus

	;****** Definitionen fuer digital Outputs ****************************
	; ueber Schieberegister fuer Maskierung OUT_SHIFT
	
	; Bit 0 = ...
	; Bit 1 = ...
	; Bit 2 = ...
	; Bit 3 = Geblaese Stufe 1 Webasto

OUT_HEIZLUFT_SET EQU	08H	; ODER	  Lueftung Stufe 1 einschalten
OUT_HEIZLUFT_CLR EQU	0F7H	; UND	  Lueftung Stufe 1 ausschalten

	;****** Definitionen fuer CAN COMMAND_ZSTG_1 *************************

	; Bit 0 = MSTG Versorgung 12V
	; Bit 1 = Lueftung Heizung Stufe 1
	; Bit 2 = Steckdose
	; Bit 3 = Trennrelais
	; Bit 4 = Gong

CAN_MSTG12V_SET	 EQU	01H	; ODER	  Versorgung MSTG 12V einschalten
CAN_MSTG12V_CLR	 EQU	0FEH    ; UND     Versorgung MSTG 12V ausschalten

CAN_BEL_SET	 EQU	02H	; ODER	  Innenbeleuchtung einschalten
CAN_BEL_CLR	 EQU	0FDH	; UND	  Innenbeleuchtung ausschalten

CAN_DOSE_SET	 EQU	04H	; ODER	  Steckdose einschalten
CAN_DOSE_CLR	 EQU	0FBH	; UND	  Steckdose ausschalten

CAN_TRENN_SET	 EQU	08H	; ODER    Trennrelais einschalten (verbinden)
CAN_TRENN_CLR	 EQU	0F7H	; UND	  Trennrelais ausschalten (trennen)

	;****** Definitionen fuer Powerdownmanagement ************************

PDBIT02_DELAY_CYCLES	EQU	03H	; Abschaltverzoegerung MSTG aus
					; !! laeuft zusaetzlich im .2-Task !!
PDBIT03_DELAY_CYCLES	EQU	06H	; Abschaltverzoegerung HSTG sleep
					; !! laeuft zusaetzlich im .2-Task !!

	;****** Definitionen fuer EEPOT (erst ab Version 1.2) ****************

EEPOT_CS	BIT	p3.3		; Chip-Select fuer EEPOT
		
	;****** Definitionen fuer SPI ****************************************

SPI_SS		BIT	p1.4		; SPI, SS/
MOSI		BIT	p1.5		; SPI, MOSI (Dateneingang)
MISO		BIT	p1.6		; SPI, MISO (Datenausgang)
SPI_CLK		BIT	p1.7		; SPI, serial clock

	;****** Definitionen allgemein ***************************************

LED		BIT	p2.7		; Leuchtdiode

HIGH_MASK	EQU	00001111b	; High nibble wegmaskieren

ASCII_ADDZ	EQU	30H		; addieren bei Zahlen
ASCII_ADDB	EQU	37H		; addieren bei Buchstaben
ASCII_COMP	EQU	09H		; Vergleichswert Zahl / Buchstabe

	;****** Definitionen Taskschema **************************************
	; Beispiel: Teiler fuer Tasks die in jedem dritten Zyklus ausgefuehrt 
	; werden sollen muessen 03H sein
	
TASKNUMMER_TEMP		EQU	10H
TASKNUMMER_TEMP_OUT	EQU	11H
TASKNUMMER_DCF77	EQU	20H
TASKNUMMER_VOLTAMP	EQU	30H
TASKNUMMER_LLK_TEMP	EQU	40H
TASKNUMMER_LLK_DRUCK	EQU	41H
TASKNUMMER_OELTEMP	EQU	50H
TASKNUMMER_OELDRUCK	EQU	51H

TASKNUMMER_CANOUT	EQU	70H
TASKNUMMER_STANDBY	EQU	71H
TASKNUMMER_ERROR	EQU	01H
TASKNUMMER_ERROR_ZSTG	EQU	02H
TASKNUMMER_ERROR_MSTG	EQU	03H

TASKNUMMER_LEER		EQU	00H

	;****** Definitionen DCF77-Auswertung ********************************
	
DCF77_MASK_WEEKDAY	EQU	00000111b	; UND Maske fuer Wochentag
DCF77_MASK_DAY_10	EQU	00000011b	; UND Maske Tag Zehner
DCF77_MASK_DAY_01	EQU	00001111b	; UND Maske Tag Einer
DCF77_MASK_MONTH_10	EQU	00000001b	; UND Maske Monat Zehner
DCF77_MASK_MONTH_01	EQU	00001111b	; UND Maske Monat Einer
DCF77_MASK_YEAR_10	EQU	00001111b	; UND Maske Jahr Zehner
DCF77_MASK_YEAR_01	EQU	00001111b	; UND Maske Jahr Einer
DCF77_MASK_HOUR_10	EQU	00000011b	; UND Maske Stunden Zehner
DCF77_MASK_HOUR_01	EQU	00001111b	; UND Maske Stunden Einer
DCF77_MASK_MIN_10	EQU	00000111b	; UND Maske Minuten Zehner
DCF77_MASK_MIN_01	EQU	00001111b	; UND Maske Minuten Einer

	;****** Definitionen Menuesteuerung **********************************
	; Bitdefinitionen fr Tasten der Menuebedienung

BUTTON_UP		BIT	IN_TAST.7	; Taste am Anschluss H
						; Pfeil nach oben
BUTTON_DOWN		BIT	IN_TAST.5	; Taste am Anschluss F
						; Pfeil nach unten
BUTTON_OK		BIT	IN_TAST.6	; Taste am Anschluss G
						; OK- Taste
BUTTON_MENU		BIT	IN_TAST.4	; Taste am Anschluss E
						; MENU- Taste

BUTTON_P_UP		BIT	PRELL_BITS.7	; Taste am Anschluss H
						; Pfeil nach oben (entprellt)
BUTTON_P_DOWN		BIT	PRELL_BITS.5	; Taste am Anschluss F
						; Pfeil nach unten (entprellt)
BUTTON_P_OK		BIT	PRELL_BITS.6	; Taste am Anschluss G
						; OK- Taste (entprellt)
BUTTON_P_MENU		BIT	PRELL_BITS.4	; Taste am Anschluss E
						; MENU- Taste (entprellt)

;PRELL_COUNT_MAX	EQU	10H		; Endwert des Entprellzaehlers
						; --> soviele ununterbrochen 
						; von dieser Taste bis durch-
						; geschaltet wird
PRELL_COUNT_MAX		EQU	04H		; Endwert des Entprellzaehlers
						; --> soviele ununterbrochen 
						; von dieser Taste bis durch-
						; geschaltet wird
			; !! Pro ZYKLUS ein increment des Zaehlers !!

	;****** Definitionen Stackinitialisierung ****************************

STACK_INIT_VALUE	EQU	88H		; Initwert fuer Stackbereich
STACK_END_VALUE		EQU	55H		; Endemarkierung fuer Ueber-
						; wachung des Stackendes

	;****** Definitionen FehlerCodeworte *********************************

EW_STACK_OVERFLOW	EQU	07H	; Stack Overflow, Endemarkierung 
					; wurde ueberschrieben

EW_CAN_INI_MODE1	EQU	10H	; kein Reset-Mode des SJA1000
					; am Anfang von can_ini
EW_CAN_INI_MODE2	EQU	11H	; kein Operation-Mode des SJA1000
					; am Ende von can_ini
EW_CAN_TXBUF_NOT_REL	EQU	12H	; TX-Buffer not released am Ende von
					; Botschaftssendevorgang
EW_CAN_RX_OVERRUN	EQU	13H	; RX-Buffer overflow 
					; message was lost
;EW_INT_CANBUS_OFF	EQU	30H	; Interrupt vom CAN-Controller weil
					; CAN bus-off
;EW_INT_CANERROR	EQU	31H	; Interrupt vom CAN-Controller weil
					; allgemeiner Fehler
;EW_INT_CAN_UNKNOWN	EQU	32H	; Interrupt vom CAN-Controller aber
					; Flags nicht sinnvoll
;EW_INT_CAN_OVERFLOW	EQU	33H	; Interrupt vom CAN-Controller weil
					; berlauf, d.h. Datenverlust weil
					; nicht rechtzeitig abgeholt und 
					; daher ueberschrieben
;EW_INT_CAN_RX_WRONG	EQU	34H	; Der RX-Interrupt kam und der
					; Receive-Buffer-Status sagt "leer"

EW_CAN_IDENT		EQU	35H	; unbekannter Identifier angekommen
EW_CAN_RX_OVERLOAD	EQU	36H	; CAN-RX Routine kommt nicht mehr nach
					; (zuviele Empfangsbotschaften)
EW_CAN_RX_PD_OVERLOAD	EQU	37H	; CAN-FIFO-Buffer kann vor PowerDown 
					; nicht geleert werden

EW_IIC_NOT_READY	EQU	50H	; SCL und/oder SDA nicht high
					; IIC-Startbedingung nicht erfuellt
EW_IIC_BYTESEND_ACK	EQU	51H	; IIC-Bus-Fehler 
					; Kein Acknowledge nach ByteSend

EW_EEPROM_COMPARE	EQU	55H	; EEPROM Seitenvergleich bei Init
					; wies Fehler auf

EW_TAST_PRELL		EQU	60H	; unsinniger Zustand bei 
					; Tastenentprellung
EW_MODE_UNKNOWN		EQU	65H	; unbekannter Menuemode aufgetreten
EW_IDENT_UNKNOWN	EQU	66H	; unbekannter Identifier ausgewaehlt

EW_ZSTG_MISSING_INIT	EQU	70H	; keine Meldung (520 Botschaft) von
					; ZSTG bei Netzwerk-Init
EW_ZSTG_MISSING_ZYKL	EQU	71H	; keine Meldung (520 Botschaft) von
					; ZSTG waehrend zyklischem Betrieb
EW_MSTG_MISSING_INIT	EQU	72H	; keine Meldung (510 Botschaft) von
					; MSTG bei Netzwerk-Init
EW_MSTG_MISSING_ZYKL	EQU	73H	; keine Meldung (510 Botschaft) von
					; MSTG waehrend zyklischem Betrieb

EW_GEBLAESE_PLAUSI	EQU	80H	; Lueftungseinschaltanforderung
					; auf CAN obwohl Heizung nicht
					; angefordert

EW_STOP			EQU	0FFH	; auf Programmende STOP aufgelaufen	

	;****** Definitionen Timeoutzeiten ***********************************

TO_CAN_INI_MODE1	EQU	0FFH	; kein Reset-Mode des SJA1000 
					; am Anfang von can_ini
TO_CAN_INI_MODE2	EQU	0FFH	; kein Operation-Mode des SJA1000 
					; am Ende von can_ini
TO_CAN_TXBUF_NOT_REL	EQU	0FFH	; TX-Buffer not released am Ende von
					; Botschaftssendevorgang
TO_NETINI_SEARCH	EQU	05H	; ca. 5 Sekunden (maximal) nach jedem
					; Partnersteuergeraet suchen

;*****************************************************************************
; ENDE DES QUELLTEXTES
;*****************************************************************************

